/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding;

import weblogic.xml.schema.binding.ClassContext;
import weblogic.xml.schema.binding.ClassContextFactory;
import weblogic.xml.schema.binding.CodecBase;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.Deserializer;
import weblogic.xml.schema.binding.ModelGroupCompositor;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SchemaContext;
import weblogic.xml.schema.binding.SchemaContextFactory;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.Serializer;
import weblogic.xml.schema.binding.util.runtime.ObjectRefTable;
import weblogic.xml.schema.binding.util.runtime.PropertyInfo;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class BeanCodecBase
extends CodecBase {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private final Serializer[] serCache;
    private final Deserializer[] deserCache;

    protected BeanCodecBase() {
        int n = this.getPropertyCount();
        this.serCache = new Serializer[n];
        this.deserCache = new Deserializer[n];
    }

    protected abstract Object createObject();

    protected boolean isPropertySet(Object object, int n) {
        return true;
    }

    protected abstract Object invokeGetter(Object var1, int var2);

    protected abstract void invokeSetter(Object var1, int var2, Object var3);

    protected abstract ModelGroupCompositor getCompositor();

    protected int getChoiceProperty(Object object) {
        return -1;
    }

    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        try {
            Object object = null;
            if (!xMLInputStream.skip(2)) {
                throw new DeserializationException("invalid xml");
            }
            StartElement startElement = (StartElement)xMLInputStream.peek();
            XMLName xMLName2 = RuntimeUtils.getXsiType(startElement);
            if (xMLName2 != null && !xMLName2.equals(this.getXmlType())) {
                return RuntimeUtils.invoke_deserializer(xMLName, xMLName2, xMLInputStream, deserializationContext);
            }
            String string = BeanCodecBase.checkForRef(startElement);
            if (string != null) {
                return BeanCodecBase.deserializeReferredObject(string, this, xMLName, xMLInputStream, deserializationContext);
            }
            object = this.smartCreateObject(startElement, deserializationContext);
            if (object == null) {
                xMLInputStream.skipElement();
                return null;
            }
            this.processAttributes(object, startElement, deserializationContext);
            this.processElements(object, xMLInputStream, deserializationContext);
            return object;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException(xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    protected Object smartCreateObject(StartElement startElement, DeserializationContext deserializationContext) throws DeserializationException {
        boolean bl = RuntimeUtils.checkForXsiNil(startElement);
        Object object = bl ? null : this.createObject();
        String string = BeanCodecBase.checkForId(startElement);
        if (string != null) {
            deserializationContext.storeObjectWithReference(string, object);
        }
        return object;
    }

    protected void processElements(Object object, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException, XMLStreamException {
        XMLEvent xMLEvent = xMLInputStream.next();
        this.processAllElements(object, xMLInputStream, deserializationContext);
    }

    protected void processAllElements(Object object, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException, XMLStreamException {
        StartElement startElement = BeanCodecBase.getNextStartElement(xMLInputStream);
        while (startElement != null) {
            int n = this.findMatchingElementProperty(startElement.getName());
            if (n < 0) {
                xMLInputStream.skipElement();
            } else {
                Object object2 = this.processElement(n, xMLInputStream, deserializationContext);
                this.invokeSetter(object, n, object2);
            }
            startElement = BeanCodecBase.getNextStartElement(xMLInputStream);
        }
    }

    protected Object processElement(int n, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException, XMLStreamException {
        PropertyInfo propertyInfo = this.getPropertyInfo(n);
        XMLName xMLName = propertyInfo.getXmlName();
        Deserializer deserializer = this.getDeserializer(n, deserializationContext);
        return deserializer.deserialize(xMLName, xMLInputStream, deserializationContext);
    }

    private Deserializer getDeserializer(int n, DeserializationContext deserializationContext) throws DeserializationException {
        Deserializer deserializer = this.deserCache[n];
        if (deserializer == null) {
            PropertyInfo propertyInfo = this.getPropertyInfo(n);
            SchemaContext schemaContext = SchemaContextFactory.newInstance().createSchemaContext(propertyInfo.getJavaTypeName());
            this.deserCache[n] = deserializer = RuntimeUtils.lookup_deserializer(propertyInfo.getXmlType(), schemaContext, deserializationContext);
        }
        return deserializer;
    }

    protected void processAttribute(Object object, int n, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException, XMLStreamException {
        PropertyInfo propertyInfo = this.getPropertyInfo(n);
        Deserializer deserializer = this.getDeserializer(n, deserializationContext);
        Object object2 = deserializer.deserialize(propertyInfo.getXmlName(), attribute, deserializationContext);
        this.invokeSetter(object, n, object2);
    }

    protected void processAttributes(Object object, StartElement startElement, DeserializationContext deserializationContext) throws DeserializationException, XMLStreamException {
        deserializationContext.setCurrentPrefixToNamespaceMap(startElement.getNamespaceMap());
        AttributeIterator attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            XMLName xMLName = attribute.getName();
            int n = this.findMatchingAttributeProperty(xMLName);
            if (n < 0) continue;
            this.processAttribute(object, n, attribute, deserializationContext);
        }
    }

    protected int findMatchingElementProperty(XMLName xMLName) {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            PropertyInfo propertyInfo = this.getPropertyInfo(i);
            if (propertyInfo.isXmlAttribute() || !propertyInfo.getXmlName().getLocalName().equals(xMLName.getLocalName())) continue;
            return i;
        }
        return -1;
    }

    protected int findMatchingAttributeProperty(XMLName xMLName) {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            PropertyInfo propertyInfo = this.getPropertyInfo(i);
            if (!propertyInfo.isXmlAttribute() || !propertyInfo.getXmlName().getLocalName().equals(xMLName.getLocalName())) continue;
            return i;
        }
        return -1;
    }

    protected void gatherContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        int n = this.getPropertyCount();
        boolean bl = ModelGroupCompositor.CHOICE == this.getCompositor();
        int n2 = bl ? this.getChoiceProperty(object) : -1;
        for (int i = 0; i < n; ++i) {
            PropertyInfo propertyInfo;
            if (bl && i != n2 || (propertyInfo = this.getPropertyInfo(i)).isXmlAttribute() || !this.isPropertySet(object, i)) continue;
            Object object2 = this.invokeGetter(object, i);
            entry.addChild(object2);
            Serializer serializer = this.getSerializer(i, serializationContext);
            serializer.serialize(object2, propertyInfo.getXmlName(), xMLOutputStream, serializationContext);
        }
    }

    private Serializer getSerializer(int n, SerializationContext serializationContext) throws SerializationException {
        Serializer serializer = this.serCache[n];
        if (serializer == null) {
            PropertyInfo propertyInfo = this.getPropertyInfo(n);
            ClassContext classContext = ClassContextFactory.newInstance().createClassContext(propertyInfo.getXmlType());
            this.serCache[n] = serializer = RuntimeUtils.lookup_serializer(propertyInfo.getJavaType(), classContext, serializationContext);
        }
        return serializer;
    }

    protected void writeContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        this.writeAttributeContents(object, xMLOutputStream, serializationContext);
        this.writeElementContents(object, entry, xMLOutputStream, serializationContext);
    }

    protected void writeAttributeContents(Object object, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        int n = this.getPropertyCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            PropertyInfo propertyInfo = this.getPropertyInfo(i);
            if (!propertyInfo.isXmlAttribute() || !this.isPropertySet(object, i)) continue;
            Object object2 = this.invokeGetter(object, i);
            boolean bl2 = serializationContext.isQualifyElements();
            boolean bl3 = BeanCodecBase.qualifyElements(propertyInfo, serializationContext);
            serializationContext.setQualifyElements(bl3);
            serializationContext.setInAttribute(true);
            Serializer serializer = this.getSerializer(i, serializationContext);
            if (!bl3) {
                serializer.serialize(object2, propertyInfo.getXmlName(), xMLOutputStream, serializationContext);
            } else {
                ExpName expName = new ExpName(propertyInfo.getXmlName());
                String string = BeanCodecBase.fillPrefixDeclareNamespace(expName, xMLOutputStream, serializationContext);
                serializer.serialize(object2, expName, xMLOutputStream, serializationContext);
                if (string != null) {
                    serializationContext.getNamespacePrefixMap().remove(string);
                }
            }
            serializationContext.setQualifyElements(bl2);
        }
    }

    protected void writeElementContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        int n = this.getPropertyCount();
        boolean bl = ModelGroupCompositor.CHOICE == this.getCompositor();
        int n2 = bl ? this.getChoiceProperty(object) : -1;
        boolean bl2 = serializationContext.isQualifyElements();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            PropertyInfo propertyInfo;
            if (bl && i != n2 || (propertyInfo = this.getPropertyInfo(i)).isXmlAttribute() || !this.isPropertySet(object, i)) continue;
            Object object2 = entry == null ? this.invokeGetter(object, i) : entry.getChild(n3);
            ++n3;
            serializationContext.setQualifyElements(BeanCodecBase.qualifyElements(propertyInfo, serializationContext));
            serializationContext.setInAttribute(false);
            Serializer serializer = this.getSerializer(i, serializationContext);
            serializer.serialize(object2, propertyInfo.getXmlName(), xMLOutputStream, serializationContext);
        }
        serializationContext.setQualifyElements(bl2);
    }

    private static boolean qualifyElements(PropertyInfo propertyInfo, SerializationContext serializationContext) {
        if (CodecBase.QUALIFIED_TOP_LEVEL_ELE_ONLY && BeanCodecBase.isSoapEncoding(serializationContext)) {
            return false;
        }
        return propertyInfo.isFormQualified();
    }
}

