/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import weblogic.utils.collections.CircularQueue;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.babel.stream.XMLInputStreamFactoryImpl;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.StartElementEvent;
import weblogic.xml.stream.util.TypeFilter;

public class XMLOutputStreamBase
implements XMLOutputStream {
    protected CircularQueue elementQ = null;
    protected XMLWriter xmlWriter = new XMLWriter();
    protected int maxBufferSize = 256;
    protected StartElementEvent lastStartElement = null;
    private boolean writeEmptyTags = false;

    public XMLOutputStreamBase() {
    }

    public XMLOutputStreamBase(XMLWriter xMLWriter) {
        this.xmlWriter = xMLWriter;
    }

    public void setWriteEmptyTags(boolean bl) {
        this.writeEmptyTags = bl;
    }

    public XMLOutputStreamBase(Writer writer) {
        this.setWriter(writer);
    }

    public void setMaxBufferSize(int n) {
        this.maxBufferSize = n;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setWriter(Writer writer) {
        this.xmlWriter.setWriter(writer);
    }

    protected boolean writeXMLEvent(XMLEvent xMLEvent) throws XMLStreamException {
        return this.xmlWriter.write(xMLEvent);
    }

    protected boolean write() throws XMLStreamException {
        if (this.elementQ == null) {
            return false;
        }
        if (this.xmlWriter == null) {
            throw new XMLStreamException("Atttempt to write XML Stream without setting the java.io.Writer.");
        }
        while (!this.elementQ.isEmpty()) {
            if (this.writeEmptyTags) {
                XMLEvent xMLEvent = (XMLEvent)this.elementQ.remove();
                XMLEvent xMLEvent2 = (XMLEvent)this.elementQ.peek();
                if (xMLEvent.isStartElement() && xMLEvent2 != null && xMLEvent2.isEndElement()) {
                    this.xmlWriter.writeEmpty((StartElement)xMLEvent);
                    this.elementQ.remove();
                    continue;
                }
                this.writeXMLEvent(xMLEvent);
                continue;
            }
            this.writeXMLEvent((XMLEvent)this.elementQ.remove());
        }
        return true;
    }

    protected void addXMLEvent(XMLEvent xMLEvent) throws XMLStreamException {
        if (this.elementQ == null) {
            this.elementQ = new CircularQueue(8);
        }
        if (xMLEvent.isStartElement()) {
            this.lastStartElement = !(xMLEvent instanceof StartElementEvent) ? new StartElementEvent((StartElement)xMLEvent) : (StartElementEvent)xMLEvent;
            this.elementQ.add(this.lastStartElement);
            return;
        }
        this.lastStartElement = null;
        this.elementQ.add(xMLEvent);
        if (this.elementQ.size() > this.maxBufferSize) {
            this.flush();
        }
    }

    public void add(Attribute attribute) throws XMLStreamException {
        if (this.lastStartElement == null) {
            throw new XMLStreamException("Attempt to add an attribute to a null start element");
        }
        if (this.isNamespace(attribute)) {
            this.lastStartElement.addNamespace(attribute);
        } else {
            this.lastStartElement.addAttribute(attribute);
        }
    }

    private boolean isNamespace(Attribute attribute) {
        XMLName xMLName = attribute.getName();
        if (xMLName == null) {
            return false;
        }
        String string = xMLName.getPrefix();
        if (string != null && "xmlns".equals(string)) {
            return true;
        }
        String string2 = xMLName.getLocalName();
        return string == null && string2 != null && "xmlns".equals(string2);
    }

    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        this.addXMLEvent(xMLEvent);
    }

    public void add(XMLInputStream xMLInputStream) throws XMLStreamException {
        while (xMLInputStream.hasNext()) {
            this.addXMLEvent(xMLInputStream.next());
        }
    }

    public void add(String string) throws XMLStreamException {
        new XMLInputStreamFactoryImpl();
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactoryImpl.newInstance();
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newInputStream(new StringReader(string), (ElementFilter)new TypeFilter(8318));
        this.add(xMLInputStream);
    }

    public void close(boolean bl) throws XMLStreamException {
        this.flush(bl);
        this.elementQ = null;
    }

    public void close() throws XMLStreamException {
        this.close(true);
    }

    private void flush(boolean bl) throws XMLStreamException {
        this.lastStartElement = null;
        this.write();
        if (bl) {
            this.xmlWriter.flush();
        }
    }

    public void flush() throws XMLStreamException {
        this.flush(true);
    }

    public static void main(String[] stringArray) throws Exception {
        XMLWriter xMLWriter = XMLWriter.getSymmetricWriter(new PrintWriter(System.out, true));
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.open(SAXElementFactory.createInputSource(stringArray[0]));
        XMLOutputStreamBase xMLOutputStreamBase = new XMLOutputStreamBase(xMLWriter);
        xMLOutputStreamBase.add(xMLInputStreamBase);
        xMLOutputStreamBase.flush();
    }
}

