/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.util.Comparator;
import java.util.TreeMap;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;

public class CanonicalUtils {
    public static String normalizeCharacters(String string, boolean bl) {
        if (string.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        block9: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    if (!bl) {
                        stringBuffer.append("&gt;");
                        continue block9;
                    }
                    stringBuffer.append('>');
                    continue block9;
                }
                case '\t': {
                    if (bl) {
                        stringBuffer.append("&#x9;");
                        continue block9;
                    }
                    stringBuffer.append('\t');
                    continue block9;
                }
                case '\n': {
                    if (bl) {
                        stringBuffer.append("&#xA;");
                        continue block9;
                    }
                    stringBuffer.append('\n');
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    continue block9;
                }
                case '\"': {
                    if (bl) {
                        stringBuffer.append("&quot;");
                        continue block9;
                    }
                    stringBuffer.append('\"');
                    continue block9;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static AttributeIterator sortNamespaces(AttributeIterator attributeIterator, AttributeIterator attributeIterator2) {
        Attribute attribute;
        TreeMap<String, Attribute> treeMap = new TreeMap<String, Attribute>();
        while (attributeIterator.hasNext()) {
            attribute = attributeIterator.next();
            treeMap.put(attribute.getName().getQualifiedName(), attribute);
        }
        while (attributeIterator2.hasNext()) {
            attribute = attributeIterator2.next();
            treeMap.put(attribute.getName().getQualifiedName(), attribute);
        }
        return ElementFactory.createAttributeIterator(treeMap.values().iterator());
    }

    public static AttributeIterator sortNamespaces(AttributeIterator attributeIterator) {
        TreeMap<String, Attribute> treeMap = new TreeMap<String, Attribute>();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            treeMap.put(attribute.getName().getQualifiedName(), attribute);
        }
        return ElementFactory.createAttributeIterator(treeMap.values().iterator());
    }

    public static AttributeIterator sortAttributes(AttributeIterator attributeIterator) {
        TreeMap<XMLName, Attribute> treeMap = new TreeMap<XMLName, Attribute>(new Comparator(){

            public int compare(Object object, Object object2) {
                XMLName xMLName = (XMLName)object;
                XMLName xMLName2 = (XMLName)object2;
                String string = xMLName.getNamespaceUri();
                String string2 = xMLName2.getNamespaceUri();
                if (string == null && string2 != null) {
                    return -1;
                }
                if (string2 == null && string != null) {
                    return 1;
                }
                int n = 0;
                if (string != null && string2 != null) {
                    n = string.compareTo(string2);
                }
                if (n == 0) {
                    n = xMLName.getLocalName().compareTo(xMLName2.getLocalName());
                }
                return n;
            }
        });
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            treeMap.put(attribute.getName(), attribute);
        }
        return ElementFactory.createAttributeIterator(treeMap.values().iterator());
    }
}

