/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

public final class Trie {
    public static final int ALPHA_SIZE = 128;
    private final Node m_Root = new Node();
    private int size = 1;

    public int size() {
        return this.size;
    }

    public Object put(String string, Object object) {
        int n = string.length();
        Node node = this.m_Root;
        for (int i = 0; i < n; ++i) {
            try {
                Node node2 = node.m_nextChar[string.charAt(i)];
                if (node2 != null) {
                    node = node2;
                    continue;
                }
                while (i < n) {
                    Node node3 = new Node();
                    ++this.size;
                    node.m_nextChar[string.charAt((int)i)] = node3;
                    node = node3;
                    ++i;
                }
                break;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        Object object2 = node.m_Value;
        node.m_Value = object;
        return object2;
    }

    public Object get(char[] cArray, int n, int n2) {
        int n3 = n2;
        Node node = this.m_Root;
        for (int i = 0; i < n3; ++i) {
            char c = cArray[n + i];
            if (c >= '\u0080') {
                return null;
            }
            node = node.m_nextChar[c];
            if (node != null) continue;
            return null;
        }
        return node.m_Value;
    }

    public Object get(String string) {
        int n = string.length();
        Node node = this.m_Root;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080') {
                return null;
            }
            node = node.m_nextChar[c];
            if (node != null) continue;
            return null;
        }
        return node.m_Value;
    }

    private static class Node {
        final Node[] m_nextChar = new Node[128];
        Object m_Value = null;

        Node() {
        }
    }
}

