/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import weblogic.xml.babel.scanner.Token;
import weblogic.xml.babel.scanner.Trie;

final class TokenFactory {
    private Trie namedTokens;
    private Trie prefixTokens = new Trie();
    private Trie spaceTokens;
    private final int maxTrieSize = 1024;
    private Token[] delimeterTokens;

    public TokenFactory() {
        this.namedTokens = new Trie();
        this.spaceTokens = new Trie();
        this.delimeterTokens = new Token[60];
    }

    public void init() {
        if (this.prefixTokens.size() > 1024) {
            this.prefixTokens = new Trie();
        }
        if (this.namedTokens.size() > 1024) {
            this.namedTokens = new Trie();
        }
        if (this.spaceTokens.size() > 1024) {
            this.spaceTokens = new Trie();
        }
    }

    public Token createEOF() {
        return new Token(-1);
    }

    public Token createToken(int n) {
        Token token = this.delimeterTokens[n];
        if (token == null) {
            token = new Token(n);
            if (n >= 0) {
                this.delimeterTokens[n] = token;
            }
        }
        return token;
    }

    public Token createToken(int n, String string) {
        Token token;
        switch (n) {
            case 0: {
                token = (Token)this.namedTokens.get(string);
                if (token != null) break;
                token = new Token(n, string);
                this.namedTokens.put(string, token);
                break;
            }
            default: {
                token = new Token(n, string);
            }
        }
        return token;
    }

    public Token createStoredToken(int n, char[] cArray, int n2, int n3) {
        Token token;
        switch (n) {
            case 19: {
                token = (Token)this.spaceTokens.get(cArray, n2, n3);
                if (token != null) break;
                String string = new String(cArray, n2, n3);
                token = new Token(n, cArray, n2, n3);
                this.spaceTokens.put(string, token);
                break;
            }
            case 18: {
                token = (Token)this.prefixTokens.get(cArray, n2, n3);
                if (token != null) break;
                String string = new String(cArray, n2, n3);
                token = new Token(n, string);
                this.prefixTokens.put(string, token);
                break;
            }
            case 0: {
                token = (Token)this.namedTokens.get(cArray, n2, n3);
                if (token != null) break;
                String string = new String(cArray, n2, n3);
                token = new Token(n, string);
                this.namedTokens.put(string, token);
                break;
            }
            default: {
                String string = new String(cArray, n2, n3);
                token = new Token(n, string);
            }
        }
        return token;
    }

    public Token createToken(int n, int n2, String string) {
        Token token = this.createToken(n, string);
        token.subType = n2;
        return token;
    }

    public Token createToken(int n, int n2, char c) {
        char[] cArray = new char[]{c};
        String string = new String(cArray);
        Token token = this.createToken(n, string);
        token.subType = n2;
        return token;
    }

    public Token createToken(int n, char[] cArray, int n2, int n3) {
        return new Token(n, cArray, n2, n3);
    }
}

