/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.reader.XmlChars;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;
import weblogic.xml.babel.scanner.Trie;

final class Space {
    private ScannerState state;
    private char[] spaceInput;
    private int bufSize;
    private boolean ignore = true;
    private Trie values;

    Space(ScannerState scannerState) {
        this.state = scannerState;
        this.bufSize = 32;
        this.spaceInput = new char[this.bufSize];
        this.values = new Trie();
    }

    public void init() {
        this.spaceInput = new char[this.bufSize];
        this.values = new Trie();
    }

    char[] alloc(char[] cArray, int n) {
        char[] cArray2 = (char[])this.values.get(cArray, 0, n);
        if (cArray2 == null) {
            char[] cArray3 = new char[n];
            System.arraycopy(cArray, 0, cArray3, 0, n);
            this.values.put(new String(cArray, 0, n), cArray3);
            return cArray3;
        }
        return cArray2;
    }

    void read() throws IOException, ScannerException {
        int n = 0;
        while (XmlChars.isSpace(this.state.currentChar)) {
            if (n >= this.bufSize) {
                this.spaceInput = this.state.addToBuffer(this.spaceInput, 32);
            }
            if (this.state.currentChar == '\r') {
                this.spaceInput[n] = 10;
                ++n;
                this.state.read();
                if (!XmlChars.isSpace(this.state.currentChar)) {
                    this.state.pushToken(this.state.tokenFactory.createStoredToken(19, this.alloc(this.spaceInput, n), 0, n));
                    return;
                }
                if (this.state.currentChar != '\n') continue;
                this.state.read();
                continue;
            }
            this.spaceInput[n] = this.state.currentChar;
            this.state.read();
            ++n;
        }
        this.state.pushToken(this.state.tokenFactory.createStoredToken(19, this.alloc(this.spaceInput, n), 0, n));
    }

    void skipRead() throws IOException, ScannerException {
        while (XmlChars.isSpace(this.state.currentChar)) {
            this.state.read();
        }
        this.state.pushToken(this.state.tokenFactory.createToken(19, " "));
    }
}

