/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import java.util.HashMap;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.xml.babel.baseparser.BaseEntityResolver;
import weblogic.xml.babel.dtd.DTDException;
import weblogic.xml.babel.dtd.EntityTable;
import weblogic.xml.babel.dtd.ExternalID;
import weblogic.xml.babel.scanner.Name;
import weblogic.xml.babel.scanner.Scanner;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;
import weblogic.xml.babel.scanner.Token;

final class Reference {
    private ScannerState state;
    private Name name;
    private HashMap escapedCharacters;
    private boolean inDTD;

    Reference(ScannerState scannerState) {
        this.state = scannerState;
        this.name = new Name(scannerState);
        this.escapedCharacters = new HashMap();
        this.escapedCharacters.put("amp", "&");
        this.escapedCharacters.put("lt", "<");
        this.escapedCharacters.put("gt", ">");
        this.escapedCharacters.put("quot", "\"");
        this.escapedCharacters.put("apos", "'");
        this.inDTD = false;
    }

    void setInDTD(boolean bl) {
        this.inDTD = bl;
    }

    void skipZero() throws IOException, ScannerException {
        while (true) {
            if (this.state.currentChar == ';') {
                return;
            }
            if (this.state.currentChar != '0') break;
            this.state.read();
        }
    }

    void read() throws IOException, ScannerException {
        block23: {
            this.state.markInsert();
            this.state.expect('&');
            if (this.state.currentChar == '#') {
                this.state.read();
                if (this.state.currentChar == 'x') {
                    this.state.read();
                    this.skipZero();
                    if (Reference.isHex(this.state.currentChar)) {
                        int n = 0;
                        this.state.mark();
                        this.state.read();
                        ++n;
                        while (Reference.isHex(this.state.currentChar)) {
                            this.state.read();
                            ++n;
                        }
                        this.state.expect(';');
                        try {
                            char c = (char)Integer.parseInt(this.state.getString(n), 16);
                            this.state.pushToken(this.state.tokenFactory.createToken(15, 21, c));
                        }
                        catch (Exception exception) {
                            throw new ScannerException(" Invalid character reference '" + this.state.getString(n) + "'", this.state);
                        }
                        this.state.unMarkInsert();
                        return;
                    }
                    throw new ScannerException(" [0-9a-zA-Z] expected, got '" + this.state.currentChar + "'", this.state);
                }
                if (Reference.isNum(this.state.currentChar)) {
                    this.skipZero();
                    int n = 0;
                    this.state.mark();
                    this.state.read();
                    ++n;
                    while (Reference.isNum(this.state.currentChar)) {
                        this.state.read();
                        ++n;
                    }
                    this.state.expect(';');
                    try {
                        char c = (char)Integer.parseInt(this.state.getString(n));
                        this.state.pushToken(this.state.tokenFactory.createToken(15, 22, c));
                    }
                    catch (Exception exception) {
                        throw new ScannerException(" Invalid character reference '" + this.state.getString(n) + "'", this.state);
                    }
                    this.state.unMarkInsert();
                    return;
                }
                throw new ScannerException("Line:" + this.state.currentLine + " [0-9] expected, got '" + this.state.currentChar + "'");
            }
            String string = this.name.stringRead();
            String string2 = (String)this.escapedCharacters.get(string);
            this.state.expect(';');
            EntityTable entityTable = this.state.getInternalEntityTable();
            EntityTable entityTable2 = this.state.getExternalEntityTable();
            if (string2 != null) {
                this.state.pushToken(this.state.tokenFactory.createToken(14, string2));
                this.state.unMarkInsert();
            } else if (this.inDTD) {
                this.state.pushToken(this.state.tokenFactory.createToken(14, "&" + string + ";"));
                this.state.unMarkInsert();
            } else {
                if (entityTable2 != null && entityTable2.contains(string)) {
                    try {
                        ExternalID externalID = entityTable2.getExternalID(string);
                        try {
                            BaseEntityResolver baseEntityResolver = this.state.getBaseEntityResolver();
                            InputSource inputSource = baseEntityResolver.resolveEntity(externalID.getPubidLiteral(), externalID.getSystemLiteral());
                            Scanner scanner = this.state.createScanner(inputSource);
                            Token token = scanner.scan();
                            while (token != null && !token.isEOF()) {
                                this.state.pushToken(token.duplicate());
                                token = scanner.scan();
                            }
                            break block23;
                        }
                        catch (SAXException sAXException) {
                            throw new ScannerException("Unable to resolve entity: '" + string + "' ", this.state);
                        }
                    }
                    catch (DTDException dTDException) {
                        throw new ScannerException(" Unknown entity reference: '" + string + "' ", this.state);
                    }
                }
                this.state.deleteFromLastInsertionPoint();
                try {
                    if (entityTable == null) {
                        throw new ScannerException(" Unknown entity reference: '" + string + "' ", this.state);
                    }
                    this.state.insertData(entityTable.get(string).toCharArray());
                }
                catch (DTDException dTDException) {
                    System.out.println("-----------------TABLE REF---------------");
                    System.out.println(entityTable);
                    System.out.println("-----------------TABLE REF---------------");
                    System.out.println(dTDException);
                    throw new ScannerException(" Unknown entity reference: '" + string + "' ", this.state);
                }
            }
        }
    }

    private static boolean isNum(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHex(char c) {
        return Reference.isNum(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }
}

