/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

final class IntegerQueue {
    int[] items;
    int capacity;
    int head;
    int tail;
    int numItems;

    IntegerQueue() {
        this.capacity = 128;
        this.head = 0;
        this.tail = 0;
        this.numItems = 0;
        this.items = new int[this.capacity];
    }

    IntegerQueue(int n) {
        this.capacity = n;
        this.numItems = 0;
        this.head = 0;
        this.tail = 0;
        this.items = new int[n];
    }

    final int[] reallocate(int[] nArray) {
        this.capacity = nArray.length * 2;
        int[] nArray2 = new int[nArray.length * 2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    final void shift() {
        for (int i = 0; i < this.numItems; ++i) {
            this.items[i] = this.items[i + this.head];
        }
        this.head = 0;
        this.tail = this.head + this.numItems;
    }

    final void add(int n) {
        if (this.tail >= this.capacity) {
            this.shift();
        }
        if (this.numItems >= this.capacity) {
            this.items = this.reallocate(this.items);
        }
        this.items[this.tail] = n;
        ++this.tail;
        ++this.numItems;
    }

    final int remove() {
        if (this.numItems == 0) {
            return -1;
        }
        int n = this.items[this.head];
        ++this.head;
        --this.numItems;
        return n;
    }

    final int get() {
        if (this.numItems == 0) {
            return -1;
        }
        return this.items[this.head];
    }

    final void clear() {
        this.numItems = 0;
        this.head = 0;
        this.tail = 0;
    }

    public static final void main(String[] stringArray) {
        int n;
        IntegerQueue integerQueue = new IntegerQueue(8);
        for (n = 0; n < 20; ++n) {
            integerQueue.add(n);
            System.out.println("Putting:" + n);
        }
        for (n = 0; n < 20; ++n) {
            System.out.println("Getting:" + integerQueue.remove());
        }
    }
}

