/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.parsers;

import java.io.IOException;
import java.io.Reader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.xml.babel.adapters.ElementConsumer;
import weblogic.xml.babel.adapters.ElementFactory;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.ProcessingInstruction;
import weblogic.xml.babel.parsers.XMLStreamParser;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.EndDocumentEvent;
import weblogic.xml.stream.events.StartDocumentEvent;

public class XMLInputStreamParser
extends BaseParser
implements XMLStreamParser {
    protected boolean reachedEOF = false;
    protected ElementFactory inputStreamFactory;
    protected ElementConsumer inputStreamConsumer;

    public XMLInputStreamParser(InputSource inputSource, ElementFactory elementFactory, ElementConsumer elementConsumer) throws IOException, XMLStreamException {
        try {
            this.inputStreamFactory = elementFactory;
            this.inputStreamFactory.setBaseParser(this);
            this.inputStreamConsumer = elementConsumer;
            this.init(inputSource);
            this.primeXMLDecl();
        }
        catch (ScannerException scannerException) {
            throw (XMLStreamException)this.inputStreamFactory.create(scannerException);
        }
    }

    public void recycleStream(Reader reader) throws XMLStreamException {
        try {
            this.reachedEOF = false;
            this.recycle(reader);
        }
        catch (ScannerException scannerException) {
            throw (XMLStreamException)this.inputStreamFactory.create(scannerException);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        this.primeXMLDecl();
    }

    private void primeXMLDecl() throws XMLStreamException {
        try {
            Element element = this.internalParseSome();
            if (element == null || element.type == 9) {
                this.reachedEOF = true;
                return;
            }
            StartDocumentEvent startDocumentEvent = new StartDocumentEvent();
            if (element.type == 4) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)element;
                if (processingInstruction.isXMLDecl()) {
                    startDocumentEvent.setVersion(processingInstruction.getVersion());
                    startDocumentEvent.setEncoding(processingInstruction.getEncoding());
                    startDocumentEvent.setStandalone(processingInstruction.getStandalone());
                    this.inputStreamConsumer.addFirst(startDocumentEvent);
                } else {
                    this.inputStreamConsumer.addFirst(startDocumentEvent);
                    this.inputStreamConsumer.add(this.inputStreamFactory.dispatch(element));
                }
            } else {
                this.inputStreamConsumer.addFirst(startDocumentEvent);
                this.inputStreamConsumer.add(this.inputStreamFactory.dispatch(element));
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    protected void putNamespaceURI(String string, String string2) throws SAXException {
        super.putNamespaceURI(string, string2);
        this.inputStreamConsumer.add(this.inputStreamFactory.create(string, string2));
    }

    protected void removeNamespaceURI(Object[] objectArray) throws SAXException {
        super.removeNamespaceURI(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            PrefixMapping prefixMapping = (PrefixMapping)objectArray[i];
            if (prefixMapping.getUri() == null) {
                this.inputStreamConsumer.add(this.inputStreamFactory.create(prefixMapping.getPrefix()));
                continue;
            }
            this.inputStreamConsumer.add(this.inputStreamFactory.create(prefixMapping));
        }
    }

    public boolean hasNext() {
        boolean bl;
        if (this.reachedEOF) {
            return false;
        }
        boolean bl2 = bl = !this.getCurrentToken().isEOF();
        if (!bl && !this.reachedEOF) {
            this.reachedEOF = true;
            this.inputStreamConsumer.add(new EndDocumentEvent());
            return true;
        }
        return bl;
    }

    protected Element internalParseSome() throws XMLStreamException {
        try {
            Element element = super.parseSome();
            return element;
        }
        catch (ScannerException scannerException) {
            throw (XMLStreamException)this.inputStreamFactory.create(scannerException);
        }
        catch (ParseException parseException) {
            throw (XMLStreamException)this.inputStreamFactory.create(parseException);
        }
        catch (IOException iOException) {
            throw (XMLStreamException)this.inputStreamFactory.create(iOException);
        }
    }

    public boolean streamParseSome() throws XMLStreamException {
        try {
            Element element = this.internalParseSome();
            if (element != null) {
                this.inputStreamConsumer.add(this.inputStreamFactory.dispatch(element));
                if (element.type == 3) {
                    this.removeNamespaceURI(this.outOfScopeNameSpace);
                }
                return true;
            }
            return false;
        }
        catch (SAXException sAXException) {
            throw (XMLStreamException)this.inputStreamFactory.create(sAXException);
        }
    }
}

