/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.utils.collections.Stack;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.Symbol;
import weblogic.xml.babel.baseparser.SymbolTableException;

public class SymbolTable {
    private int depth = 0;
    private Stack table = new Stack();
    private Map values = new HashMap();
    private static final Object[] NullObjectArray = new Object[0];

    public void clear() {
        this.depth = 0;
        this.table.clear();
        this.values.clear();
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean withinElement() {
        return this.depth > 0;
    }

    public void put(String string, String string2) {
        this.table.push(new Symbol(string, string2, this.depth));
        if (!this.values.containsKey(string)) {
            Stack stack = new Stack();
            stack.push(string2);
            this.values.put(string, stack);
        } else {
            Stack stack = (Stack)this.values.get(string);
            stack.push(string2);
        }
    }

    public String get(String string) throws SymbolTableException {
        Stack stack = (Stack)this.values.get(string);
        if (stack == null || stack.isEmpty()) {
            throw new SymbolTableException("Undefined Symbol:" + string);
        }
        return (String)stack.peek();
    }

    public void openScope() {
        ++this.depth;
    }

    public Object[] closeScope() {
        ArrayList<PrefixMapping> arrayList = null;
        Symbol symbol = (Symbol)this.table.peek();
        int n = symbol.depth;
        while (n == this.depth && !this.table.isEmpty()) {
            symbol = (Symbol)this.table.pop();
            Stack stack = (Stack)this.values.get(symbol.name);
            String string = (String)stack.pop();
            String string2 = null;
            if (!stack.isEmpty()) {
                string2 = (String)stack.peek();
            }
            if (arrayList == null) {
                arrayList = new ArrayList<PrefixMapping>();
            }
            arrayList.add(new PrefixMapping(symbol.name, string2, string));
            if (this.table.isEmpty()) break;
            symbol = (Symbol)this.table.peek();
            n = symbol.depth;
        }
        --this.depth;
        if (arrayList == null) {
            return NullObjectArray;
        }
        return arrayList.toArray();
    }

    public String toString() {
        Iterator iterator = this.table.iterator();
        String string = "";
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            string = string + symbol + "\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            SymbolTable symbolTable = new SymbolTable();
            symbolTable.openScope();
            symbolTable.put("x", "foo");
            symbolTable.put("y", "bar");
            System.out.println("1 x:" + symbolTable.get("x"));
            System.out.println("1 y:" + symbolTable.get("y"));
            symbolTable.openScope();
            symbolTable.put("x", "bar");
            symbolTable.put("y", "foo");
            symbolTable.openScope();
            symbolTable.put("x", "barbie");
            symbolTable.openScope();
            symbolTable.closeScope();
            System.out.println("3 x:" + symbolTable.get("x"));
            symbolTable.closeScope();
            System.out.println("2 x:" + symbolTable.get("x"));
            System.out.println("2 y:" + symbolTable.get("y"));
            System.out.print(symbolTable);
            symbolTable.closeScope();
            System.out.println("1 x:" + symbolTable.get("x"));
            System.out.println("1 y:" + symbolTable.get("y"));
            symbolTable.closeScope();
            System.out.print(symbolTable);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

