/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.io.IOException;
import org.xml.sax.SAXException;
import weblogic.utils.UnsyncStringBuffer;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.Token;

public class Attribute
extends Element {
    UnsyncStringBuffer value;
    boolean isXMLNS;
    boolean declaresDefaultNameSpace;
    private int type = 11;

    public void init() {
        super.init();
        this.value = new UnsyncStringBuffer();
        this.isXMLNS = false;
        this.declaresDefaultNameSpace = false;
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        switch (baseParser.currentToken.tokenType) {
            case 18: {
                this.prefix = baseParser.currentToken.text;
                if (this.isNameSpace(this.prefix)) {
                    this.isXMLNS = true;
                }
                baseParser.accept();
                this.name = baseParser.currentToken.text;
                baseParser.accept(0);
                break;
            }
            case 0: {
                this.name = baseParser.currentToken.text;
                if (this.isNameSpace(this.name)) {
                    this.declaresDefaultNameSpace = true;
                }
                baseParser.accept();
                break;
            }
            default: {
                throw new ParseException("Expected a NAME", baseParser.getLine(), baseParser.currentToken);
            }
        }
        while (baseParser.compare(13) || baseParser.compare(14) || baseParser.compare(15) || baseParser.compare(19)) {
            if (baseParser.compare(15)) {
                this.value.append(baseParser.currentToken.text);
            } else if (baseParser.compare(14)) {
                this.value.append(this.normalizeReferenceSpace(baseParser.currentToken.text));
            } else if (baseParser.compare(19)) {
                this.value.append(" ");
            } else {
                this.value.append(baseParser.currentToken.textArray, baseParser.currentToken.start, baseParser.currentToken.length);
            }
            baseParser.accept();
        }
        try {
            if (this.isXMLNS) {
                baseParser.putNamespaceURI(this.name, this.value.toString());
            }
            if (this.declaresDefaultNameSpace) {
                baseParser.setDefaultNameSpace(this.value.toString());
            }
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException.getMessage());
        }
    }

    private String normalizeReferenceSpace(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[i] = cArray[i] == '\t' || cArray[i] == '\r' || cArray[i] == '\n' ? 32 : cArray[i];
        }
        return new String(cArray2);
    }

    public String normalizeSpace(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        char[] cArray2 = new char[n2];
        int n3 = 0;
        for (n = 0; n < n2 && cArray[n] == ' '; ++n) {
        }
        while (n < n2) {
            boolean bl = false;
            while (n < n2 && cArray[n] == ' ') {
                ++n;
                bl = true;
            }
            if (bl) {
                cArray2[n3] = 32;
            } else {
                cArray2[n3] = cArray[n];
                ++n;
            }
            ++n3;
        }
        if (n3 > 0) {
            while (cArray2[n3 - 1] == ' ') {
                --n3;
            }
        }
        return new String(cArray2, 0, n3);
    }

    boolean isNameSpace(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return false;
        }
        return string.equals("xmlns");
    }

    public boolean isNameSpaceDeclaration() {
        return this.isXMLNS;
    }

    public boolean declaresDefaultNameSpace() {
        return this.declaresDefaultNameSpace;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setValue(String string) {
        this.value.setLength(0);
        this.value.append(string);
    }

    public String getValue() {
        return this.value.toString();
    }

    protected boolean setNameSpace(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        if (!this.isXMLNS && !this.declaresDefaultNameSpace) {
            return super.setNameSpace(baseParser);
        }
        return false;
    }

    public String toString() {
        return " " + this.getName() + "[" + Token.getString(this.type) + "]=" + "\"" + this.value + "\"";
    }
}

