/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.tools.wsdlp;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import weblogic.webservice.Message;
import weblogic.webservice.Operation;
import weblogic.webservice.Part;
import weblogic.webservice.Port;
import weblogic.webservice.WebService;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.binding.https.HttpsBindingInfo;
import weblogic.webservice.binding.jms.JMSBindingInfo;
import weblogic.webservice.core.FaultMessage;
import weblogic.webservice.core.encoding.DefaultRegistry;
import weblogic.webservice.tools.wsdlp.DefinitionFactory;
import weblogic.webservice.tools.wsdlp.ParameterModeHelper;
import weblogic.webservice.tools.wsdlp.WSDLParseException;
import weblogic.webservice.util.AttachmentUtil;
import weblogic.xml.schema.binding.util.StdNamespace;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.security.specs.SecurityDD;
import weblogic.xml.security.specs.SecuritySpec;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.events.Name;
import weblogic.xml.xmlnode.XMLNode;

public class WSDLParser {
    private XMLNode definition;
    private String serviceName;
    private TypeMappingRegistry registry;
    public static final String SOAP11 = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP12 = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String SOAP12_ENC = "http://www.w3.org/2003/05/soap-envelope";
    public static final String wsdlNS = StdNamespace.instance().wsdl();
    private static final String mimeNS = "http://schemas.xmlsoap.org/wsdl/mime/";
    private String defaultEncodingStyle = StdNamespace.instance().soapEncoding();
    private String soapNS = "http://schemas.xmlsoap.org/wsdl/soap/";
    private ParameterModeHelper parameterModeHelper = new ParameterModeHelper();
    private boolean implicitConversation = true;

    public WSDLParser(String string) throws IOException {
        DefinitionFactory definitionFactory = new DefinitionFactory();
        this.definition = definitionFactory.createDefinition(string);
        try {
            this.registry = new DefaultRegistry();
        }
        catch (JAXRPCException jAXRPCException) {
            throw new WSDLParseException("failed to create type mapping registry");
        }
        if (!"definitions".equals(this.definition.getName().getLocalName())) {
            this.assertion(null, "first element is not definitions");
        }
    }

    public void visit(WebService webService) throws IOException {
        if (webService.getTypeMappingRegistry() == null) {
            webService.setTypeMappingRegistry(this.registry);
        } else {
            this.registry = webService.getTypeMappingRegistry();
        }
        this.parseDefinition(webService);
    }

    public void setImplicitConversation(boolean bl) {
        this.implicitConversation = bl;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    private void parseDefinition(WebService webService) throws IOException {
        webService.setTargetNamespace(this.definition.getAttribute("targetNamespace", null));
        XMLNode xMLNode = this.definition.getChild("types", wsdlNS);
        this.parseTypes(webService, xMLNode);
        XMLNode xMLNode2 = this.getService(this.definition);
        this.parseService(webService, xMLNode2);
    }

    private void parseTypes(WebService webService, XMLNode xMLNode) throws IOException {
        if (xMLNode != null) {
            Iterator iterator = xMLNode.getChildren();
            while (iterator.hasNext()) {
                XMLNode xMLNode2 = (XMLNode)iterator.next();
                xMLNode2.inheritNamespace();
            }
            webService.setTypes(xMLNode);
        }
    }

    private XMLNode getService(XMLNode xMLNode) throws IOException {
        Object object = xMLNode.getChildren();
        while (object.hasNext()) {
            XMLNode xMLNode2 = (XMLNode)object.next();
            if (!"service".equals(xMLNode2.getName().getLocalName())) continue;
            if (this.serviceName == null) {
                return xMLNode2;
            }
            String string = xMLNode2.getAttribute("name", null);
            if (!this.serviceName.equals(string)) continue;
            return xMLNode2;
        }
        object = "unable to find service";
        object = this.serviceName == null ? object : (String)object + " \"" + this.serviceName + "\"";
        throw new WSDLParseException((String)object);
    }

    private void parseService(WebService webService, XMLNode xMLNode) throws IOException {
        webService.setName(this.getMustAttribute("name", xMLNode));
        boolean bl = false;
        Iterator iterator = xMLNode.getChildren();
        while (iterator.hasNext()) {
            XMLNode xMLNode2 = (XMLNode)iterator.next();
            if (!this.canParsePort(xMLNode2)) continue;
            bl = true;
            this.parsePort(webService, xMLNode2);
        }
        if (!bl) {
            throw new WSDLParseException("unable to find any soap port:" + xMLNode);
        }
    }

    private boolean canParsePort(XMLNode xMLNode) {
        if ("port".equals(xMLNode.getName().getLocalName())) {
            XMLNode xMLNode2 = xMLNode.getChild("address", SOAP11);
            if (xMLNode2 != null) {
                this.soapNS = SOAP11;
                return true;
            }
            xMLNode2 = xMLNode.getChild("address", SOAP12);
            if (xMLNode2 != null) {
                this.soapNS = SOAP12;
                return true;
            }
        }
        return false;
    }

    private void parsePort(WebService webService, XMLNode xMLNode) throws IOException {
        String string = this.getMustAttribute("binding", xMLNode);
        XMLNode xMLNode2 = this.getNodeWithName("binding", string, this.definition);
        this.assertion(xMLNode2, "binding not found" + string);
        XMLNode xMLNode3 = xMLNode.getChild("address", this.soapNS);
        this.assertion(xMLNode3, "unable to find soap address");
        String string2 = this.getMustAttribute("location", xMLNode3);
        Port port = webService.addPort(this.getMustAttribute("name", xMLNode));
        String string3 = this.removePrefix(this.getMustAttribute("type", xMLNode2));
        port.setTypeName(string3);
        this.parseBinding(webService, port, xMLNode2);
        String string4 = "http";
        if (string2.indexOf(":") != -1) {
            string4 = string2.substring(0, string2.indexOf(58));
        }
        webService.setProtocol(string4);
        if ("https".equals(string4)) {
            port.setBindingInfo(new HttpsBindingInfo());
        }
        port.getBindingInfo().setAddress(string2);
        if (SOAP11.equals(this.soapNS)) {
            port.getBindingInfo().setType("SOAP1.1");
        }
        if (SOAP12.equals(this.soapNS)) {
            port.getBindingInfo().setType("SOAP1.2");
        }
    }

    private void parseBinding(WebService webService, Port port, XMLNode xMLNode) throws IOException {
        String string = this.getMustAttribute("type", xMLNode);
        XMLNode xMLNode2 = this.getNodeWithName("portType", string, this.definition);
        this.assertion(xMLNode2, "portType not found:" + string);
        XMLNode xMLNode3 = xMLNode.getChild("binding", this.soapNS);
        this.assertion(xMLNode3, "soap binding not found");
        String string2 = this.parseSoapBinding(port, xMLNode3);
        this.parseSecBindingExtension(webService, xMLNode);
        Iterator iterator = xMLNode2.getChildren();
        while (iterator.hasNext()) {
            XMLNode xMLNode4 = (XMLNode)iterator.next();
            String string3 = this.getMustAttribute("name", xMLNode4);
            if (this.isNotification(xMLNode4) || this.isSolicitResponse(xMLNode4)) {
                System.err.print("WARNING: Skipping operation[" + string3);
                System.err.print("] clientgen does not support notification or ");
                System.err.println("solicit-response WSDL operations yet");
                continue;
            }
            XMLNode xMLNode5 = this.getNodeWithName("operation", string3, xMLNode);
            this.assertion(xMLNode5, "binding.operation not found:" + string3);
            Operation operation = port.addOperation(string3);
            this.parseOperation(operation, xMLNode4);
            this.parseBindingOperation(string2, operation, xMLNode5);
            this.parameterModeHelper.updateParameterMode(operation);
            if (!operation.isDocumentStyle()) continue;
            operation.setParameterOrder(new String[0]);
        }
    }

    private String parseSoapBinding(Port port, XMLNode xMLNode) throws WSDLParseException {
        String string = this.getMustAttribute("transport", xMLNode);
        String string2 = xMLNode.getAttribute("style", null);
        if (string2 == null) {
            string2 = "document";
        }
        port.setStyle(string2);
        if (string.equals("http://schemas.xmlsoap.org/soap/http") || string.equals("http://schemas.xmlsoap.org/soap/http/") || string.equals("http://schemas.xmlsoap.org/soap12/http") || string.equals("http://schemas.xmlsoap.org/soap12/http/")) {
            port.setBindingInfo(new BindingInfo());
        } else if ("http://www.openuri.org/2002/04/soap/jms/".equals(string)) {
            port.setBindingInfo(new JMSBindingInfo());
        } else {
            throw new WSDLParseException("transport not supported:" + string);
        }
        return string2;
    }

    private void parseSecBindingExtension(WebService webService, XMLNode xMLNode) throws IOException {
        Iterator iterator = xMLNode.getChildren("SecuritySpec", "http://www.openuri.org/2002/11/wsse/spec");
        SecurityDD securityDD = null;
        while (iterator.hasNext()) {
            XMLNode xMLNode2 = (XMLNode)iterator.next();
            SecuritySpec securitySpec = new SecuritySpec(xMLNode2.stream());
            if (securityDD == null) {
                securityDD = new SecurityDD(securitySpec);
                continue;
            }
            securityDD.addSecuritySpec(securitySpec);
        }
        webService.setSecurity(securityDD);
    }

    private void parseOperation(Operation operation, XMLNode xMLNode) throws WSDLParseException {
        Object object;
        Object object2;
        Object object3;
        operation.setParameterOrder(xMLNode.getAttribute("parameterOrder", null));
        XMLNode xMLNode2 = xMLNode.getChild("input", wsdlNS);
        if (xMLNode2 != null) {
            object3 = this.getMustAttribute("message", xMLNode2);
            object2 = this.getNodeWithName("message", (String)object3, this.definition);
            this.assertion(object2, "message not found:" + (String)object3);
            this.parseMessage(operation.getInput(), (XMLNode)object2, false);
        }
        if ((object3 = xMLNode.getChild("output", wsdlNS)) != null) {
            object2 = this.getMustAttribute("message", (XMLNode)object3);
            object = this.getNodeWithName("message", (String)object2, this.definition);
            this.assertion(object, "message not found:" + (String)object2);
            this.parseMessage(operation.getOutput(), (XMLNode)object, false);
        } else {
            operation.setOneway(true);
        }
        object2 = new Name(wsdlNS, "fault");
        object = xMLNode.getChildren((XMLName)object2);
        while (object.hasNext()) {
            XMLNode xMLNode3 = (XMLNode)object.next();
            String string = this.getMustAttribute("name", xMLNode3);
            String string2 = this.getMustAttribute("message", xMLNode3);
            XMLNode xMLNode4 = this.getNodeWithName("message", string2, this.definition);
            this.assertion(xMLNode4, "message not found:" + string2);
            FaultMessage faultMessage = (FaultMessage)operation.addFault();
            faultMessage.setName(this.removePrefix(string2));
            faultMessage.setFaultName(string);
            this.parseMessage(faultMessage, xMLNode4, false);
            if (faultMessage.getParts().hasNext()) continue;
            throw new WSDLParseException("Fault message " + string + " Must have a single part.");
        }
    }

    private void parseMessage(Message message, XMLNode xMLNode, boolean bl) throws WSDLParseException {
        Iterator iterator = xMLNode.getChildren();
        while (iterator.hasNext()) {
            XMLNode xMLNode2 = (XMLNode)iterator.next();
            if ("documentation".equals(xMLNode2.getName().getLocalName())) continue;
            this.parsePart(message, xMLNode2, bl);
        }
    }

    public static XMLName createXMLNameFromXMLType(QName qName) {
        ExpName expName = new ExpName(qName.getNamespaceURI(), qName.getLocalPart());
        return expName;
    }

    private void parsePart(Message message, XMLNode xMLNode, boolean bl) throws WSDLParseException {
        boolean bl2 = true;
        String string = this.getMustAttribute("name", xMLNode);
        String string2 = xMLNode.getAttribute("type", null);
        if (string2 == null) {
            bl2 = false;
            string2 = this.getMustAttribute("element", xMLNode);
        }
        String string3 = this.getNamespace(string2, xMLNode);
        String string4 = this.removePrefix(string2);
        String string5 = message.getEncodingStyle();
        if (string5 == null) {
            string5 = this.defaultEncodingStyle;
        }
        TypeMapping typeMapping = this.registry.getTypeMapping(string5);
        this.assertion(typeMapping, "encoding style not supported" + string5);
        Part part = message.getPart(string);
        if (part != null && !string4.equals(part.getXMLName().getLocalName())) {
            string = string + string4;
            part = message.addPart(string, string4, string3);
        }
        if (part == null) {
            part = message.addPart(string, string4, string3);
        }
        if (bl2) {
            part.setType();
        } else {
            part.setElement();
        }
        if (bl) {
            part.setHeader();
        }
    }

    private String getNamespace(String string, XMLNode xMLNode) {
        int n = string.indexOf(":");
        String string2 = n == -1 ? "" : string.substring(0, n);
        return xMLNode.getNamespaceURI(string2);
    }

    private void parseBindingOperation(String string, Operation operation, XMLNode xMLNode) throws WSDLParseException {
        Object object;
        Object object2;
        XMLNode xMLNode2 = xMLNode.getChild("operation", this.soapNS);
        if (xMLNode2 != null) {
            object2 = xMLNode2.getAttribute("soapAction", null);
            if (object2 != null) {
                operation.setSoapAction((String)object2);
            }
            if ((object = xMLNode2.getAttribute("style", null)) == null) {
                object = string;
            }
            if ("rpc".equals(object)) {
                operation.setRpcStyle();
            }
            if ("document".equals(object)) {
                operation.setDocumentStyle();
            }
        }
        this.parseReliabilityExtension(operation, xMLNode);
        this.parseConversationPhase(operation, xMLNode);
        object2 = xMLNode.getChild("input", wsdlNS);
        if (object2 != null) {
            this.parseBindingMessage((XMLNode)object2, operation, operation.getInput());
        }
        if ((object = xMLNode.getChild("output", wsdlNS)) != null) {
            this.parseBindingMessage((XMLNode)object, operation, operation.getOutput());
        }
        Name name = new Name(wsdlNS, "fault");
        Iterator iterator = xMLNode.getChildren(name);
        while (iterator.hasNext()) {
            XMLNode xMLNode3 = (XMLNode)iterator.next();
            if (!xMLNode3.getChildren().hasNext()) {
                this.assertion(null, "There is no child found for wsdl:fault in binding operation " + xMLNode);
            }
            String string2 = ((XMLNode)xMLNode3.getChildren().next()).getAttribute("name", null);
            this.assertion(string2, "There is no name attribute found for soap:fault in binding operation " + xMLNode);
            FaultMessage faultMessage = null;
            Iterator iterator2 = operation.getFaults();
            while (iterator2.hasNext() && !string2.equals((faultMessage = (FaultMessage)iterator2.next()).getFaultName())) {
                faultMessage = null;
            }
            this.assertion(faultMessage, "wsdl:fault with name " + string2 + " in wsdl:binding is not found in portType");
            this.parseBindingMessage(xMLNode3, operation, faultMessage);
        }
    }

    private void parseReliabilityExtension(Operation operation, XMLNode xMLNode) throws WSDLParseException {
        XMLNode xMLNode2 = xMLNode.getChild("reliability", "http://www.openuri.org/2002/10/soap/reliability/");
        if (xMLNode2 != null) {
            String string = this.getMustAttribute("persistDuration", xMLNode2);
            operation.setPersistDurationTime(Integer.parseInt(string));
        }
    }

    private void parseConversationPhase(Operation operation, XMLNode xMLNode) throws WSDLParseException {
        XMLNode xMLNode2 = xMLNode.getChild("transition", "http://www.openuri.org/2002/04/wsdl/conversation/");
        if (xMLNode2 != null) {
            String string = this.getMustAttribute("phase", xMLNode2);
            if ("continue".equals(string)) {
                operation.setConversationPhase("CONTINUE");
            } else if ("start".equals(string)) {
                operation.setConversationPhase("START");
            } else if ("finish".equals(string)) {
                operation.setConversationPhase("FINISH");
            } else {
                throw new WSDLParseException("unknown conversation phase \"" + string + "\"");
            }
        }
    }

    private void parseBindingMessage(XMLNode xMLNode, Operation operation, Message message) throws WSDLParseException {
        XMLNode xMLNode2;
        XMLNode xMLNode3 = xMLNode.getChild("multipartRelated", mimeNS);
        XMLNode xMLNode4 = null;
        XMLNode xMLNode5 = null;
        Iterator iterator = null;
        if (xMLNode3 == null) {
            xMLNode4 = xMLNode.getChild("body", this.soapNS);
            xMLNode5 = xMLNode.getChild("fault", this.soapNS);
        } else {
            message.setContainsAttachment(true);
            iterator = xMLNode3.getChildren();
            if (iterator.hasNext()) {
                xMLNode2 = (XMLNode)iterator.next();
                this.assertion(xMLNode2, "mime:part not found inside mime:multipartRelated");
                xMLNode4 = xMLNode2.getChild("body", this.soapNS);
                xMLNode5 = xMLNode2.getChild("fault", this.soapNS);
            }
        }
        if (xMLNode4 == null && xMLNode5 == null) {
            this.assertion(null, "unable to find soap:body or soap:fault inside binding operation:" + xMLNode);
        }
        this.populateSecSpecRef(operation, message, xMLNode);
        this.populateMessage(message, xMLNode4 != null ? xMLNode4 : xMLNode5);
        this.populateHeader(operation, message, xMLNode);
        while (iterator != null && iterator.hasNext()) {
            xMLNode2 = (XMLNode)iterator.next();
            if (!"part".equals(xMLNode2.getName().getLocalName())) continue;
            Iterator iterator2 = xMLNode2.getChildren();
            while (iterator2.hasNext()) {
                XMLNode xMLNode6 = (XMLNode)iterator2.next();
                if (!"content".equals(xMLNode6.getName().getLocalName())) continue;
                String string = this.getMustAttribute("part", xMLNode6);
                String string2 = this.getMustAttribute("type", xMLNode6);
                Part part = message.getPart(string);
                this.assertion(part, "unable to find part:" + string);
                part.setAttachment();
                part.addContentType(string2);
                Class clazz = AttachmentUtil.getJavaType(string2);
                part.setJavaType(clazz);
            }
        }
    }

    private void populateSecSpecRef(Operation operation, Message message, XMLNode xMLNode) throws WSDLParseException {
        XMLNode xMLNode2 = xMLNode.getChild("SecuritySpecRef", "http://www.openuri.org/2002/11/wsse/spec");
        if (xMLNode2 != null) {
            String string = xMLNode2.getAttribute("RefId", null);
            if (operation.getPort().getService().getSecurity() == null || operation.getPort().getService().getSecurity().getSecuritySpec(string) == null) {
                throw new WSDLParseException("Operation " + operation.getName() + " is trying to refer to " + "a undefined security spec named " + string);
            }
            message.setSecuritySpecRef(string);
        }
    }

    private void populateHeader(Operation operation, Message message, XMLNode xMLNode) throws WSDLParseException {
        Iterator iterator = xMLNode.getChildren();
        while (iterator.hasNext()) {
            XMLNode xMLNode2 = (XMLNode)iterator.next();
            if (!"header".equals(xMLNode2.getName().getLocalName()) || !this.soapNS.equals(xMLNode2.getName().getNamespaceUri())) continue;
            String string = this.getMustAttribute("message", xMLNode2);
            String string2 = this.getMustAttribute("part", xMLNode2);
            if ("ContinueHeader".equals(string2) && (string.endsWith("ContinueHeader_rpc") || string.endsWith("ContinueHeader_literal")) ? this.implicitConversation : ("StartHeader".equals(string2) && (string.endsWith("StartHeader_rpc") || string.endsWith("StartHeader_literal")) ? this.implicitConversation : "FinishHeader".equals(string2) && (string.endsWith("FinishHeader_rpc") || string.endsWith("FinishHeader_literal")) && this.implicitConversation)) continue;
            XMLNode xMLNode3 = this.getNodeWithName("message", string, this.definition);
            this.assertion(xMLNode3, "message not found:" + string);
            String string3 = this.getMustAttribute("part", xMLNode2);
            XMLNode xMLNode4 = this.getNodeWithName("part", string3, xMLNode3);
            this.assertion(xMLNode4, "part [" + string3 + "] not found inside " + "the message:" + string);
            this.parsePart(message, xMLNode4, true);
        }
    }

    private void populateMessage(Message message, XMLNode xMLNode) {
        String string = xMLNode.getAttribute("encodingStyle", null);
        String string2 = xMLNode.getAttribute("use", null);
        if ("literal".equals(string2)) {
            message.useLiteral();
        }
        if ("encoded".equals(string2)) {
            message.useEncoded();
        }
        if (string != null) {
            message.setEncodingStyle(string);
        }
        message.setNamespace(xMLNode.getAttribute("namespace", null));
    }

    private XMLNode getNodeWithName(String string, String string2, XMLNode xMLNode) {
        string2 = this.removePrefix(string2);
        Iterator iterator = xMLNode.getChildren();
        while (iterator.hasNext()) {
            XMLNode xMLNode2 = (XMLNode)iterator.next();
            if (!string.equals(xMLNode2.getName().getLocalName()) || !string2.equals(xMLNode2.getAttribute("name", null))) continue;
            return xMLNode2;
        }
        return null;
    }

    private String removePrefix(String string) {
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    private String getMustAttribute(String string, XMLNode xMLNode) throws WSDLParseException {
        String string2 = xMLNode.getAttribute(string, null);
        if (string2 == null) {
            throw new WSDLParseException("ERROR[WSDL Parser] Attribute '" + string + "' not found at:" + xMLNode);
        }
        return string2;
    }

    private void assertion(Object object, String string) throws WSDLParseException {
        if (object == null) {
            throw new WSDLParseException("ERROR[WSDL Parser]:" + string);
        }
    }

    private boolean isSolicitResponse(XMLNode xMLNode) {
        Iterator iterator = xMLNode.getChildren();
        if (!iterator.hasNext()) {
            return false;
        }
        while (iterator.hasNext()) {
            XMLNode xMLNode2 = (XMLNode)iterator.next();
            if ("input".equals(xMLNode2.getName().getLocalName())) {
                return false;
            }
            if (!"output".equals(xMLNode2.getName().getLocalName())) continue;
            return true;
        }
        return false;
    }

    private boolean isNotification(XMLNode xMLNode) {
        Iterator iterator = xMLNode.getChildren();
        if (!iterator.hasNext()) {
            return false;
        }
        while (iterator.hasNext()) {
            XMLNode xMLNode2 = (XMLNode)iterator.next();
            if (!"input".equals(xMLNode2.getName().getLocalName())) continue;
            return false;
        }
        return true;
    }
}

