/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.saf;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import weblogic.utils.Debug;
import weblogic.webservice.GenericHandler;
import weblogic.webservice.ReliableDelivery;
import weblogic.webservice.saf.ReliableMessagingConstants;
import weblogic.webservice.saf.SAFAgent;
import weblogic.webservice.saf.StoreForwardException;
import weblogic.webservice.saf.WSSAFAgent;

public final class SendingHandler
extends GenericHandler
implements ReliableMessagingConstants {
    private SAFAgent saf;
    private static boolean debug = false;

    public void init(HandlerInfo handlerInfo) {
        super.init(handlerInfo);
        debug = "true".equalsIgnoreCase(System.getProperty("weblogic.webservice.reliable.verbose")) || "true".equalsIgnoreCase(System.getProperty("weblogic.webservice.reliable.debug")) || debug;
        this.saf = WSSAFAgent.getSAFAgent();
    }

    public boolean handleRequest(MessageContext messageContext) throws JAXRPCException {
        if (debug) {
            Debug.say("** handleRequest called");
        }
        String string = (String)messageContext.getProperty("__BEA_INTERNAL_MSG_ID");
        String string2 = (String)messageContext.getProperty("__BEA_INTERNAL_CONV_ID");
        String string3 = (String)messageContext.getProperty("__BEA_INTERNAL_SEQ_NUM");
        Long l = (Long)messageContext.getProperty("__BEA_INTERNAL_PERSIST_DUR");
        long l2 = l;
        ReliableDelivery reliableDelivery = (ReliableDelivery)messageContext.getProperty("__BEA_PRIVATE_RELIABLE_PROP");
        try {
            this.saf.store(string, string2, string3, messageContext, reliableDelivery, l2);
            if (debug) {
                Debug.say("*** Sucessfully stored the message:  messageId = " + string + "***");
            }
            return false;
        }
        catch (StoreForwardException storeForwardException) {
            throw new JAXRPCException("Failed to store the message", storeForwardException);
        }
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (debug) {
            Debug.say("** handleResponse called");
        }
        return true;
    }
}

