/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.saf;

import java.util.HashSet;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.webservice.saf.MessageReference;

abstract class Conversation
implements ExecuteRequest {
    protected HashSet messages;
    protected int numWaiting;
    protected boolean running;
    protected boolean ordered;
    protected String id;
    protected MessageReference firstMessage;
    protected MessageReference lastMessage;
    protected long persistDuration;
    protected boolean seenLastMsg;
    protected int msgCount;
    protected static boolean debug = false;

    Conversation(String string, boolean bl) {
        this.id = string;
        this.ordered = bl;
        this.messages = new HashSet();
        debug = "true".equalsIgnoreCase(System.getProperty("weblogic.webservice.reliable.verbose")) || debug;
    }

    abstract void addMessage(String var1, int var2, Object var3);

    abstract void removeMessage(MessageReference var1);

    abstract void close();

    abstract void run();

    public abstract void execute(ExecuteThread var1);

    protected void addMessageToList(MessageReference messageReference) {
        if (messageReference == null) {
            return;
        }
        if (this.firstMessage == null) {
            this.firstMessage = messageReference;
            this.lastMessage = messageReference;
        } else {
            this.lastMessage.setNext(messageReference);
            messageReference.setPrev(this.lastMessage);
            this.lastMessage = messageReference;
        }
        ++this.msgCount;
    }

    protected void addMessageToListInorder(MessageReference messageReference) {
        MessageReference messageReference2;
        if (messageReference == null) {
            return;
        }
        ++this.msgCount;
        if (this.firstMessage == null) {
            this.firstMessage = messageReference;
            this.lastMessage = messageReference;
            return;
        }
        for (messageReference2 = this.firstMessage; messageReference2 != this.lastMessage && messageReference2.getSequenceNumber() <= messageReference.getSequenceNumber(); messageReference2 = messageReference2.getNext()) {
        }
        if (messageReference2 == this.lastMessage) {
            this.lastMessage.setNext(messageReference);
            messageReference.setPrev(this.lastMessage);
            this.lastMessage = messageReference;
            return;
        }
        messageReference.setNext(messageReference2);
        messageReference.setPrev(messageReference2.getPrev());
        if (messageReference2.getPrev() != null) {
            messageReference2.getPrev().setNext(messageReference);
        }
        messageReference2.setPrev(messageReference);
    }

    protected void removeMessageFromList(MessageReference messageReference) {
        if (messageReference == null) {
            return;
        }
        if (messageReference == this.firstMessage) {
            this.firstMessage = messageReference.getNext();
            messageReference.setPrev(null);
            if (messageReference == this.lastMessage) {
                this.lastMessage = this.firstMessage;
            }
        } else {
            if (messageReference.getNext() != null) {
                messageReference.getNext().setPrev(messageReference.getPrev());
            }
            if (messageReference.getPrev() != null) {
                messageReference.getPrev().setNext(messageReference.getNext());
            }
        }
        --this.msgCount;
    }

    final boolean isOrdered() {
        return this.ordered;
    }

    final boolean isEmpty() {
        return this.firstMessage == null;
    }

    final boolean isDone() {
        return this.firstMessage == null && this.seenLastMsg;
    }

    String getId() {
        return this.id;
    }

    void setSeenLastMsg(boolean bl) {
        this.seenLastMsg = bl;
    }

    void putMessage(String string) {
        this.messages.add(string);
    }

    HashSet getMessages() {
        return this.messages;
    }
}

