/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.rpc.JAXRPCException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import weblogic.utils.CharsetMap;
import weblogic.utils.io.XMLDeclaration;
import weblogic.webservice.encoding.AttachmentCodec;
import weblogic.xml.schema.binding.util.runtime.ByteList;
import weblogic.xml.schema.binding.util.runtime.CharList;

public class XMLSourceCodec
extends AttachmentCodec {
    protected String xmlEncoding = "UTF-8";

    protected Object deserializeContent(Object object) {
        String string = (String)object;
        return new StreamSource(new StringReader(string));
    }

    protected String getContentType() {
        return "text/xml; charset=" + this.xmlEncoding;
    }

    protected Object serializeContent(Object object) {
        Object object2;
        Object object3;
        Object object4;
        if (!(object instanceof SAXSource || object instanceof StreamSource || object instanceof DOMSource)) {
            throw new JAXRPCException("unable to serialize[" + object + "]. " + "input should be of type " + "javax.xml.transform.stream.StreamSource, " + "javax.xml.transform.sax.SAXSource, or " + "javax.xml.transform.dom.DOMSource");
        }
        String string = null;
        if (object instanceof SAXSource) {
            object4 = SAXSource.sourceToInputSource((SAXSource)object);
            if (object4 != null) {
                object3 = ((InputSource)object4).getCharacterStream();
                if (object3 != null) {
                    this.getXMLEncoding((Reader)object3);
                    string = this.getString((Reader)object3);
                } else {
                    object2 = ((InputSource)object4).getByteStream();
                    if (object2 != null) {
                        string = this.getString((InputStream)object2);
                    }
                }
            }
        } else if (object instanceof StreamSource) {
            object4 = ((StreamSource)object).getReader();
            if (object4 != null) {
                this.getXMLEncoding((Reader)object4);
                string = this.getString((Reader)object4);
            } else {
                object3 = ((StreamSource)object).getInputStream();
                if (object3 != null) {
                    string = this.getString((InputStream)object3);
                }
            }
        }
        if (object instanceof DOMSource || string == null) {
            object4 = new ByteArrayOutputStream();
            object3 = null;
            try {
                object3 = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new JAXRPCException(transformerConfigurationException);
            }
            object2 = new StreamResult((OutputStream)object4);
            try {
                ((Transformer)object3).transform((Source)object, (Result)object2);
            }
            catch (TransformerException transformerException) {
                throw new JAXRPCException("failed to transform:" + transformerException, transformerException);
            }
            byte[] byArray = ((ByteArrayOutputStream)object4).toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                String string2 = XMLSourceCodec.getXMLEncoding(byteArrayInputStream);
                string = this.getString(byArray, string2);
            }
            catch (IOException iOException) {
                throw new JAXRPCException("failed to get xml encoding:" + iOException);
            }
            finally {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    private static String getXMLEncoding(InputStream inputStream) throws IOException {
        String string = null;
        if (inputStream.markSupported()) {
            inputStream.mark(4080);
            XMLDeclaration xMLDeclaration = new XMLDeclaration();
            xMLDeclaration.parse(inputStream);
            string = xMLDeclaration.getEncoding();
            inputStream.reset();
        }
        return string;
    }

    private void getXMLEncoding(Reader reader) {
        String string = null;
        if (reader.markSupported()) {
            try {
                reader.mark(4080);
                XMLDeclaration xMLDeclaration = new XMLDeclaration();
                xMLDeclaration.parse(reader);
                string = xMLDeclaration.getEncoding();
                reader.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string != null) {
            this.xmlEncoding = string;
        }
    }

    private String getString(Reader reader) throws JAXRPCException {
        CharList charList = new CharList();
        try {
            int n = reader.read();
            while (n != -1) {
                charList.add((char)n);
                n = reader.read();
            }
        }
        catch (IOException iOException) {
            throw new JAXRPCException("failed to get xml from input stream:" + iOException);
        }
        return new String(charList.getMinSizedArray());
    }

    private String getString(InputStream inputStream) throws JAXRPCException {
        String string;
        ByteList byteList = new ByteList();
        try {
            string = XMLSourceCodec.getXMLEncoding(inputStream);
        }
        catch (IOException iOException) {
            throw new JAXRPCException("failed to get xml encoding:" + iOException);
        }
        try {
            int n = inputStream.read();
            while (n != -1) {
                byteList.add((byte)n);
                n = inputStream.read();
            }
        }
        catch (IOException iOException) {
            throw new JAXRPCException("failed to get xml from input stream:" + iOException);
        }
        return this.getString(byteList.getMinSizedArray(), string);
    }

    private String getString(byte[] byArray, String string) {
        String string2;
        if (string != null) {
            this.xmlEncoding = string;
        }
        String string3 = CharsetMap.getJavaFromIANA(this.xmlEncoding);
        try {
            string2 = string3 != null ? new String(byArray, string3) : new String(byArray, "UTF-8");
        }
        catch (IOException iOException) {
            throw new JAXRPCException("failed to get xml from bytes:" + iOException);
        }
        return string2;
    }
}

