/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.encoding;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.webservice.encoding.AttachmentCodec;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.stream.XMLName;

public class MimeMultipartCodec
extends AttachmentCodec {
    protected String getContentType() {
        throw new Error("should not be called");
    }

    protected Object serializeContent(Object object) {
        throw new Error("should not be called");
    }

    protected Object deserializeContent(Object object) {
        throw new Error("should not be called");
    }

    protected Object deserialize(XMLName xMLName, SOAPMessage sOAPMessage, DeserializationContext deserializationContext) throws JAXRPCException {
        AttachmentPart attachmentPart = this.getAttachmentPart(xMLName, sOAPMessage, deserializationContext);
        if (attachmentPart == null) {
            return null;
        }
        try {
            MimeMultipart mimeMultipart = (MimeMultipart)attachmentPart.getContent();
            return mimeMultipart;
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("unable to deserialize", sOAPException);
        }
    }

    protected void serialize(Object object, XMLName xMLName, SOAPMessage sOAPMessage, SerializationContext serializationContext) throws SOAPFaultException {
        try {
            this.addBodyElement(xMLName, sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("failed to serialize the attachment " + xMLName, sOAPException);
        }
        if (object == null) {
            return;
        }
        MimeMultipart mimeMultipart = (MimeMultipart)object;
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
        attachmentPart.setContent(mimeMultipart, mimeMultipart.getContentType());
        attachmentPart.setContentId("<" + xMLName.getLocalName() + ">");
        try {
            int n = mimeMultipart.getCount();
            for (int i = 0; i < n; ++i) {
                MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(i);
                String string = mimeBodyPart.getDataHandler().getContentType();
                mimeBodyPart.setHeader("Content-Type", string);
            }
        }
        catch (MessagingException messagingException) {
            throw new JAXRPCException("failed to set the contentType to the attachment part", messagingException);
        }
        sOAPMessage.addAttachmentPart(attachmentPart);
    }
}

