/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.encoding;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.rpc.JAXRPCException;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.encoding.AttachmentCodec;
import weblogic.webservice.encoding.ImageCodec;

public class ImageArrayCodec
extends AttachmentCodec {
    private ImageCodec codec = new ImageCodec();

    protected Object deserializeContent(Object object) {
        MimeMultipart mimeMultipart = (MimeMultipart)object;
        try {
            int n = mimeMultipart.getCount();
            ArrayList<Image> arrayList = new ArrayList<Image>();
            for (int i = 0; i < n; ++i) {
                BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                Object object2 = bodyPart.getContent();
                Image image = (Image)this.codec.deserializeContent(object2);
                arrayList.add(image);
            }
            return arrayList.toArray(new Image[arrayList.size()]);
        }
        catch (MessagingException messagingException) {
            String string = WebServiceLogger.logImageEncodingMessageException();
            WebServiceLogger.logStackTrace(string, messagingException);
            throw new JAXRPCException("failed to deserialize mime multipart", messagingException);
        }
        catch (IOException iOException) {
            String string = WebServiceLogger.logImageEncodingIOException();
            WebServiceLogger.logStackTrace(string, iOException);
            throw new JAXRPCException("failed to deserialize mime multipart", iOException);
        }
    }

    protected String getContentType() {
        return "multipart/*";
    }

    protected Object serializeContent(Object object) {
        if (!(object instanceof Image[])) {
            throw new JAXRPCException("input is not Image[] :" + object);
        }
        Image[] imageArray = (Image[])object;
        MimeMultipart mimeMultipart = new MimeMultipart();
        for (int i = 0; i < imageArray.length; ++i) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            DataHandler dataHandler = new DataHandler(this.codec.serializeContent(imageArray[i]), "text/xml");
            try {
                mimeBodyPart.setDataHandler(dataHandler);
                mimeMultipart.addBodyPart(mimeBodyPart, i);
                continue;
            }
            catch (MessagingException messagingException) {
                throw new JAXRPCException("failed to set data handler " + messagingException, messagingException);
            }
        }
        return mimeMultipart;
    }
}

