/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.encoding;

import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.webservice.encoding.AttachmentCodec;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.stream.XMLName;

public class DataHandlerArrayCodec
extends AttachmentCodec {
    protected String getContentType() {
        throw new Error("should not be called");
    }

    protected Object serializeContent(Object object) {
        throw new Error("should not be called");
    }

    protected Object deserializeContent(Object object) {
        throw new Error("should not be called");
    }

    protected Object deserialize(XMLName xMLName, SOAPMessage sOAPMessage, DeserializationContext deserializationContext) {
        AttachmentPart attachmentPart = this.getAttachmentPart(xMLName, sOAPMessage, deserializationContext);
        if (attachmentPart == null) {
            return null;
        }
        try {
            MimeMultipart mimeMultipart = (MimeMultipart)attachmentPart.getContent();
            ArrayList<DataHandler> arrayList = new ArrayList<DataHandler>();
            for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                DataHandler dataHandler = bodyPart.getDataHandler();
                arrayList.add(dataHandler);
            }
            return arrayList.toArray(new DataHandler[arrayList.size()]);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("failed to deserialize:" + attachmentPart, sOAPException);
        }
        catch (MessagingException messagingException) {
            throw new JAXRPCException("failed to deserialize mime multipart", messagingException);
        }
    }

    protected void serialize(Object object, XMLName xMLName, SOAPMessage sOAPMessage, SerializationContext serializationContext) throws SOAPFaultException {
        try {
            this.addBodyElement(xMLName, sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("failed to serialize the attachment " + xMLName, sOAPException);
        }
        if (object == null) {
            return;
        }
        DataHandler[] dataHandlerArray = (DataHandler[])object;
        MimeMultipart mimeMultipart = new MimeMultipart();
        for (int i = 0; i < dataHandlerArray.length; ++i) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            try {
                mimeBodyPart.setDataHandler(dataHandlerArray[i]);
                mimeMultipart.addBodyPart(mimeBodyPart);
                continue;
            }
            catch (MessagingException messagingException) {
                throw new JAXRPCException("failed to serialize", messagingException);
            }
        }
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
        attachmentPart.setContent(mimeMultipart, mimeMultipart.getContentType());
        attachmentPart.setContentId("<" + xMLName.getLocalName() + ">");
        attachmentPart.setMimeHeader("Content-Type", mimeMultipart.getContentType());
        sOAPMessage.addAttachmentPart(attachmentPart);
    }
}

