/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import weblogic.utils.CharsetMap;
import weblogic.utils.io.NoFlushOutputStreamWriter;
import weblogic.webservice.WLSOAPPart;
import weblogic.webservice.core.soap.SOAPEnvelopeImpl;
import weblogic.webservice.core.soap.SOAPMessageImpl;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class SOAPPartImpl
extends SOAPPart
implements WLSOAPPart {
    private SOAPEnvelopeImpl envelope;
    private Reader reader;
    private byte[] bytes;
    private XMLInputStream xmlInputStream;
    private MimeHeaders headers;
    private static final int SOAP_ENVELOPE = 0;
    private static final int READER = 1;
    private static final int XML_INPUT = 2;
    private static final int BYTES = 3;
    private int sourceType = 0;
    private XMLOutputStreamFactory factory = XMLOutputStreamFactory.newInstance();
    private SOAPMessageImpl soapMessage;
    private static final String CONTENT_TYPE = "Content-Type";

    SOAPPartImpl(SOAPMessageImpl sOAPMessageImpl) {
        this.soapMessage = sOAPMessageImpl;
        this.headers = new MimeHeaders();
        this.headers.addHeader(CONTENT_TYPE, "text/xml");
    }

    SOAPPartImpl(MimeHeaders mimeHeaders, Reader reader, SOAPMessageImpl sOAPMessageImpl) throws SOAPException, IOException {
        this.soapMessage = sOAPMessageImpl;
        this.headers = mimeHeaders;
        this.reader = reader;
        this.sourceType = 1;
    }

    private String getSoapNS() {
        if (this.soapMessage.isSOAP12()) {
            return "http://www.w3.org/2003/05/soap-envelope";
        }
        return "http://schemas.xmlsoap.org/soap/envelope/";
    }

    private String getSoapEncNS() {
        if (this.soapMessage.isSOAP12()) {
            return "http://www.w3.org/2003/05/soap-encoding";
        }
        return "http://schemas.xmlsoap.org/soap/encoding/";
    }

    public void setContent(XMLInputStream xMLInputStream) {
        this.xmlInputStream = xMLInputStream;
        this.envelope = null;
        this.reader = null;
        this.sourceType = 2;
    }

    public XMLInputStream getXMLStreamContent() throws SOAPException, XMLStreamException {
        if (this.sourceType == 2) {
            return this.xmlInputStream;
        }
        if (this.sourceType == 1) {
            return XMLInputStreamFactory.newInstance().newInputStream(this.reader);
        }
        throw new SOAPException("unknown source type");
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        if (this.sourceType == 0) {
            if (this.envelope == null) {
                this.envelope = new SOAPEnvelopeImpl(this.getSoapNS(), this.getSoapEncNS());
            }
        } else {
            if (this.sourceType == 1) {
                try {
                    this.envelope = new SOAPEnvelopeImpl(this.reader);
                    this.reader.close();
                    this.reader = null;
                }
                catch (IOException iOException) {
                    throw new SOAPException(iOException);
                }
            }
            if (this.sourceType == 2) {
                try {
                    this.envelope = new SOAPEnvelopeImpl(this.xmlInputStream);
                }
                catch (IOException iOException) {
                    throw new SOAPException(iOException);
                }
            }
            if (this.sourceType == 3) {
                try {
                    this.envelope = new SOAPEnvelopeImpl(new ByteArrayInputStream(this.bytes));
                    this.bytes = null;
                }
                catch (IOException iOException) {
                    throw new SOAPException(iOException);
                }
            }
        }
        this.sourceType = 0;
        return this.envelope;
    }

    public String getContentId() {
        String string = super.getContentId();
        if (this.soapMessage.countAttachments() == 0) {
            return string;
        }
        if (string != null) {
            return string;
        }
        string = "__WLS__" + System.currentTimeMillis() + "__SOAP__";
        super.setContentId(string);
        return string;
    }

    public void removeMimeHeader(String string) {
        this.headers.removeHeader(string);
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public String[] getMimeHeader(String string) {
        return this.headers.getHeader(string);
    }

    public void setMimeHeader(String string, String string2) {
        this.headers.setHeader(string, string2);
    }

    public void addMimeHeader(String string, String string2) {
        this.headers.addHeader(string, string2);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            this.envelope = null;
            return;
        }
        try {
            XMLInputStream xMLInputStream = this.getStreamFromSource(source);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = this.soapMessage.getCharset();
            if (string != null && CharsetMap.getJavaFromIANA(string) != null) {
                string = CharsetMap.getJavaFromIANA(string);
            }
            NoFlushOutputStreamWriter noFlushOutputStreamWriter = null;
            noFlushOutputStreamWriter = string != null ? new NoFlushOutputStreamWriter(byteArrayOutputStream, string, true) : new NoFlushOutputStreamWriter(byteArrayOutputStream);
            XMLOutputStream xMLOutputStream = XMLOutputStreamFactory.newInstance().newOutputStream(noFlushOutputStreamWriter);
            xMLOutputStream.add(xMLInputStream);
            xMLOutputStream.flush();
            xMLOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.envelope = new SOAPEnvelopeImpl(byteArrayInputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SOAPException("failed to convert DOM to SOAPEnvelope:" + xMLStreamException, xMLStreamException);
        }
        catch (IOException iOException) {
            throw new SOAPException("failed to convert DOM to SOAPEnvelope:" + iOException, iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMLInputStream getStreamFromSource(Source source) throws SOAPException, XMLStreamException {
        if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            Node node = dOMSource.getNode();
            if (node instanceof Document) return XMLInputStreamFactory.newInstance().newInputStream(node);
            throw new SOAPException("Node is not a document");
        }
        if (!(source instanceof StreamSource)) throw new SOAPException("unknown source type " + source.getClass());
        StreamSource streamSource = (StreamSource)source;
        InputStream inputStream = streamSource.getInputStream();
        if (inputStream != null) {
            return XMLInputStreamFactory.newInstance().newInputStream(inputStream);
        }
        Reader reader = streamSource.getReader();
        if (reader == null) throw new SOAPException("Either InputSource or Reader has to be set on StreamSource.");
        return XMLInputStreamFactory.newInstance().newInputStream(reader);
    }

    public Source getContent() throws SOAPException {
        if (this.envelope == null) {
            this.getEnvelope();
        }
        try {
            XMLInputStream xMLInputStream = this.envelope.stream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
            XMLOutputStream xMLOutputStream = XMLOutputStreamFactory.newInstance().newOutputStream(document);
            xMLOutputStream.add(xMLInputStream);
            xMLOutputStream.flush();
            xMLOutputStream.close();
            return new DOMSource(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SOAPException("failed to create Source" + parserConfigurationException, parserConfigurationException);
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            throw new SOAPException("failed to parse xml" + xMLStreamException, xMLStreamException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new SOAPException(throwable);
        }
    }

    public void writeTo(XMLOutputStream xMLOutputStream) throws SOAPException, XMLStreamException {
        if (this.envelope == null) {
            this.getEnvelope();
        }
        this.envelope.write(xMLOutputStream);
    }

    /*
     * Loose catch block
     */
    public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        block28: {
            IOException iOException2222;
            OutputStream outputStream2;
            ByteArrayOutputStream byteArrayOutputStream;
            NoFlushOutputStreamWriter noFlushOutputStreamWriter;
            XMLOutputStream xMLOutputStream;
            block25: {
                block24: {
                    xMLOutputStream = null;
                    noFlushOutputStreamWriter = null;
                    byteArrayOutputStream = null;
                    outputStream2 = null;
                    if (this.sourceType == 3) {
                        outputStream.write(this.bytes);
                        outputStream.flush();
                        return;
                    }
                    if (this.sourceType == 2) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        outputStream2 = outputStream;
                        outputStream = byteArrayOutputStream;
                    }
                    String string = this.soapMessage.getCharset();
                    if (string != null && CharsetMap.getJavaFromIANA(string) != null) {
                        string = CharsetMap.getJavaFromIANA(string);
                    }
                    noFlushOutputStreamWriter = string != null ? new NoFlushOutputStreamWriter(outputStream, string, true) : new NoFlushOutputStreamWriter(outputStream);
                    xMLOutputStream = this.factory.newOutputStream(noFlushOutputStreamWriter, true);
                    if (this.sourceType == 2) {
                        xMLOutputStream.add(this.xmlInputStream);
                        break block24;
                    }
                    if (this.soapMessage.getCharset() != null) {
                        xMLOutputStream.add(ElementFactory.createStartDocument(this.soapMessage.getCharset(), "1.0", null));
                    }
                    if (this.envelope == null) {
                        this.getEnvelope();
                    }
                    this.envelope.write(xMLOutputStream);
                }
                Object var8_8 = null;
                if (xMLOutputStream == null) break block25;
                try {
                    xMLOutputStream.close();
                }
                catch (XMLStreamException iOException2222) {
                    // empty catch block
                }
            }
            if (noFlushOutputStreamWriter != null) {
                try {
                    noFlushOutputStreamWriter.flush();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
                try {
                    noFlushOutputStreamWriter.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (this.sourceType == 2) {
                this.bytes = byteArrayOutputStream.toByteArray();
                outputStream2.write(this.bytes);
                outputStream2.flush();
                this.sourceType = 3;
            }
            break block28;
            {
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    throw runtimeException;
                }
            }
            catch (Throwable throwable) {
                IOException iOException32222;
                Object var8_9 = null;
                if (xMLOutputStream != null) {
                    try {
                        xMLOutputStream.close();
                    }
                    catch (XMLStreamException iOException32222) {
                        // empty catch block
                    }
                }
                if (noFlushOutputStreamWriter != null) {
                    try {
                        noFlushOutputStreamWriter.flush();
                    }
                    catch (IOException iOException32222) {
                        // empty catch block
                    }
                    try {
                        noFlushOutputStreamWriter.close();
                    }
                    catch (IOException iOException32222) {
                        // empty catch block
                    }
                }
                if (this.sourceType == 2) {
                    this.bytes = byteArrayOutputStream.toByteArray();
                    outputStream2.write(this.bytes);
                    outputStream2.flush();
                    this.sourceType = 3;
                }
                throw throwable;
            }
        }
    }

    public String toString() {
        return "SOAPPartImpl[" + this.envelope + "]";
    }
}

