/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.soap;

import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.core.soap.NameImpl;
import weblogic.webservice.core.soap.SOAPElementImpl;
import weblogic.xml.stream.XMLName;

public class SOAPHeaderElementImpl
extends SOAPElementImpl
implements SOAPHeaderElement {
    private static final String soapEnvNS = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final NameImpl actorName = new NameImpl("actor", null, null);
    private static final NameImpl actorNameNS = new NameImpl("actor", null, "http://schemas.xmlsoap.org/soap/envelope/");
    private static final NameImpl mustUnderstandName = new NameImpl("mustUnderstand", null, null);
    private static final NameImpl mustUnderstandNameNS = new NameImpl("mustUnderstand", null, "http://schemas.xmlsoap.org/soap/envelope/");

    SOAPHeaderElementImpl(XMLName xMLName) {
        super(xMLName);
    }

    public void setActor(String string) {
        try {
            this.addAttribute(actorName, string);
        }
        catch (SOAPException sOAPException) {
            String string2 = WebServiceLogger.logSoapHeaderActorException();
            WebServiceLogger.logStackTrace(string2, sOAPException);
            throw new IllegalArgumentException(sOAPException.getMessage());
        }
    }

    public String getActor() {
        String string = this.getAttributeValue(actorNameNS);
        if (string == null) {
            string = this.getAttributeValue(actorName);
        }
        return string;
    }

    public void setMustUnderstand(boolean bl) {
        try {
            this.addAttribute(mustUnderstandName, bl ? "1" : "0");
        }
        catch (SOAPException sOAPException) {
            String string = WebServiceLogger.logSoapHeaderMustUnderException();
            WebServiceLogger.logStackTrace(string, sOAPException);
            throw new IllegalArgumentException(sOAPException.getMessage());
        }
    }

    public boolean getMustUnderstand() {
        String string = this.getAttribute(mustUnderstandNameNS);
        if (string == null) {
            string = this.getAttribute(mustUnderstandName);
        }
        return "1".equals(string) || "true".equals(string);
    }

    public void setParentElement(SOAPElement sOAPElement) {
        if (!(sOAPElement instanceof SOAPHeader)) {
            throw new IllegalArgumentException("parent must be SOAPHeader");
        }
        super.setParentElement(sOAPElement);
    }
}

