/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.soap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;

public final class AttachmentPartImpl
extends AttachmentPart {
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private DataHandler dataHandler;

    public AttachmentPartImpl() {
    }

    public AttachmentPartImpl(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public void removeMimeHeader(String string) {
        this.mimeHeaders.removeHeader(string);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public String[] getMimeHeader(String string) {
        return this.mimeHeaders.getHeader(string);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getNonMatchingHeaders(stringArray);
    }

    public void setMimeHeader(String string, String string2) {
        this.mimeHeaders.setHeader(string, string2);
    }

    public void addMimeHeader(String string, String string2) {
        this.mimeHeaders.addHeader(string, string2);
    }

    public void setDataHandler(DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException("DataHandler can not be null");
        }
        this.dataHandler = dataHandler;
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("There is no data in this AttachmentPart");
        }
        return this.dataHandler;
    }

    public void setContent(Object object, String string) {
        if (object == null) {
            throw new JAXRPCException("AttachmentPart.setContent was called with a null content parameter.  If you want to remove the contents of this AttachmentPart, use clearContent() instead.");
        }
        this.setContentType(string);
        this.dataHandler = new DataHandler(object, string);
    }

    public int getSize() throws SOAPException {
        if (this.dataHandler == null) {
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.dataHandler.writeTo(byteArrayOutputStream);
            int n = byteArrayOutputStream.size();
            byteArrayOutputStream.close();
            return n;
        }
        catch (IOException iOException) {
            throw new SOAPException(iOException);
        }
    }

    public void clearContent() {
        this.dataHandler = null;
    }

    public Object getContent() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("There is no data in this AttachmentPart");
        }
        try {
            return this.dataHandler.getContent();
        }
        catch (IOException iOException) {
            throw new SOAPException("Error retrieving Attachment content", iOException);
        }
    }
}

