/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.rpc;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import weblogic.webservice.Operation;
import weblogic.webservice.Part;
import weblogic.webservice.Port;
import weblogic.webservice.TargetInvocationException;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.async.AsyncInfo;
import weblogic.webservice.async.FutureResult;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.binding.https.HttpsBindingInfo;
import weblogic.webservice.client.SSLAdapter;
import weblogic.webservice.core.PortMapper;

public class StubImpl
implements Stub,
InvocationHandler {
    private static final String USERNAME = "javax.xml.rpc.security.auth.username";
    private static final String PASSWORD = "javax.xml.rpc.security.auth.password";
    private static final String SSL_ADAPTER = "weblogic.webservice.client.ssladapter";
    private static final String END_POINT = "javax.xml.rpc.service.endpoint.address";
    private static final String PROXY_USERNAME = "weblogic.webservice.client.proxyusername";
    private static final String PROXY_PASSWORD = "weblogic.webservice.client.proxypassword";
    private static final String BINDING_INFO = "weblogic.webservice.bindinginfo";
    private static final String TIMEOUT = "weblogic.webservice.rpc.timeoutsecs";
    private Port port;
    private String encodingStyle;
    private static final ArrayList propertyNames = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$javax$xml$rpc$Stub;

    public StubImpl(Port port) {
        if (port == null) {
            throw new IllegalArgumentException("port can not be null");
        }
        this.port = port;
    }

    public StubImpl(Port port, Class clazz) {
        this(port);
        new PortMapper().mapInterfaceToPort(clazz, port);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _setProperty(String string, Object object) throws UnsupportedOperationException {
        if (USERNAME.equals(string)) {
            this.port.setUserName((String)object);
            return;
        } else if (PASSWORD.equals(string)) {
            this.port.setPassword((String)object);
            return;
        } else if (SSL_ADAPTER.equals(string)) {
            BindingInfo bindingInfo = this.port.getBindingInfo();
            if (!(bindingInfo instanceof HttpsBindingInfo)) throw new JAXRPCException("Can not set SSLAdapter on non https binding");
            ((HttpsBindingInfo)bindingInfo).setSSLAdapter((SSLAdapter)object);
            return;
        } else if (END_POINT.equals(string)) {
            this.port.getBindingInfo().setAddress((String)object);
            return;
        } else if (PROXY_USERNAME.equals(string)) {
            this.port.setProxyUserName((String)object);
            return;
        } else if (PROXY_PASSWORD.equals(string)) {
            this.port.setProxyPassword((String)object);
            return;
        } else if (BINDING_INFO.equals(string)) {
            this.port.setBindingInfo((BindingInfo)object);
            return;
        } else {
            if (!TIMEOUT.equals(string)) throw new UnsupportedOperationException("unknow property:" + string);
            BindingInfo bindingInfo = this.port.getBindingInfo();
            bindingInfo.setTimeout(Integer.parseInt((String)object));
        }
    }

    public Object _getProperty(String string) {
        Object object = null;
        if (USERNAME.equals(string)) {
            object = this.port.getUserName();
        } else if (PASSWORD.equals(string)) {
            object = this.port.getPassword();
        } else if (SSL_ADAPTER.equals(string)) {
            BindingInfo bindingInfo = this.port.getBindingInfo();
            if (bindingInfo instanceof HttpsBindingInfo) {
                object = ((HttpsBindingInfo)bindingInfo).getSSLAdapter();
            }
        } else if (END_POINT.equals(string)) {
            object = this.port.getBindingInfo().getAddress();
        } else if (BINDING_INFO.equals(string)) {
            object = this.port.getBindingInfo();
        } else if (TIMEOUT.equals(string)) {
            object = String.valueOf(this.port.getBindingInfo().getTimeout());
        }
        return object;
    }

    public Iterator _getPropertyNames() {
        return propertyNames.iterator();
    }

    public void _setTargetEndpoint(URL uRL) {
        this.port.getBindingInfo().setAddress(uRL.toString());
    }

    public URL _getTargetEndpoint() {
        try {
            return new URL(this.port.getBindingInfo().getAddress());
        }
        catch (MalformedURLException malformedURLException) {
            String string = WebServiceLogger.logStubImplMalformedURLException();
            WebServiceLogger.logStackTrace(string, malformedURLException);
            throw new IllegalArgumentException("wrong url:" + malformedURLException);
        }
    }

    public void _setEncodingStyle(String string) {
        this.encodingStyle = string;
    }

    public String _getEncodingStyle() {
        return this.encodingStyle;
    }

    public Reference getReference() throws NamingException {
        throw new Error("NYI");
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Operation operation = this.port.getOperation(method.getName());
        if (operation == null) {
            if ("toString".equals(method.getName())) {
                return this.toString();
            }
            if ("_setProperty".equals(method.getName())) {
                return method.invoke((Object)this, objectArray);
            }
            throw new JAXRPCException("unable to find operation:" + method);
        }
        int n = 0;
        Iterator iterator = operation.getInput().getParts();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (n >= objectArray.length) {
                throw new JAXRPCException("not enough args");
            }
            hashMap.put(part.getName(), objectArray[n]);
            ++n;
        }
        try {
            return this._invoke(method.getName(), hashMap);
        }
        catch (SOAPFaultException sOAPFaultException) {
            return this.throwRemoteException("Failed to invoke", sOAPFaultException);
        }
        catch (JAXRPCException jAXRPCException) {
            return this.throwRemoteException("Failed to invoke", jAXRPCException);
        }
    }

    private Object throwRemoteException(String string, Throwable throwable) throws Throwable {
        Throwable throwable2 = throwable;
        try {
            Class<?> clazz = Class.forName("java.rmi.RemoteException");
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = StubImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = StubImpl.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            throwable2 = (Throwable)constructor.newInstance(string, throwable);
        }
        catch (Throwable throwable3) {
            throwable2 = throwable;
        }
        throw throwable2;
    }

    public FutureResult _startAsyncInvoke(String string, Map map, AsyncInfo asyncInfo) {
        if (asyncInfo != null) {
            asyncInfo.setCaller(this);
        }
        try {
            Operation operation = this.port.getOperation(string);
            HashMap hashMap = new HashMap();
            return operation.asyncInvoke(hashMap, this.getArgValueArray(operation, map), asyncInfo, null);
        }
        catch (IOException iOException) {
            throw new JAXRPCException("web service invoke failed: " + iOException, iOException);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("web service invoke failed: " + sOAPException, sOAPException);
        }
    }

    public Object _invoke(String string, Map map) throws Throwable {
        try {
            HashMap hashMap = new HashMap();
            Operation operation = this.port.getOperation(string);
            Object object = operation.invoke(hashMap, this.getArgValueArray(operation, map));
            Iterator iterator = operation.getOutput().getParts();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                Object v = map.get(part.getName());
                Object v2 = hashMap.get(part.getName());
                if (part.getMode() != Part.Mode.INOUT && part.getMode() != Part.Mode.OUT) continue;
                if (v == null) {
                    throw new JAXRPCException("This is an in-out or out param.but the holder class not passed in:" + part.getName());
                }
                this._setHolderValue(v, v2);
            }
            return object;
        }
        catch (TargetInvocationException targetInvocationException) {
            throw targetInvocationException.getCause();
        }
        catch (IOException iOException) {
            throw new JAXRPCException("web service invoke failed: " + iOException, iOException);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("web service invoke failed: " + sOAPException, sOAPException);
        }
    }

    private Object[] getArgValueArray(Operation operation, Map map) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = operation.getInput().getParts();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            Object object = map.get(part.getName());
            object = this._getHolderValue(object);
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public void _setHolderValue(Object object, Object object2) {
        if (object == null) {
            throw new JAXRPCException("holder can not be null");
        }
        try {
            Field field = object.getClass().getField("value");
            field.set(object, object2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new JAXRPCException("unable to set value on the holder class", noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRPCException("unable to set value on the holder class", illegalAccessException);
        }
    }

    public Object _getHolderValue(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Holder)) {
            return object;
        }
        try {
            Field field = object.getClass().getField("value");
            return field.get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new JAXRPCException("unable to find field 'value' in the holder class " + object.getClass(), noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRPCException("unable to get value from holder class", illegalAccessException);
        }
    }

    public static Object implementInterface(Class clazz, Port port) throws IOException {
        ClassLoader classLoader = clazz.getClassLoader();
        Class[] classArray = new Class[]{clazz, class$java$rmi$Remote == null ? (class$java$rmi$Remote = StubImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote, class$javax$xml$rpc$Stub == null ? (class$javax$xml$rpc$Stub = StubImpl.class$("javax.xml.rpc.Stub")) : class$javax$xml$rpc$Stub};
        StubImpl stubImpl = new StubImpl(port, clazz);
        return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)stubImpl);
    }

    public Object _wrap(int n) {
        return new Integer(n);
    }

    public Object _wrap(float f) {
        return new Float(f);
    }

    public Object _wrap(double d) {
        return new Double(d);
    }

    public Object _wrap(short s) {
        return new Short(s);
    }

    public Object _wrap(long l) {
        return new Long(l);
    }

    public Object _wrap(boolean bl) {
        return new Boolean(bl);
    }

    public Object _wrap(Object object) {
        return object;
    }

    public Object _wrap(char c) {
        return "" + c;
    }

    public Object _wrap(byte by) {
        return new Byte(by);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        propertyNames.add(USERNAME);
        propertyNames.add(PASSWORD);
        propertyNames.add(SSL_ADAPTER);
        propertyNames.add(END_POINT);
        propertyNames.add(BINDING_INFO);
        propertyNames.add(TIMEOUT);
    }
}

