/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.rpc;

import java.io.IOException;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import weblogic.net.http.Handler;
import weblogic.webservice.Operation;
import weblogic.webservice.Port;
import weblogic.webservice.WebService;
import weblogic.webservice.WebServiceFactory;
import weblogic.webservice.context.ContextNotFoundException;
import weblogic.webservice.context.WebServiceContext;
import weblogic.webservice.core.encoding.DefaultRegistry;
import weblogic.webservice.core.handler.HandlerRegistryImpl;
import weblogic.webservice.core.rpc.CallImpl;
import weblogic.webservice.core.rpc.StubImpl;
import weblogic.webservice.extensions.WLService;

public class ServiceImpl
implements WLService {
    public static final String WLS_URL_STREAM_HANDLER = "weblogic.webservice.UseWebLogicURLStreamHandler";
    private WebService webservice;
    private TypeMappingRegistry registry;
    private String wsdlLocation;
    private boolean createdFromWSDL;
    private HandlerRegistry handlerRegistry = new HandlerRegistryImpl();

    ServiceImpl(String string) throws IOException, JAXRPCException {
        this(string, null);
    }

    protected ServiceImpl(String string, String string2) throws IOException, JAXRPCException {
        this(string, string2, null);
    }

    protected ServiceImpl(String string, String string2, String string3) throws IOException, JAXRPCException {
        if (Boolean.getBoolean(WLS_URL_STREAM_HANDLER)) {
            Handler.init();
        }
        this.wsdlLocation = string;
        this.createdFromWSDL = true;
        WebServiceFactory webServiceFactory = WebServiceFactory.newInstance();
        if (string2 == null) {
            this.registry = new DefaultRegistry();
        } else {
            this.registry = new DefaultRegistry(string2);
            this.webservice = webServiceFactory.createFromWSDL(string, string3, this.registry);
        }
    }

    ServiceImpl(QName qName) {
        if (Boolean.getBoolean(WLS_URL_STREAM_HANDLER)) {
            Handler.init();
        }
        this.registry = new DefaultRegistry();
        this.createdFromWSDL = false;
        WebServiceFactory webServiceFactory = WebServiceFactory.newInstance();
        this.webservice = webServiceFactory.create();
        this.webservice.setTargetNamespace(qName.getNamespaceURI());
        this.webservice.setName(qName.getLocalPart());
        this.webservice.setTypeMappingRegistry(this.registry);
    }

    WebService getWebService() {
        if (this.webservice == null) {
            if (this.wsdlLocation == null) {
                throw new JAXRPCException("WSDL location can not be null");
            }
            WebServiceFactory webServiceFactory = WebServiceFactory.newInstance();
            try {
                this.webservice = webServiceFactory.createFromWSDL(this.wsdlLocation, this.registry);
            }
            catch (IOException iOException) {
                throw new JAXRPCException("failed to create service", iOException);
            }
        }
        return this.webservice;
    }

    boolean isCreatedFromWSDL() {
        return this.createdFromWSDL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ServiceImpl[\n");
        stringBuffer.append(this.getWebService());
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    public Reference getReference() {
        throw new Error("NYI");
    }

    protected Port _getPort(String string) {
        Port port = this.getWebService().getPort(string);
        if (port == null) {
            throw new JAXRPCException("unable to find port:" + string + " This may be because the WSDL file and the generated stub is out " + " sync. Doing clientgen again may fix this problem.");
        }
        port.setHandlerRegistry(this.handlerRegistry);
        return port;
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        if (qName == null) {
            throw new ServiceException("QName can not be null");
        }
        Port port = null;
        try {
            port = this._getPort(qName.getLocalPart());
        }
        catch (JAXRPCException jAXRPCException) {
            throw new ServiceException(jAXRPCException);
        }
        try {
            return (Remote)StubImpl.implementInterface(clazz, port);
        }
        catch (IOException iOException) {
            throw new ServiceException("unable to create run time proxy:" + iOException, iOException);
        }
    }

    public Remote getPort(Class clazz) throws ServiceException {
        Iterator iterator = this.getWebService().getPorts();
        if (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            return this.getPort(new QName(port.getTypeName()), clazz);
        }
        throw new ServiceException("unable to find port for:" + clazz);
    }

    public HandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    private Port _getPortForType(QName qName) throws ServiceException {
        Iterator iterator = this.getWebService().getPorts();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            if (!qName.getLocalPart().equals(port.getTypeName())) continue;
            return port;
        }
        throw new ServiceException("Unable to find portType:" + qName + ". Check the WSDL file to find out the right portType name");
    }

    public Call createCall(QName qName) throws JAXRPCException {
        Call call = this.createCall();
        call.setPortTypeName(qName);
        return call;
    }

    public Call createCall(QName qName, String string) throws JAXRPCException {
        return this.createCall(qName, new QName(null, string));
    }

    public Call createCall(QName qName, QName qName2) throws JAXRPCException {
        Call call = this.createCall();
        call.setPortTypeName(qName);
        call.setOperationName(qName2);
        return call;
    }

    public Call createCall() throws JAXRPCException {
        return new CallImpl(this);
    }

    public QName getServiceName() {
        return new QName(this.getWebService().getTargetNamespace(), this.getWebService().getName());
    }

    public Iterator getPorts() throws ServiceException {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        Iterator iterator = this.getWebService().getPorts();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            arrayList.add(new QName(null, port.getName()));
        }
        if (arrayList.size() == 0) {
            throw new ServiceException("Unable to find port in this web service. Make sure that you have provided the right WSDL url");
        }
        return arrayList.iterator();
    }

    public URL getWSDLDocumentLocation() {
        try {
            return this.wsdlLocation == null ? null : new URL(this.wsdlLocation);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unable to create URL : " + this.wsdlLocation);
        }
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) throws JAXRPCException {
        this.registry = typeMappingRegistry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws JAXRPCException {
        return this.registry;
    }

    public Call[] getCalls(QName qName) throws ServiceException {
        if (qName == null) {
            throw new ServiceException("portName can not be null");
        }
        ArrayList<Call> arrayList = new ArrayList<Call>();
        Port port = null;
        try {
            port = this._getPort(qName.getLocalPart());
        }
        catch (JAXRPCException jAXRPCException) {
            throw new ServiceException(jAXRPCException);
        }
        Iterator iterator = port.getOperations();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            Call call = this.createCall(new QName(port.getTypeName()), new QName(operation.getNamespace(), operation.getName()));
            arrayList.add(call);
        }
        return arrayList.toArray(new Call[arrayList.size()]);
    }

    protected void _setUser(String string, String string2, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("No username provided");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("No password provided");
        }
        if (object == null || !(object instanceof Stub)) {
            throw new IllegalArgumentException("Got a bad stub:" + object);
        }
        Stub stub = (Stub)object;
        stub._setProperty("javax.xml.rpc.security.auth.username", string);
        stub._setProperty("javax.xml.rpc.security.auth.password", string2);
    }

    public WebServiceContext context() {
        return this.webservice.context();
    }

    public WebServiceContext joinContext() throws ContextNotFoundException {
        return this.webservice.joinContext();
    }
}

