/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.rpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.soap.SOAPException;
import weblogic.webservice.Message;
import weblogic.webservice.Operation;
import weblogic.webservice.Part;
import weblogic.webservice.Port;
import weblogic.webservice.TargetInvocationException;
import weblogic.webservice.WebService;
import weblogic.webservice.WebServiceFactory;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.binding.https.HttpsBindingInfo;
import weblogic.webservice.client.SSLAdapter;
import weblogic.webservice.core.rpc.ServiceImpl;
import weblogic.webservice.extensions.WLCall;
import weblogic.xml.schema.binding.util.StdNamespace;

public class CallImpl
implements WLCall {
    private WebService webservice;
    private Operation operation;
    private Port port;
    private QName name;
    private QName portName;
    private String endpoint;
    private String encodingStyle = StdNamespace.instance().soapEncoding();
    private boolean changed = false;
    private boolean propertiesChanged = false;
    private HashMap properties = new HashMap();
    private ArrayList parameters = new ArrayList();
    private ParameterInfo returnInfo;
    private Map lastResult = new HashMap();
    private ServiceImpl serviceImpl;
    private static final String SSL_ADAPTER = "weblogic.webservice.client.ssladapter";
    private static final String TIMEOUT = "weblogic.webservice.rpc.timeoutsecs";
    private static final String PROXY_USERNAME = "weblogic.webservice.client.proxyusername";
    private static final String PROXY_PASSWORD = "weblogic.webservice.client.proxypassword";
    private static ArrayList validProperties = new ArrayList();

    CallImpl(ServiceImpl serviceImpl) {
        this.serviceImpl = serviceImpl;
    }

    public boolean isParameterAndReturnSpecRequired(QName qName) {
        if (!this.serviceImpl.isCreatedFromWSDL()) {
            return true;
        }
        if (this.portName == null) {
            return true;
        }
        Port port = this.serviceImpl._getPort(this.portName.getLocalPart());
        if (port == null) {
            return true;
        }
        return port.getOperation(qName.getLocalPart()) == null;
    }

    public void addParameter(String string, QName qName, Class clazz, ParameterMode parameterMode) throws JAXRPCException {
        this.markChanged();
        ParameterInfo parameterInfo = new ParameterInfo();
        parameterInfo.name = string;
        parameterInfo.xmlType = qName;
        parameterInfo.javaType = clazz;
        parameterInfo.mode = parameterMode;
        this.parameters.add(parameterInfo);
    }

    public void addParameter(String string, QName qName, ParameterMode parameterMode) throws JAXRPCException {
        this.addParameter(string, qName, null, parameterMode);
    }

    public QName getParameterTypeByName(String string) {
        Object object = this.parameters.iterator();
        while (object.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)object.next();
            if (!string.equals(parameterInfo.name)) continue;
            return parameterInfo.xmlType;
        }
        if (this.name != null) {
            this.forceOperationLookup();
            object = this.getPart(string);
            return object.getXMLType();
        }
        return null;
    }

    public Iterator getParameterNames() {
        Part part;
        this.forceOperationLookup();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.operation.getInput().getParts();
        while (iterator.hasNext()) {
            part = (Part)iterator.next();
            arrayList.add(part.getName());
        }
        iterator = this.operation.getOutput().getParts();
        while (iterator.hasNext()) {
            part = (Part)iterator.next();
            if (part.getMode() != Part.Mode.OUT) continue;
            arrayList.add(part.getName());
        }
        return arrayList.iterator();
    }

    private Part getPart(String string) {
        Part part = this.operation.getInput().getPart(string);
        if (part == null) {
            part = this.operation.getOutput().getPart(string);
        }
        if (part == null) {
            throw new JAXRPCException("unable to find part: '" + string + "' for operation '" + this.operation + "'. Please check WSDL");
        }
        return part;
    }

    public Class getParameterJavaType(String string) {
        this.forceOperationLookup();
        Part part = this.getPart(string);
        return part.getJavaType();
    }

    public ParameterMode getParameterMode(String string) {
        this.forceOperationLookup();
        Part part = this.getPart(string);
        Part.Mode mode = part.getMode();
        if (Part.Mode.IN == mode) {
            return ParameterMode.IN;
        }
        if (Part.Mode.OUT == mode) {
            return ParameterMode.OUT;
        }
        if (Part.Mode.INOUT == mode) {
            return ParameterMode.INOUT;
        }
        throw new JAXRPCException("unknown parameter mode for part:" + string);
    }

    public void setReturnType(QName qName, Class clazz) throws JAXRPCException {
        String string;
        this.markChanged();
        this.returnInfo = new ParameterInfo();
        this.returnInfo.name = string = "__bea_noname_result";
        this.returnInfo.xmlType = qName;
        this.returnInfo.javaType = clazz;
    }

    public void setReturnType(QName qName) throws JAXRPCException {
        this.setReturnType(qName, null);
    }

    public QName getReturnType() {
        if (this.returnInfo == null) {
            Part part;
            if (this.name != null) {
                this.forceOperationLookup();
            }
            if (this.operation != null && (part = this.operation.getReturnPart()) != null) {
                return part.getXMLType();
            }
        } else {
            return this.returnInfo.xmlType;
        }
        return null;
    }

    public void removeAllParameters() {
        this.markChanged();
        this.parameters.clear();
    }

    private void markChanged() {
        if (this.serviceImpl.isCreatedFromWSDL()) {
            throw new JAXRPCException("This call is created from WSDL, you can not add/remove parameters or return type from this call");
        }
        this.changed = true;
    }

    public QName getOperationName() {
        return this.name;
    }

    public void setOperationName(QName qName) {
        this.name = qName;
        this.changed = true;
    }

    public QName getPortTypeName() {
        if (this.portName == null) {
            return new QName("");
        }
        return this.portName;
    }

    public void setPortTypeName(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException("port name can not be null");
        }
        this.portName = qName;
        this.changed = true;
    }

    public void setTargetEndpointAddress(String string) {
        this.endpoint = string;
        this.changed = true;
    }

    public String getTargetEndpointAddress() {
        return this.endpoint;
    }

    private boolean isValidProperty(String string) {
        return validProperties.contains(string);
    }

    public void setProperty(String string, Object object) throws JAXRPCException {
        if (!this.isValidProperty(string)) {
            throw new JAXRPCException("unknown property: " + string);
        }
        this.properties.put(string, object);
        this.propertiesChanged = true;
    }

    public Object getProperty(String string) {
        if (!this.isValidProperty(string)) {
            throw new JAXRPCException("unknown property: " + string);
        }
        return this.properties.get(string);
    }

    private void populateProperties(Operation operation) {
        if (this.port == null || operation == null) {
            throw new IllegalArgumentException("port/operation can not be null");
        }
        Iterator iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.properties.get(string);
            this.setPropertyInternal(string, v);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPropertyInternal(String string, Object object) {
        if ("javax.xml.rpc.security.auth.username".equals(string)) {
            this.port.setUserName((String)object);
            return;
        } else if ("javax.xml.rpc.security.auth.password".equals(string)) {
            this.port.setPassword((String)object);
            return;
        } else if (SSL_ADAPTER.equals(string)) {
            BindingInfo bindingInfo = this.port.getBindingInfo();
            if (!(bindingInfo instanceof HttpsBindingInfo)) throw new JAXRPCException("Can not set SSLAdapter on non https binding");
            ((HttpsBindingInfo)bindingInfo).setSSLAdapter((SSLAdapter)object);
            return;
        } else if ("javax.xml.rpc.soap.http.soapaction.uri".equals(string)) {
            this.operation.setSoapAction((String)object);
            return;
        } else if ("javax.xml.rpc.soap.operation.style".equals(string)) {
            if ("document".equals((String)object)) {
                this.operation.setDocumentStyle();
            }
            if (!"rpc".equals((String)object)) return;
            this.operation.setRpcStyle();
            return;
        } else if ("javax.xml.rpc.encodingstyle.namespace.uri".equals(string)) {
            this.operation.getInput().setEncodingStyle((String)object);
            this.operation.getOutput().setEncodingStyle((String)object);
            return;
        } else if (PROXY_USERNAME.equals(string)) {
            this.port.setProxyUserName((String)object);
            return;
        } else if (PROXY_PASSWORD.equals(string)) {
            this.port.setProxyPassword((String)object);
            return;
        } else if ("javax.xml.rpc.session.maintain".equals(string)) {
            this.port.setMaintainSession(new Boolean((String)object));
            return;
        } else {
            if (!TIMEOUT.equals(string)) return;
            BindingInfo bindingInfo = this.port.getBindingInfo();
            bindingInfo.setTimeout(Integer.parseInt((String)object));
        }
    }

    public void removeProperty(String string) {
        this.propertiesChanged = true;
        this.properties.remove(string);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public Object invoke(Object[] objectArray) {
        return this.invoke(objectArray, false);
    }

    private void forceOperationLookup() {
        this.getOperation();
    }

    private Operation getOperation() {
        if (this.operation != null && !this.changed) {
            if (this.propertiesChanged) {
                this.populateProperties(this.operation);
                this.propertiesChanged = false;
            }
            return this.operation;
        }
        if (this.name == null) {
            throw new JAXRPCException("operation name not set");
        }
        if (this.serviceImpl.isCreatedFromWSDL()) {
            if (this.portName == null) {
                throw new JAXRPCException("port name not set");
            }
            this.port = this.serviceImpl._getPort(this.portName.getLocalPart());
            if (this.port == null) {
                throw new JAXRPCException("unable to find port : " + this.portName);
            }
            this.endpoint = this.port.getBindingInfo().getAddress();
            this.operation = this.port.getOperation(this.name.getLocalPart());
            if (this.operation == null) {
                throw new JAXRPCException("Unable to find operation '" + this.operation + "' in port '" + this.port.getName() + "'. Please check the WSDL");
            }
        } else {
            String string = this.port != null ? this.port.getSessionID() : null;
            WebServiceFactory webServiceFactory = WebServiceFactory.newInstance();
            WebService webService = webServiceFactory.create();
            this.port = webService.addPort(this.portName == null ? "unnamedPort" : this.portName.getLocalPart(), this.serviceImpl.getHandlerRegistry());
            this.port.setSessionID(string);
            if (this.endpoint.startsWith("https")) {
                this.port.setBindingInfo(new HttpsBindingInfo());
            } else {
                this.port.setBindingInfo(new BindingInfo());
            }
            this.port.getBindingInfo().setAddress(this.getTargetEndpointAddress());
            this.operation = this.port.addOperation(this.name.getLocalPart());
            this.operation.setNamespace(this.name.getNamespaceURI());
            this.operation.getInput().setNamespace(this.name.getNamespaceURI());
            this.operation.getOutput().setNamespace(this.name.getNamespaceURI());
            this.operation.getInput().setTypeMappingRegistry(this.serviceImpl.getTypeMappingRegistry());
            this.operation.getOutput().setTypeMappingRegistry(this.serviceImpl.getTypeMappingRegistry());
            this.fillParameter(this.operation);
        }
        this.populateProperties(this.operation);
        return this.operation;
    }

    private void fillParameter(Operation operation) {
        TypeMapping typeMapping = this.serviceImpl.getTypeMappingRegistry().getTypeMapping(this.encodingStyle);
        if (typeMapping == null) {
            throw new JAXRPCException("encoding style '" + this.encodingStyle + "' " + " is not registered with the type mapping registry.");
        }
        Object object = this.parameters.iterator();
        while (object.hasNext()) {
            Part part;
            ParameterInfo parameterInfo = (ParameterInfo)object.next();
            if (ParameterMode.IN.equals(parameterInfo.mode)) {
                part = this.addPart(operation.getInput(), parameterInfo);
                part.setMode(Part.Mode.IN);
                part.setTypeMapping(typeMapping);
            }
            if (ParameterMode.OUT.equals(parameterInfo.mode)) {
                part = this.addPart(operation.getOutput(), parameterInfo);
                part.setMode(Part.Mode.OUT);
                part.setTypeMapping(typeMapping);
            }
            if (!ParameterMode.INOUT.equals(parameterInfo.mode)) continue;
            part = this.addPart(operation.getInput(), parameterInfo);
            part.setMode(Part.Mode.INOUT);
            part.setTypeMapping(typeMapping);
            part = this.addPart(operation.getOutput(), parameterInfo);
            part.setMode(Part.Mode.INOUT);
            part.setTypeMapping(typeMapping);
        }
        if (this.returnInfo != null) {
            object = this.addPart(operation.getOutput(), this.returnInfo);
            object.setMode(Part.Mode.RETURN);
            object.setTypeMapping(typeMapping);
        }
    }

    private Part addPart(Message message, ParameterInfo parameterInfo) {
        Part part = null;
        part = parameterInfo.javaType == null ? message.addPart(parameterInfo.name, parameterInfo.xmlType.getLocalPart(), parameterInfo.xmlType.getNamespaceURI()) : message.addPart(parameterInfo.name, parameterInfo.xmlType.getLocalPart(), parameterInfo.xmlType.getNamespaceURI(), parameterInfo.javaType);
        return part;
    }

    private Object invoke(Object[] objectArray, boolean bl) {
        try {
            Operation operation = this.getOperation();
            operation.setOneway(bl);
            this.lastResult = new HashMap();
            Object object = operation.invoke(this.lastResult, objectArray);
            return bl ? null : object;
        }
        catch (TargetInvocationException targetInvocationException) {
            Throwable throwable = targetInvocationException.getCause();
            if (throwable == null) {
                throwable = targetInvocationException;
            }
            throw new JAXRPCException("failed to invoke operation '" + this.operation.getName() + "' due to an error in the " + "backend compoent; nested exception is: " + this.toString(targetInvocationException), throwable);
        }
        catch (SOAPException sOAPException) {
            Throwable throwable = sOAPException.getCause();
            if (throwable == null) {
                throwable = sOAPException;
            }
            throw new JAXRPCException("failed to invoke operation '" + this.operation.getName() + "' due to an error in the " + "soap layer (SAAJ); nested exception is: " + this.toString(sOAPException), throwable);
        }
        catch (IOException iOException) {
            throw new JAXRPCException("failed to invoke operation '" + this.operation.getName() + "' due to an error in the " + "transport layer; nested exception is: " + this.toString(iOException), iOException);
        }
    }

    private String toString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print("Message[" + throwable.getMessage() + "]");
        printStream.println("StackTrace[\n");
        throwable.printStackTrace(printStream);
        printStream.println("]");
        printStream.flush();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public Object invoke(QName qName, Object[] objectArray) throws JAXRPCException {
        this.setOperationName(qName);
        return this.invoke(objectArray);
    }

    public void invokeOneWay(Object[] objectArray) throws JAXRPCException {
        this.invoke(objectArray, true);
    }

    public List getOutputValues() throws JAXRPCException {
        Map map = this.getOutputParams();
        if (map == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public Map getOutputParams() throws JAXRPCException {
        return this.lastResult;
    }

    static {
        validProperties.add("javax.xml.rpc.security.auth.username");
        validProperties.add("javax.xml.rpc.security.auth.password");
        validProperties.add("javax.xml.rpc.soap.operation.style");
        validProperties.add("javax.xml.rpc.soap.http.soapaction.use");
        validProperties.add("javax.xml.rpc.soap.http.soapaction.uri");
        validProperties.add("javax.xml.rpc.encodingstyle.namespace.uri");
        validProperties.add("javax.xml.rpc.session.maintain");
        validProperties.add(SSL_ADAPTER);
        validProperties.add(PROXY_USERNAME);
        validProperties.add(PROXY_PASSWORD);
        validProperties.add(TIMEOUT);
    }

    static class ParameterInfo {
        String name;
        QName xmlType;
        Class javaType;
        ParameterMode mode;

        ParameterInfo() {
        }
    }
}

