/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.handler;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import weblogic.utils.AssertionError;
import weblogic.webservice.GenericHandler;
import weblogic.webservice.Operation;
import weblogic.webservice.WLMessageContext;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.context.WebServiceContext;
import weblogic.webservice.context.WebServiceSession;
import weblogic.webservice.conversation.Guid;
import weblogic.webservice.core.handler.ConversationContext;
import weblogic.webservice.core.handler.ConversationUtil;

public final class ClientConversationHandler
extends GenericHandler {
    public boolean handleRequest(MessageContext messageContext) throws JAXRPCException {
        WLMessageContext wLMessageContext = (WLMessageContext)messageContext;
        try {
            Operation operation = wLMessageContext.getOperation();
            String string = operation.getConversationPhase();
            if (string != null && string != "NONE") {
                Object object;
                ConversationContext conversationContext = new ConversationContext();
                WebServiceContext webServiceContext = (WebServiceContext)wLMessageContext.getProperty("weblogic.webservice.context");
                WebServiceSession webServiceSession = webServiceContext.getSession();
                if (string.equals("CONTINUE")) {
                    conversationContext.setHeaderType("ContinueHeader");
                    object = (String)webServiceSession.getAttribute("__BEA_PRIVATE_CONVERSATION_PROP");
                    if (object == null) {
                        throw new JAXRPCException("There is no conversationID found in WebServiceSession for a continue conversation method. Did you start a conversation?");
                    }
                    conversationContext.setConversationID((String)object);
                } else if (string.equals("START")) {
                    conversationContext.setHeaderType("StartHeader");
                    object = (String)webServiceSession.getAttribute("__BEA_PRIVATE_CONVERSATION_PROP");
                    if (object == null) {
                        object = Guid.generateGuid();
                    }
                    webServiceSession.setAttribute("__BEA_PRIVATE_CONVERSATION_PROP", object);
                    conversationContext.setConversationID((String)object);
                } else if (string.equals("FINISH")) {
                    conversationContext.setHeaderType("FinishHeader");
                    object = (String)webServiceSession.getAttribute("__BEA_PRIVATE_CONVERSATION_PROP");
                    if (object == null) {
                        throw new JAXRPCException("There is no conversationID found in WebServiceSession for a finish conversation method. Did you start a conversation?");
                    }
                    webServiceSession.setAttribute("__BEA_PRIVATE_CONVERSATION_PROP", null);
                    conversationContext.setConversationID((String)object);
                } else {
                    throw new AssertionError("unknown conversation phase " + string);
                }
                wLMessageContext.setProperty("__BEA_PRIVATE_CONVERSATION_PROP", conversationContext);
                object = wLMessageContext.getMessage();
                SOAPEnvelope sOAPEnvelope = ((SOAPMessage)object).getSOAPPart().getEnvelope();
                SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
                ConversationUtil conversationUtil = new ConversationUtil(sOAPEnvelope);
                conversationUtil.addToHeader(conversationContext);
            }
        }
        catch (SOAPException sOAPException) {
            String string = WebServiceLogger.logClientConversationSoapException();
            WebServiceLogger.logStackTrace(string, sOAPException);
            throw new JAXRPCException(sOAPException);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) throws JAXRPCException {
        WLMessageContext wLMessageContext = (WLMessageContext)messageContext;
        return true;
    }
}

