/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.encoding;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import weblogic.xml.schema.binding.internal.TypeMappingBase;

public class TypeMappingRegistryImpl
implements TypeMappingRegistry,
Serializable {
    private Map typeMappings = new HashMap();
    private TypeMapping defaultTypeMapping = null;

    public void registerDefault(TypeMapping typeMapping) {
        this.defaultTypeMapping = typeMapping;
        this.register("http://schemas.xmlsoap.org/soap/encoding/", typeMapping);
        this.register("http://www.w3.org/2003/05/soap-encoding", typeMapping);
    }

    public TypeMapping register(String string, TypeMapping typeMapping) {
        if (typeMapping == null) {
            throw new IllegalArgumentException("mapping cannot be null");
        }
        this.typeMappings.put(string, typeMapping);
        return typeMapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        if (this.defaultTypeMapping != null) {
            return this.defaultTypeMapping;
        }
        return this.getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/");
    }

    public boolean removeTypeMapping(TypeMapping typeMapping) {
        if (typeMapping == null) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.typeMappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!typeMapping.equals(entry.getValue())) continue;
            arrayList.add(entry.getKey());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.typeMappings.remove(iterator.next());
        }
        return !arrayList.isEmpty();
    }

    public TypeMapping unregisterTypeMapping(String string) {
        return (TypeMapping)this.typeMappings.remove(string);
    }

    public String[] getRegisteredNamespaces() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.typeMappings.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void register(TypeMapping typeMapping, String[] stringArray) throws JAXRPCException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.typeMappings.put(stringArray[i], typeMapping);
        }
    }

    public void clear() {
        this.typeMappings.clear();
    }

    public TypeMapping createTypeMapping() {
        return new TypeMappingBase();
    }

    public TypeMapping removeTypeMapping(String string) {
        return (TypeMapping)this.typeMappings.remove(string);
    }

    public Iterator getAllTypeMappings() {
        return this.typeMappings.values().iterator();
    }

    public String[] getSupportedNamespaces() {
        return this.typeMappings.keySet().toArray(new String[0]);
    }

    public TypeMapping getTypeMapping(String string) {
        return (TypeMapping)this.typeMappings.get(string);
    }

    public String[] getRegisteredEncodingStyleURIs() {
        return this.getSupportedNamespaces();
    }
}

