/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core;

import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import weblogic.utils.Debug;
import weblogic.webservice.Message;
import weblogic.webservice.Part;
import weblogic.webservice.PartFilter;
import weblogic.webservice.context.WebServiceContext;
import weblogic.webservice.core.DefaultMessage;
import weblogic.webservice.core.DefaultOperation;
import weblogic.webservice.core.soap.SOAPElementImpl;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.internal.DeserializationContextImpl;
import weblogic.xml.schema.binding.internal.SerializationContextImpl;
import weblogic.xml.schema.binding.util.NamespacePrefixMap;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.xmlnode.XMLNode;
import weblogic.xml.xmlnode.XMLNodeOutputStream;

public class FaultMessage
implements Message {
    private Message ref;
    private Part thePart;
    private String faultName;
    private DefaultOperation operation;

    FaultMessage(DefaultOperation defaultOperation) {
        this.ref = new DefaultMessage(defaultOperation);
        this.operation = defaultOperation;
    }

    public void setName(String string) {
        this.ref.setName(string);
    }

    public void setFaultName(String string) {
        this.faultName = string;
    }

    public void setNamespace(String string) {
        this.ref.setNamespace(string);
    }

    public void setEncodingStyle(String string) {
        this.ref.setEncodingStyle(string);
    }

    public void setContainsAttachment(boolean bl) {
        Debug.assertion(!bl, "FaultMessage can't contain attachment");
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.ref.setTypeMappingRegistry(typeMappingRegistry);
    }

    public String getName() {
        return this.ref.getName();
    }

    public String getFaultName() {
        return this.faultName;
    }

    public String getNamespace() {
        return this.ref.getNamespace();
    }

    public boolean isVoid() {
        return this.ref.isVoid();
    }

    public boolean isMultiPart() {
        return false;
    }

    public boolean isSinglePart() {
        return true;
    }

    public String getEncodingStyle() {
        return this.ref.getEncodingStyle();
    }

    public String getSecuritySpecRef() {
        return this.ref.getSecuritySpecRef();
    }

    public void setSecuritySpecRef(String string) {
        this.ref.setSecuritySpecRef(string);
    }

    public boolean isLiteral() {
        return this.ref.isLiteral();
    }

    public boolean isEncoded() {
        return this.ref.isEncoded();
    }

    public boolean getContainsAttachment() {
        return false;
    }

    public Object[] getSortedParameters(Map map) {
        return this.ref.getSortedParameters(map);
    }

    public Part getPart(String string) {
        if (this.thePart != null && this.thePart.getName().equals(string)) {
            return this.thePart;
        }
        return null;
    }

    public Iterator getParts() {
        return this.ref.getParts();
    }

    public Part[] getParts(PartFilter partFilter) {
        if (partFilter.accept(this.thePart)) {
            return new Part[]{this.thePart};
        }
        return new Part[0];
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.ref.getTypeMappingRegistry();
    }

    public void useLiteral() {
        this.ref.useLiteral();
    }

    public void useEncoded() {
        this.ref.useEncoded();
    }

    public Part addPart(String string, String string2, String string3, Class clazz) {
        Debug.assertion(this.thePart == null, "FaultMessage can have only one part.");
        this.thePart = this.ref.addPart(string, string2, string3, clazz);
        return this.thePart;
    }

    public void toXML(SOAPMessage sOAPMessage, Object[] objectArray, WebServiceContext webServiceContext) throws SOAPException {
        SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
        SOAPBody sOAPBody = sOAPEnvelope.getBody();
        SOAPFault sOAPFault = sOAPBody.addFault();
        sOAPFault.setFaultCode(SOAPElementImpl.ENV_PREFIX + ":Server");
        sOAPFault.setFaultString("Service specific exception: " + objectArray[0]);
        SerializationContextImpl serializationContextImpl = new SerializationContextImpl();
        serializationContextImpl.setSOAPMessage(sOAPMessage);
        serializationContextImpl.setIncludeXsiType(true);
        serializationContextImpl.setNamespacePrefixMap(NamespacePrefixMap.createDefaultMap());
        TypeMapping typeMapping = this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        this.thePart.toXML(sOAPFault.addDetail(), objectArray[0], serializationContextImpl, this.operation.isDocumentStyle(), typeMapping);
        if (serializationContextImpl.isMultiRefEmpty()) {
            this.writeXmlIds(sOAPBody, serializationContextImpl);
        }
    }

    public Object toJava(Map map, SOAPMessage sOAPMessage, WebServiceContext webServiceContext) throws SOAPException {
        Object object;
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        Detail detail = sOAPBody.getFault().getDetail();
        if (detail == null) {
            return null;
        }
        if (!detail.getChildElements().hasNext()) {
            return null;
        }
        SOAPElement sOAPElement = null;
        Object object2 = detail.getChildElements();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof SOAPElement)) continue;
            sOAPElement = (SOAPElement)object;
            break;
        }
        if (sOAPElement == null) {
            return null;
        }
        object2 = new DeserializationContextImpl();
        object2.setSOAPMessage(sOAPMessage);
        object = this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        return this.thePart.toJava(sOAPElement, (DeserializationContext)object2, (TypeMapping)object);
    }

    public Part addPart(String string, String string2, String string3) {
        Debug.assertion(this.thePart == null, "FaultMessage can have only one part.");
        this.thePart = this.ref.addPart(string, string2, string3);
        return this.thePart;
    }

    public String toString() {
        return "FaultMessage[" + this.ref.toString() + "]";
    }

    private void writeXmlIds(SOAPElement sOAPElement, SerializationContext serializationContext) throws SOAPException {
        try {
            XMLNodeOutputStream xMLNodeOutputStream = new XMLNodeOutputStream((XMLNode)((Object)sOAPElement));
            serializationContext.setQualifyElements(true);
            RuntimeUtils.writeTrailingBlocks(xMLNodeOutputStream, serializationContext);
            xMLNodeOutputStream.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SOAPException(xMLStreamException);
        }
        catch (SerializationException serializationException) {
            throw new SOAPException(serializationException);
        }
    }
}

