/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.soap.SOAPElement;
import weblogic.utils.AssertionError;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;
import weblogic.webservice.HandlerChain;
import weblogic.webservice.Operation;
import weblogic.webservice.Port;
import weblogic.webservice.WLMessageContext;
import weblogic.webservice.WebService;
import weblogic.webservice.context.ContextNotFoundException;
import weblogic.webservice.context.WebServiceContext;
import weblogic.webservice.context.WebServiceContextImpl;
import weblogic.webservice.core.DefaultPort;
import weblogic.webservice.core.HandlerChainImpl;
import weblogic.webservice.core.encoding.DefaultRegistry;
import weblogic.webservice.monitoring.WebServiceStats;
import weblogic.xml.security.specs.SecurityDD;
import weblogic.xml.xmlnode.XMLNode;

public class DefaultWebService
implements WebService {
    private static final String DEFAULT_PROTOCOL = "http";
    private static final boolean debug = false;
    private static final String DEFAULT_OPERATION = "_default";
    private String targetNamespace;
    private String name;
    private TypeMappingRegistry typeMappingRegistry;
    private HashMap ports = new HashMap();
    private XMLNode types;
    private SecurityDD security;
    private String protocol;
    private int responseBufferSize = -1;
    private boolean exposeHomePage = true;
    private boolean exposeWSDL = true;
    private boolean handleAllActors = true;
    private WebServiceContext context;
    private boolean localContext = false;
    private HandlerInfo[] handlerInfos;
    private WebServiceStats mStats = null;
    private final Pool handlerChainPool = new StackPool(32);

    public DefaultWebService(String string, String string2) {
        this.targetNamespace = string;
        this.name = string2;
        this.protocol = DEFAULT_PROTOCOL;
        try {
            this.typeMappingRegistry = new DefaultRegistry();
        }
        catch (JAXRPCException jAXRPCException) {
            throw new AssertionError(jAXRPCException);
        }
    }

    public void destroy() {
        Iterator iterator = this.ports.values().iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            port.destroy();
        }
    }

    public void setTypes(XMLNode xMLNode) {
        this.types = xMLNode;
    }

    public XMLNode getTypes() {
        return this.types;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setResponseBufferSize(int n) {
        this.responseBufferSize = n;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public boolean getExposeWSDL() {
        return this.exposeWSDL;
    }

    public void setExposeWSDL(boolean bl) {
        this.exposeWSDL = bl;
    }

    public boolean getExposeHomePage() {
        return this.exposeHomePage;
    }

    public void setExposeHomePage(boolean bl) {
        this.exposeHomePage = bl;
    }

    public boolean getHandleAllActors() {
        return this.handleAllActors;
    }

    public void setHandleAllActors(boolean bl) {
        this.handleAllActors = bl;
    }

    public void setTargetNamespace(String string) {
        this.targetNamespace = string;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public Port addPort(String string) {
        return this.addPort(string, null);
    }

    public Port addPort(String string, HandlerRegistry handlerRegistry) {
        Port port = this.getPort(string);
        if (port == null) {
            port = new DefaultPort(this);
            port.setName(string);
            port.setTypeMappingRegistry(this.typeMappingRegistry);
            this.ports.put(string, port);
        }
        port.setHandlerRegistry(handlerRegistry);
        return port;
    }

    public Port getPortForType(String string) {
        Iterator iterator = this.getPorts();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            if (!string.equals(port.getTypeName())) continue;
            return port;
        }
        return null;
    }

    public Port getPort(String string) {
        return (Port)this.ports.get(string);
    }

    public Iterator getPorts() {
        return this.ports.values().iterator();
    }

    public Port getPort(String string, String string2) {
        return this.getPort(string + ":" + string2);
    }

    public Operation findOperation(SOAPElement sOAPElement) {
        Iterator iterator = this.getPorts();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            Operation operation = port.findOperation(sOAPElement);
            if (operation == null) continue;
            return operation;
        }
        return null;
    }

    public Operation findOperation(String string) {
        Iterator iterator = this.getPorts();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            Operation operation = port.getOperation(string);
            if (operation == null) continue;
            return operation;
        }
        return null;
    }

    public SecurityDD getSecurity() {
        return this.security;
    }

    public void setSecurity(SecurityDD securityDD) {
        this.security = securityDD;
    }

    public HandlerChain getServerHandlerChain() {
        if (this.handlerInfos == null) {
            return null;
        }
        HandlerChain handlerChain = (HandlerChain)this.handlerChainPool.remove();
        if (handlerChain == null) {
            handlerChain = new HandlerChainImpl(this.handlerInfos, this.mStats == null ? null : this.mStats.getHandlerStats());
        }
        return handlerChain;
    }

    public void setHandlerInfos(HandlerInfo[] handlerInfoArray) {
        this.handlerInfos = handlerInfoArray;
    }

    public HandlerInfo[] getHandlerInfos() {
        return this.handlerInfos;
    }

    private void setMessageProps(WLMessageContext wLMessageContext, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            wLMessageContext.setProperty(string, map.get(string));
        }
    }

    public WebServiceStats getStats() {
        return this.mStats;
    }

    public void setStats(WebServiceStats webServiceStats) {
        this.mStats = webServiceStats;
    }

    public WebServiceContext context() {
        if (this.context == null) {
            this.context = new WebServiceContextImpl();
            this.localContext = true;
        }
        return this.context;
    }

    public WebServiceContext joinContext() throws ContextNotFoundException {
        if (this.localContext) {
            throw new IllegalStateException("active local context already available. Can not call context() before joinContext() ");
        }
        this.context = WebServiceContext.currentContext();
        return this.context;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WebService[\n");
        stringBuffer.append("name=").append(this.name).append(",\n");
        stringBuffer.append("targetNamespace=").append(this.targetNamespace).append(",\n");
        stringBuffer.append("protocol=").append(this.protocol).append(",\n");
        if (this.types != null) {
            stringBuffer.append("\ntypes[\n");
            stringBuffer.append(this.types);
            stringBuffer.append("]\n");
        }
        Iterator iterator = this.ports.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(this.getPort(string));
        }
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }
}

