/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.soap.SOAPElement;
import weblogic.webservice.Operation;
import weblogic.webservice.Part;
import weblogic.webservice.Port;
import weblogic.webservice.WLMessageContext;
import weblogic.webservice.WebService;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.core.DefaultOperation;

public class DefaultPort
implements Port {
    private static final boolean debug = false;
    private String name;
    private String typeName;
    private String address;
    private String username;
    private String password;
    private String sessionID;
    private String proxyUsername;
    private String proxyPassword;
    private boolean maintainSession = true;
    private String style = "rpc";
    private HashMap operations = new HashMap();
    private LinkedList orderedOperations = new LinkedList();
    private BindingInfo bindingInfo = new BindingInfo();
    private TypeMappingRegistry typeMappingRegistry;
    private HandlerRegistry registry;
    private WebService service;

    DefaultPort(WebService webService) {
        this.service = webService;
    }

    public HandlerRegistry getHandlerRegistry() {
        return this.registry;
    }

    public void setHandlerRegistry(HandlerRegistry handlerRegistry) {
        this.registry = handlerRegistry;
    }

    public WebService getService() {
        return this.service;
    }

    public void destroy() {
        Iterator iterator = this.operations.values().iterator();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            operation.destroy();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        if ("rpc".equalsIgnoreCase(string) || "document".equalsIgnoreCase(string) || "documentwrapped".equalsIgnoreCase(string)) {
            this.style = string.toLowerCase();
        } else if (string == null) {
            this.style = "rpc";
        } else {
            throw new IllegalArgumentException("Invalid operation style: " + string);
        }
    }

    public boolean isDocumentStyle() {
        return "document".equals(this.style);
    }

    public boolean isRpcStyle() {
        return "rpc".equals(this.style);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getProxyUserName() {
        return this.proxyUsername;
    }

    public void setProxyUserName(String string) {
        this.proxyUsername = string;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSession = bl;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String string) {
        if (this.maintainSession) {
            this.sessionID = string;
        }
    }

    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public Operation getOperation(String string) {
        return (Operation)this.operations.get(string);
    }

    public Iterator getOperations() {
        return this.operations.values().iterator();
    }

    public Iterator getOrderedOperations() {
        return this.orderedOperations.listIterator(0);
    }

    public Operation addOperation(String string) {
        return this.addOperation(string, null);
    }

    public void addOperation(Operation operation) {
        this.operations.put(operation.getName(), operation);
        this.orderedOperations.add(operation);
    }

    public Operation addOperation(String string, HandlerInfo[] handlerInfoArray) {
        Operation operation = this.getOperation(string);
        if (operation == null) {
            operation = new DefaultOperation(string, this, handlerInfoArray);
            operation.setTypeMappingRegistry(this.typeMappingRegistry);
            this.addOperation(operation);
            if (this.isRpcStyle()) {
                operation.setRpcStyle();
            } else {
                operation.setDocumentStyle();
            }
        }
        return operation;
    }

    public void removeOperation(String string) {
        this.operations.remove(string);
    }

    public Operation findOperation(SOAPElement sOAPElement) {
        if ("rpc".equals(this.style) || "documentwrapped".equals(this.style)) {
            if (sOAPElement == null) {
                return null;
            }
            return this.getOperation(sOAPElement.getElementName().getLocalName());
        }
        Iterator iterator = this.getOperations();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            Iterator iterator2 = operation.getInput().getParts();
            if (iterator2.hasNext()) {
                Part part = (Part)iterator2.next();
                if (iterator2.hasNext()) {
                    // empty if block
                }
                if (sOAPElement == null || !part.getXMLType().getLocalPart().equals(sOAPElement.getElementName().getLocalName())) continue;
                String string = part.getXMLType().getNamespaceURI();
                String string2 = sOAPElement.getElementName().getURI();
                if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
                    return operation;
                }
                if (string == null || !string.equals(string2)) continue;
                return operation;
            }
            if (sOAPElement != null) continue;
            return operation;
        }
        return null;
    }

    private void setMessageProps(WLMessageContext wLMessageContext, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            wLMessageContext.setProperty(string, map.get(string));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Port[\n");
        Iterator iterator = this.getOperations();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }
}

