/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.webservice.HandlerChain;
import weblogic.webservice.InvocationHandler;
import weblogic.webservice.Message;
import weblogic.webservice.Operation;
import weblogic.webservice.Part;
import weblogic.webservice.Port;
import weblogic.webservice.TargetInvocationException;
import weblogic.webservice.WLMessageContext;
import weblogic.webservice.async.AsyncInfo;
import weblogic.webservice.async.FutureResult;
import weblogic.webservice.core.ClientDispatcher;
import weblogic.webservice.core.DefaultMessage;
import weblogic.webservice.core.FaultMessage;
import weblogic.webservice.core.HandlerChainImpl;
import weblogic.webservice.monitoring.OperationStats;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;

public class DefaultOperation
implements Operation {
    private static final boolean verbose = Boolean.getBoolean("weblogic.webservice.verbose");
    private String name;
    private String namespace;
    private String encodingStyle;
    private String soapAction = "\"\"";
    private String[] parameterOrder;
    private boolean oneway = false;
    private String conversationPhase;
    private int persistDuration = -1;
    private String style = "rpc";
    private InvocationHandler target;
    private Port port;
    private TypeMappingRegistry typeMappingRegistry;
    private Message input = new DefaultMessage(this);
    private Message output = new DefaultMessage(this);
    private ArrayList faults = new ArrayList();
    private static final String SOAP_ACTION = "SOAPAction";
    private final Pool handlerChainPool = new StackPool(32);
    private HandlerInfo[] handlerInfos;
    private OperationStats mStats = null;
    private final HandlerInfo clientHandlerInfo = new HandlerInfo(class$weblogic$webservice$core$handler$ClientHandler == null ? (class$weblogic$webservice$core$handler$ClientHandler = DefaultOperation.class$("weblogic.webservice.core.handler.ClientHandler")) : class$weblogic$webservice$core$handler$ClientHandler, null, null);
    private final HandlerInfo reliableHandlerInfo = new HandlerInfo(class$weblogic$webservice$saf$SAFHandler == null ? (class$weblogic$webservice$saf$SAFHandler = DefaultOperation.class$("weblogic.webservice.saf.SAFHandler")) : class$weblogic$webservice$saf$SAFHandler, null, null);
    private final HandlerInfo rmSendingHandlerInfo = new HandlerInfo(class$weblogic$webservice$saf$SendingHandler == null ? (class$weblogic$webservice$saf$SendingHandler = DefaultOperation.class$("weblogic.webservice.saf.SendingHandler")) : class$weblogic$webservice$saf$SendingHandler, null, null);
    private final HandlerInfo conversationHandlerInfo = new HandlerInfo(class$weblogic$webservice$core$handler$ClientConversationHandler == null ? (class$weblogic$webservice$core$handler$ClientConversationHandler = DefaultOperation.class$("weblogic.webservice.core.handler.ClientConversationHandler")) : class$weblogic$webservice$core$handler$ClientConversationHandler, null, null);
    private final HandlerInfo checkSoapFaultHandlerInfo = new HandlerInfo(class$weblogic$webservice$core$handler$CheckSoapFaultHandler == null ? (class$weblogic$webservice$core$handler$CheckSoapFaultHandler = DefaultOperation.class$("weblogic.webservice.core.handler.CheckSoapFaultHandler")) : class$weblogic$webservice$core$handler$CheckSoapFaultHandler, null, null);
    static /* synthetic */ Class class$weblogic$webservice$core$handler$ClientHandler;
    static /* synthetic */ Class class$weblogic$webservice$saf$SAFHandler;
    static /* synthetic */ Class class$weblogic$webservice$saf$SendingHandler;
    static /* synthetic */ Class class$weblogic$webservice$core$handler$ClientConversationHandler;
    static /* synthetic */ Class class$weblogic$webservice$core$handler$CheckSoapFaultHandler;
    static /* synthetic */ Class class$weblogic$webservice$core$handler$WSSEClientHandler;

    DefaultOperation(String string, Port port, HandlerInfo[] handlerInfoArray) {
        this.name = string;
        this.port = port;
        this.handlerInfos = handlerInfoArray;
        this.input.setName(string);
        this.output.setName(string + "Response");
    }

    public HandlerInfo[] getHandlerInfos() {
        return this.handlerInfos;
    }

    public void setHandlerInfos(HandlerInfo[] handlerInfoArray) {
        this.handlerInfos = handlerInfoArray;
    }

    public void destroy() {
        Iterator iterator = this.handlerChainPool.iterator();
        while (iterator.hasNext()) {
            ((HandlerChain)iterator.next()).destroy();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Port getPort() {
        return this.port;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void setEncodingStyle(String string) {
        this.encodingStyle = string;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
        this.input.setTypeMappingRegistry(typeMappingRegistry);
        this.output.setTypeMappingRegistry(typeMappingRegistry);
        Iterator iterator = this.faults.iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            message.setTypeMappingRegistry(typeMappingRegistry);
        }
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        if ("".equals(string)) {
            string = "\"\"";
        } else if (string != null) {
            if (!string.startsWith("\"")) {
                string = "\"" + string;
            }
            if (!string.endsWith("\"")) {
                string = string + "\"";
            }
        }
        this.soapAction = string;
    }

    public String[] getParameterOrder() {
        return this.parameterOrder;
    }

    public void setParameterOrder(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            this.setParameterOrder(stringArray);
        } else {
            this.setParameterOrder((String[])null);
        }
    }

    public void setParameterOrder(String[] stringArray) {
        this.parameterOrder = stringArray;
    }

    public boolean isDocumentStyle() {
        return "document".equalsIgnoreCase(this.style);
    }

    public void setDocumentStyle() {
        this.input.useLiteral();
        this.output.useLiteral();
        this.style = "document";
    }

    public boolean isRpcStyle() {
        return "rpc".equals(this.style);
    }

    public void setRpcStyle() {
        this.input.useEncoded();
        this.output.useEncoded();
        this.style = "rpc";
    }

    public Message getInput() {
        return this.input;
    }

    public void setInput(Message message) {
        this.input = message;
    }

    public Message getOutput() {
        return this.output;
    }

    public void setOutput(Message message) {
        this.output = this.output;
    }

    public Iterator getFaults() {
        return this.faults.iterator();
    }

    public Message getFault(String string) {
        Iterator iterator = this.faults.iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            if (!message.getName().equals(string)) continue;
            return message;
        }
        return null;
    }

    public Message addFault() {
        FaultMessage faultMessage = new FaultMessage(this);
        faultMessage.setTypeMappingRegistry(this.typeMappingRegistry);
        this.faults.add(faultMessage);
        return faultMessage;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public void setOneway(boolean bl) {
        this.oneway = bl;
    }

    public void setStyle(String string) {
        if ("rpc".equalsIgnoreCase(string) || "document".equalsIgnoreCase(string) || "documentwrapped".equalsIgnoreCase(string)) {
            this.style = string.toLowerCase();
        } else if (string == null) {
            this.style = "rpc";
        } else {
            throw new IllegalArgumentException("Invalid operation style: " + string);
        }
    }

    public String getStyle() {
        return this.style;
    }

    public void setConversationPhase(String string) {
        this.conversationPhase = string;
    }

    public String getConversationPhase() {
        return this.conversationPhase;
    }

    public void setPersistDurationTime(int n) {
        this.persistDuration = n;
    }

    public int getPersistDurationTime() {
        return this.persistDuration;
    }

    public Part getReturnPart() {
        Iterator iterator = this.output.getParts();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (part.getMode() != Part.Mode.RETURN) continue;
            return part;
        }
        return null;
    }

    void fillInHeaders(MimeHeaders mimeHeaders) {
        String string;
        if (this.soapAction != null && !"".equals(this.soapAction)) {
            mimeHeaders.addHeader(SOAP_ACTION, this.soapAction);
        }
        String string2 = this.port.getUserName();
        String string3 = this.port.getPassword();
        if (string2 != null || string3 != null) {
            mimeHeaders.addHeader("Authorization", "Basic " + this.getEncodedAuthToken(string2, string3));
        }
        String string4 = this.port.getProxyUserName();
        String string5 = this.port.getProxyPassword();
        if (string4 != null || string5 != null) {
            mimeHeaders.addHeader("Proxy-Authorization", "Basic " + this.getEncodedAuthToken(string4, string5));
        }
        if ((string = this.port.getSessionID()) != null) {
            mimeHeaders.addHeader("Cookie", string);
        }
    }

    public Object invoke(Map map, Map map2, PrintStream printStream) throws TargetInvocationException, SOAPException, IOException {
        Object[] objectArray = this.input.getSortedParameters(map2);
        return this.invoke(map, objectArray, printStream);
    }

    public Object invoke(Object[] objectArray) throws TargetInvocationException, SOAPException, IOException {
        HashMap hashMap = new HashMap();
        Object object = this.invoke(hashMap, objectArray, null);
        if (hashMap.size() > 1) {
            throw new SOAPException("more than one return value, use invoke( outParams, args )");
        }
        return object;
    }

    public Object invoke(Map map, Object[] objectArray) throws TargetInvocationException, SOAPException, IOException {
        return this.invoke(map, objectArray, null);
    }

    public FutureResult asyncInvoke(Map map, Object[] objectArray, AsyncInfo asyncInfo, PrintStream printStream) throws SOAPException, SOAPFaultException, IOException {
        return new ClientDispatcher(this, map, printStream).asyncDispatch(objectArray, asyncInfo);
    }

    public Object invoke(Map map, Object[] objectArray, PrintStream printStream) throws TargetInvocationException, SOAPException, IOException {
        return new ClientDispatcher(this, map, printStream).dispatch(objectArray);
    }

    public InvocationHandler getInvocationHandler() {
        return this.target;
    }

    public void setInvocationHandler(InvocationHandler invocationHandler) {
        this.target = invocationHandler;
    }

    private void dumpRequest(WLMessageContext wLMessageContext, PrintStream printStream) throws SOAPException {
        this.dumpMessage("REQUEST TO SERVER", wLMessageContext.getMessage(), printStream);
    }

    private void dumpResponse(WLMessageContext wLMessageContext, PrintStream printStream) throws SOAPException {
        this.dumpMessage("RESPONSE FROM SERVER", wLMessageContext.getMessage(), printStream);
    }

    private void dumpMessage(String string, SOAPMessage sOAPMessage, PrintStream printStream) {
        if (verbose || printStream != null) {
            if (printStream == null) {
                printStream = System.out;
            }
            printStream.println("\n<!--" + string + ".................-->");
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sOAPMessage.writeTo(byteArrayOutputStream);
                byteArrayOutputStream.flush();
                try {
                    XMLInputStream xMLInputStream = XMLInputStreamFactory.newInstance().newInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    XMLOutputStream xMLOutputStream = XMLOutputStreamFactory.newInstance().newDebugOutputStream(printStream);
                    xMLOutputStream.add(xMLInputStream);
                    xMLOutputStream.flush();
                }
                catch (Exception exception) {
                    printStream.println(new String(byteArrayOutputStream.toByteArray()));
                }
                printStream.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
        }
    }

    public void process(WLMessageContext wLMessageContext) throws SOAPException {
        boolean bl = false;
        HandlerChain handlerChain = this.getServerHandlerChain();
        if (verbose) {
            this.dumpRequest(wLMessageContext, null);
        }
        handlerChain.handleRequest(wLMessageContext);
        if (verbose) {
            this.dumpResponse(wLMessageContext, null);
        }
        handlerChain.handleResponse(wLMessageContext);
        if (bl) {
            handlerChain.destroy();
        } else {
            this.freeHandlerChain(handlerChain);
        }
    }

    HandlerChain getClientHandlerChain(boolean bl, boolean bl2) {
        List list = null;
        HandlerRegistry handlerRegistry = this.port.getHandlerRegistry();
        if (handlerRegistry != null) {
            list = handlerRegistry.getHandlerChain(QName.valueOf(this.port.getName()));
        }
        ArrayList<HandlerInfo> arrayList = new ArrayList<HandlerInfo>();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (this.conversationPhase != null) {
            arrayList.add(this.conversationHandlerInfo);
        }
        if (bl) {
            arrayList.add(this.reliableHandlerInfo);
        }
        arrayList.add(this.checkSoapFaultHandlerInfo);
        if (bl2) {
            arrayList.add(new HandlerInfo(class$weblogic$webservice$core$handler$WSSEClientHandler == null ? (class$weblogic$webservice$core$handler$WSSEClientHandler = DefaultOperation.class$("weblogic.webservice.core.handler.WSSEClientHandler")) : class$weblogic$webservice$core$handler$WSSEClientHandler, null, null));
        }
        if (bl) {
            arrayList.add(this.rmSendingHandlerInfo);
        }
        arrayList.add(this.clientHandlerInfo);
        HandlerInfo[] handlerInfoArray = new HandlerInfo[arrayList.size()];
        return new HandlerChainImpl(arrayList.toArray(handlerInfoArray));
    }

    public HandlerChain getServerHandlerChain() {
        HandlerChain handlerChain = (HandlerChain)this.handlerChainPool.remove();
        if (handlerChain == null) {
            handlerChain = new HandlerChainImpl(this.handlerInfos, this.mStats == null ? null : this.mStats.getHandlerStats());
        }
        return handlerChain;
    }

    private void freeHandlerChain(HandlerChain handlerChain) {
        if (!this.handlerChainPool.add(handlerChain)) {
            handlerChain.destroy();
        }
    }

    public OperationStats getStats() {
        return this.mStats;
    }

    public void setStats(OperationStats operationStats) {
        this.mStats = operationStats;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DefaultOperation[\n");
        stringBuffer.append("name=").append(this.name).append(",\n");
        stringBuffer.append("style=").append(this.style).append(",\n");
        stringBuffer.append("encodingStyle=").append(this.encodingStyle).append(",\n");
        stringBuffer.append("namespace=").append(this.namespace).append(",\n");
        stringBuffer.append("soapAction=").append(this.soapAction).append(",\n");
        stringBuffer.append(this.input);
        stringBuffer.append(this.output);
        Iterator iterator = this.faults.iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            stringBuffer.append(message);
        }
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    private String getEncodedAuthToken(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encodeBuffer((string + ":" + string2).getBytes());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

