/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import weblogic.webservice.Message;
import weblogic.webservice.Part;
import weblogic.webservice.PartFilter;
import weblogic.webservice.context.WebServiceContext;
import weblogic.webservice.context.WebServiceHeader;
import weblogic.webservice.core.DefaultOperation;
import weblogic.webservice.core.DefaultPart;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.TypeMapping;
import weblogic.xml.schema.binding.internal.DeserializationContextImpl;
import weblogic.xml.schema.binding.internal.SerializationContextImpl;
import weblogic.xml.schema.binding.util.NamespacePrefixMap;
import weblogic.xml.schema.binding.util.StdNamespace;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.xmlnode.XMLNode;
import weblogic.xml.xmlnode.XMLNodeOutputStream;

public class DefaultMessage
implements Message {
    private String name;
    private String namespace;
    private String encodingStyle = StdNamespace.instance().soapEncoding();
    private static String soapNS = StdNamespace.instance().soapEnvelope();
    private static final String ACTOR_URI_NEXT = "http://schemas.xmlsoap.org/soap/actor/next";
    private String securitySpecRef;
    private int use = 1;
    private TypeMappingRegistry typeMappingRegistry;
    private DefaultOperation operation;
    private boolean containsAttachment = false;
    private ArrayList parts = new ArrayList();
    private static SOAPFactory soapFactory;
    private static String PREFIX;
    static /* synthetic */ Class class$java$lang$Object;

    DefaultMessage(DefaultOperation defaultOperation) {
        this.operation = defaultOperation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public boolean isLiteral() {
        return this.use == 0;
    }

    public void useLiteral() {
        this.use = 0;
    }

    public boolean isEncoded() {
        return this.use == 1;
    }

    public void useEncoded() {
        this.use = 1;
    }

    public boolean getContainsAttachment() {
        return this.containsAttachment;
    }

    public void setContainsAttachment(boolean bl) {
        this.containsAttachment = bl;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void setEncodingStyle(String string) {
        this.encodingStyle = string;
    }

    public String getSecuritySpecRef() {
        return this.securitySpecRef;
    }

    public void setSecuritySpecRef(String string) {
        this.securitySpecRef = string;
    }

    private SOAPFactory getSOAPFactory() throws SOAPException {
        if (soapFactory == null) {
            soapFactory = SOAPFactory.newInstance();
        }
        return soapFactory;
    }

    public Part getPart(String string) {
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (!string.equals(part.getName())) continue;
            return part;
        }
        return null;
    }

    private Part getPart(Name name) {
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (!name.getLocalName().equals(part.getXMLName().getLocalName())) continue;
            return part;
        }
        return null;
    }

    TypeMapping getInternalTypeMapping() {
        javax.xml.rpc.encoding.TypeMapping typeMapping = this.typeMappingRegistry.getTypeMapping(this.encodingStyle);
        if (typeMapping == null) {
            throw new IllegalArgumentException("Unable to find type mapping for encodingStyle " + this.encodingStyle + ". In registry " + this.typeMappingRegistry);
        }
        if (typeMapping instanceof TypeMapping) {
            return (TypeMapping)((Object)typeMapping);
        }
        throw new IllegalArgumentException("unable to find javaType from the specified xmlType. This method can only be called if the TypeMapping used is weblogic.xml.schema.binding.TypeMapping. jaxrpc spec should change to fix this problem. in the mean time you can use the addPart( ..., Class javaType )");
    }

    public Part addPart(String string, String string2, String string3) {
        ExpName expName = new ExpName(string3, string2);
        return this.addPart(string, string2, string3, null);
    }

    public Part addPart(String string, String string2, String string3, Class clazz) throws JAXRPCException {
        DefaultPart defaultPart = new DefaultPart(string, string2, string3, clazz, this);
        this.parts.add(defaultPart);
        return defaultPart;
    }

    public Iterator getParts() {
        return this.parts.iterator();
    }

    public Part[] getParts(PartFilter partFilter) {
        ArrayList<Part> arrayList = new ArrayList<Part>();
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (!partFilter.accept(part)) continue;
            arrayList.add(part);
        }
        return arrayList.toArray(new Part[0]);
    }

    private Part getImplicitPart(String string, Class clazz) {
        XMLName xMLName = this.getInternalTypeMapping().getXMLNameFromClass(clazz);
        DefaultPart defaultPart = new DefaultPart(string, xMLName.getLocalName(), xMLName.getNamespaceUri(), clazz, this);
        defaultPart.setHeader();
        return defaultPart;
    }

    public boolean isVoid() {
        return this.parts.size() == 0;
    }

    public boolean isMultiPart() {
        return this.parts.size() > 1;
    }

    public boolean isSinglePart() {
        return this.parts.size() == 1;
    }

    public Object[] getSortedParameters(Map map) {
        Object[] objectArray = new Object[this.parts.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            Part part = (Part)this.parts.get(i);
            objectArray[i] = map.get(part.getName());
        }
        return objectArray;
    }

    private Object headerToJava(Map map, SOAPMessage sOAPMessage, DeserializationContext deserializationContext) throws SOAPException {
        Object object = null;
        javax.xml.rpc.encoding.TypeMapping typeMapping = this.typeMappingRegistry.getTypeMapping(this.encodingStyle);
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (part.isBody() || part.isAttachment()) continue;
            Object object2 = null;
            SOAPElement sOAPElement = null;
            if (part.isHeader() && (sOAPElement = this.getChildElement(part.getXMLName().getLocalName(), sOAPMessage.getSOAPPart().getEnvelope().getHeader())) != null) {
                sOAPElement.detachNode();
            }
            object2 = part.toJava(sOAPElement, deserializationContext, typeMapping);
            if (part.getMode() == Part.Mode.RETURN) {
                object = object2;
                continue;
            }
            map.put(part.getName(), object2);
        }
        return object;
    }

    private void implicitHeaderToJava(SOAPHeader sOAPHeader, DeserializationContext deserializationContext, WebServiceContext webServiceContext, javax.xml.rpc.encoding.TypeMapping typeMapping) throws SOAPException {
        if (sOAPHeader == null) {
            return;
        }
        Iterator iterator = this.getNonSpaceChildElements(sOAPHeader);
        while (iterator.hasNext()) {
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            this.checkMustUnderstand(sOAPElement);
            Part part = this.getImplicitPart(sOAPElement.getElementName().getLocalName(), class$java$lang$Object == null ? DefaultMessage.class$("java.lang.Object") : class$java$lang$Object);
            Object object = part.toJava(sOAPElement, deserializationContext, typeMapping);
            if (object == null || object instanceof XMLNode) continue;
            webServiceContext.getHeader().put(new QName(sOAPElement.getElementName().getURI(), sOAPElement.getElementName().getLocalName()), object);
        }
    }

    private void checkMustUnderstand(SOAPElement sOAPElement) throws SOAPException {
        String string;
        soapFactory = this.getSOAPFactory();
        boolean bl = this.operation.getPort().getService().getHandleAllActors();
        if (!bl) {
            string = sOAPElement.getAttributeValue(soapFactory.createName("actor", null, soapNS));
            if (string == null) {
                string = sOAPElement.getAttributeValue(soapFactory.createName("actor"));
            }
            if (string != null && !string.equals(ACTOR_URI_NEXT)) {
                return;
            }
        }
        if ((string = sOAPElement.getAttributeValue(soapFactory.createName("mustUnderstand", null, soapNS))) == null) {
            string = sOAPElement.getAttributeValue(soapFactory.createName("mustUnderstand"));
        }
        if (string != null) {
            if ("1".equals(string) || "true".equals(string)) {
                throw new SOAPException("Unable to handle mustUnderstand header: " + sOAPElement.getElementName());
            }
            if (!"0".equals(string) && !"false".equals(string)) {
                throw new SOAPException("Invalid value for mustUnderstand attribute in header: " + sOAPElement.getElementName());
            }
        }
    }

    public Object toJava(Map map, SOAPMessage sOAPMessage, WebServiceContext webServiceContext) throws SOAPException {
        javax.xml.rpc.encoding.TypeMapping typeMapping = this.typeMappingRegistry.getTypeMapping(this.encodingStyle);
        DeserializationContextImpl deserializationContextImpl = new DeserializationContextImpl();
        deserializationContextImpl.setSOAPMessage(sOAPMessage);
        Object object = this.headerToJava(map, sOAPMessage, deserializationContextImpl);
        this.implicitHeaderToJava(sOAPMessage.getSOAPPart().getEnvelope().getHeader(), deserializationContextImpl, webServiceContext, typeMapping);
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        SOAPElement sOAPElement = null;
        sOAPElement = "document".equals(this.operation.getStyle()) ? sOAPBody : this.getFirstChild(sOAPBody);
        Iterator iterator = this.getNonSpaceChildElements(sOAPElement);
        while (iterator.hasNext()) {
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            Name name = sOAPElement2.getElementName();
            if ("result".equals(name.getLocalName()) && "http://www.w3.org/2002/06/soap-rpc".equals(name.getURI())) continue;
            Part part = null;
            part = "documentwrapped".equals(this.operation.getStyle()) ? this.getPart(sOAPElement2.getElementName().getLocalName()) : this.getPart(sOAPElement2.getElementName());
            if (part == null && object == null) {
                part = this.getReturnPart();
            }
            if (part == null) {
                if (iterator.hasNext()) continue;
                throw new SOAPException("Found SOAPElement [" + sOAPElement2 + "]. " + "But was not able to find a Part that is registered with this " + "Message which corresponds to this SOAPElement. The name of the " + "element should be one of these[" + this.getPartNames() + "]");
            }
            Object object2 = part.toJava(sOAPElement2, deserializationContextImpl, typeMapping);
            if (part.getMode() == Part.Mode.RETURN) {
                object = object2;
                continue;
            }
            map.put(part.getName(), object2);
        }
        return object;
    }

    private String getPartNames() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            stringBuffer.append(part.getName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private Part getReturnPart() {
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (part.getMode() != Part.Mode.RETURN) continue;
            return part;
        }
        return null;
    }

    private Iterator getNonSpaceChildElements(SOAPElement sOAPElement) {
        return new NonSpaceIterator(sOAPElement.getChildElements());
    }

    private SOAPElement getChildElement(String string, SOAPElement sOAPElement) {
        if (sOAPElement == null) {
            return null;
        }
        Iterator iterator = this.getNonSpaceChildElements(sOAPElement);
        while (iterator.hasNext()) {
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            if (!string.equals(sOAPElement2.getElementName().getLocalName())) continue;
            return sOAPElement2;
        }
        return null;
    }

    String getStyle() {
        return this.operation.getStyle();
    }

    public void toXML(SOAPMessage sOAPMessage, Object[] objectArray, WebServiceContext webServiceContext) throws SOAPException {
        SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
        SOAPBody sOAPBody = sOAPEnvelope.getBody();
        SOAPElement sOAPElement = "document".equals(this.operation.getStyle()) ? sOAPBody : this.createWrapElement(sOAPBody);
        if (this.isEncoded()) {
            sOAPBody.setEncodingStyle(this.encodingStyle);
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Iterator iterator = this.parts.iterator();
        SerializationContextImpl serializationContextImpl = new SerializationContextImpl();
        serializationContextImpl.setSOAPMessage(sOAPMessage);
        serializationContextImpl.setNamespacePrefixMap(NamespacePrefixMap.createDefaultMap());
        javax.xml.rpc.encoding.TypeMapping typeMapping = this.typeMappingRegistry.getTypeMapping(this.encodingStyle);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!iterator.hasNext()) {
                throw new SOAPException("Number of arguments do not match the number of parts. No of parts: " + this.parts.size() + ". No of args:" + objectArray.length);
            }
            Part part = (Part)iterator.next();
            if (this.operation.isDocumentStyle() && Void.TYPE.equals(part.getJavaType())) continue;
            if (part.isHeader()) {
                if (sOAPEnvelope.getHeader() == null) {
                    sOAPEnvelope.addHeader();
                }
                part.toXML(sOAPEnvelope.getHeader(), objectArray[i], serializationContextImpl, this.operation.isDocumentStyle(), typeMapping);
                continue;
            }
            part.toXML(sOAPElement, objectArray[i], serializationContextImpl, this.operation.isDocumentStyle(), typeMapping);
        }
        this.implicitHeaderToXML(sOAPEnvelope, webServiceContext, serializationContextImpl, this.operation.isDocumentStyle(), typeMapping);
        if (serializationContextImpl.isMultiRefEmpty()) {
            this.writeXmlIds(sOAPBody, serializationContextImpl);
        }
        if (iterator.hasNext()) {
            throw new SOAPException("The number of arguments passed does not match the number of parts. no of parts =  " + this.parts.size() + " no of args = " + objectArray.length);
        }
    }

    private void implicitHeaderToXML(SOAPEnvelope sOAPEnvelope, WebServiceContext webServiceContext, SerializationContext serializationContext, boolean bl, javax.xml.rpc.encoding.TypeMapping typeMapping) throws SOAPException {
        if (webServiceContext == null) {
            return;
        }
        WebServiceHeader webServiceHeader = webServiceContext.getHeader();
        Iterator iterator = webServiceHeader.names();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            Object object = webServiceHeader.get(qName);
            if (object == null) continue;
            if (sOAPEnvelope.getHeader() == null) {
                sOAPEnvelope.addHeader();
            }
            Part part = this.getImplicitPart(qName.getLocalPart(), object.getClass());
            part.setNamespace(qName.getNamespaceURI());
            part.toXML(sOAPEnvelope.getHeader(), object, serializationContext, bl, typeMapping);
        }
    }

    private void writeXmlIds(SOAPElement sOAPElement, SerializationContext serializationContext) throws SOAPException {
        try {
            XMLNodeOutputStream xMLNodeOutputStream = new XMLNodeOutputStream((XMLNode)((Object)sOAPElement));
            serializationContext.setQualifyElements(true);
            RuntimeUtils.writeTrailingBlocks(xMLNodeOutputStream, serializationContext);
            xMLNodeOutputStream.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SOAPException(xMLStreamException);
        }
        catch (SerializationException serializationException) {
            throw new SOAPException(serializationException);
        }
    }

    private SOAPElement getFirstChild(SOAPElement sOAPElement) throws SOAPException {
        Iterator iterator = this.getNonSpaceChildElements(sOAPElement);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPElement)) continue;
            return (SOAPElement)e;
        }
        throw new SOAPException("no element found inside body");
    }

    private SOAPElement createWrapElement(SOAPBody sOAPBody) throws SOAPException {
        SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)sOAPBody.getParentElement();
        Name name = this.namespace == null ? sOAPEnvelope.createName(this.name) : sOAPEnvelope.createName(this.name, PREFIX, this.namespace);
        SOAPBodyElement sOAPBodyElement = sOAPBody.addBodyElement(name);
        if (this.namespace != null) {
            sOAPBodyElement.addNamespaceDeclaration(PREFIX, this.namespace);
        }
        return sOAPBodyElement;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DefaultMessage[");
        stringBuffer.append("name=").append(this.name).append(",\n");
        stringBuffer.append("namespace=").append(this.namespace).append(",\n");
        stringBuffer.append("encodingStyle=").append(this.encodingStyle).append(",\n");
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PREFIX = "m";
    }

    public static class NonSpaceIterator
    implements Iterator {
        private Iterator it;
        private Object next;

        public NonSpaceIterator(Iterator iterator) {
            this.it = iterator;
        }

        public void remove() {
            throw new Error("not supported");
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.it.hasNext()) {
                this.next = this.it.next();
                if (!(this.next instanceof SOAPElement)) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            Object e;
            if (this.next != null) {
                Object object = this.next;
                this.next = null;
                return object;
            }
            while (!((e = this.it.next()) instanceof SOAPElement)) {
            }
            return e;
        }
    }
}

