/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import weblogic.webservice.client.JSSEAdapter;
import weblogic.webservice.client.SSLAdapter;
import weblogic.webservice.client.SSLTunnelSocketFactory;
import weblogic.webservice.client.SSLUtil;

public class JSSEAdapter
implements SSLAdapter {
    public static final String STRICT_CHECKING_DEFAULT = "weblogic.webservice.client.ssl.strictcertchecking";
    public static final String VERBOSE_PROPERTY = "weblogic.webservice.client.verbose";
    public static final String TRUSTED_CERTS = "weblogic.webservice.client.ssl.trustedcertfile";
    public static final String ENFORCE_CONSTRAINTS = "weblogic.security.SSL.enforceConstraints";
    private static final String HTTPS_PROXY_HOST = "weblogic.webservice.transport.https.proxy.host";
    private static final String HTTPS_PROXY_PORT = "weblogic.webservice.transport.https.proxy.port";
    private static final String DEFAULT_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String DEFAULT_HTTPS_PROXY_PORT = "https.proxyPort";
    private SSLSocketFactory _factory;
    SSLSocketFactory factory;
    private static String proxyHost;
    private static String proxyPort;
    private static final TrustManager trustingManager;
    private static TrustManager strictManager;
    private static KeyManager localKeyManager;
    private static SSLContext context;
    private static final HostnameVerifier nonverifier;
    private HostnameVerifier verifier;
    protected static boolean verbose;
    private static boolean strictCheckingDefault;
    protected boolean strictCertChecking;
    protected static String trustedCertFile;
    private String[] enabledCiphers;
    private InputStream myKeystream;
    private char[] myPassword;
    boolean proxyEnabled;
    private static String defaultProxyHost;
    private static int defaultProxyPort;

    public JSSEAdapter() {
        this.factory = this._factory = null;
        this.verifier = null;
        this.strictCertChecking = true;
        this.enabledCiphers = null;
        this.myKeystream = null;
        this.myPassword = null;
        this.proxyEnabled = false;
        this.setStrictChecking(this.getStrictCheckingDefault());
        if (proxyHost != null && proxyPort != null) {
            this.enableProxy(proxyHost, proxyPort);
        }
    }

    public JSSEAdapter(boolean bl) {
        this.factory = this._factory = null;
        this.verifier = null;
        this.strictCertChecking = true;
        this.enabledCiphers = null;
        this.myKeystream = null;
        this.myPassword = null;
        this.proxyEnabled = false;
        this.setStrictChecking(bl);
        if (proxyHost != null && proxyPort != null) {
            this.enableProxy(proxyHost, proxyPort);
        }
    }

    public void enableProxy(String string, String string2) {
        this.factory = new SSLTunnelSocketFactory(this._factory, string, string2);
        this.proxyEnabled = true;
    }

    public void disableProxy() {
        this.factory = this._factory;
        this.proxyEnabled = false;
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = proxyHost != null ? (SSLSocket)this.createProxySocket(string, n) : (SSLSocket)this.getSocketFactory().createSocket(string, n);
            if (this.enabledCiphers != null) {
                sSLSocket.setEnabledCipherSuites(this.enabledCiphers);
            }
            if (verbose) {
                System.out.println("JSSEAdapter connecting to:" + string + " port:" + n + " socket:" + sSLSocket);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException("JSSEAdapter unable to create SSLSocket instance");
        }
        return sSLSocket;
    }

    public Socket createProxySocket(String string, int n) throws IOException {
        Socket socket = SSLUtil.doTunnelHandshake(proxyHost, Integer.valueOf(proxyPort), string, n);
        return this.factory.createSocket(socket, string, n, false);
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        try {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
            httpsURLConnection.setSSLSocketFactory(this.factory);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Throwable throwable) {
            System.out.println("JSSEAdapter exception: " + throwable.getMessage());
        }
        return uRLConnection;
    }

    public static void setStrictCheckingDefault(boolean bl) {
        if (verbose) {
            System.out.println("JSSEAdapter set default cert checking to: " + (bl ? "STRICT." : "ACCEPTING."));
        }
        strictCheckingDefault = bl;
    }

    protected final boolean getStrictCheckingDefault() {
        return strictCheckingDefault;
    }

    public final void setStrictChecking(boolean bl) {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("JSSEAdapter cannot change certificate checking once the adapter has been used.");
        }
        this._setStrictChecking(bl);
        if (bl) {
            this.setHostnameVerifier(this.verifier);
        } else {
            this.setHostnameVerifier(nonverifier);
        }
    }

    public final void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.verifier = hostnameVerifier;
        if (hostnameVerifier != null) {
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        } else if (verbose) {
            System.out.println("JSSEAdapter using the default JSSE HostnameVerifier.");
        }
    }

    public void setVerbose(boolean bl) {
        verbose = bl;
    }

    public final void setTrustManager(TrustManager trustManager) {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("JSSEAdapter cannot change trust manager once the adapter has been used");
        }
        try {
            TrustManager[] trustManagerArray = new X509TrustManager[]{(X509TrustManager)trustManager};
            if (this.myKeystream != null) {
                File file = File.createTempFile("wsjsse", ".fix");
                file.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(this.myKeystream, this.myPassword);
                keyStore.store(fileOutputStream, this.myPassword);
                fileOutputStream.close();
                System.setProperty("javax.net.ssl.keyStore", file.getAbsolutePath());
                System.setProperty("javax.net.ssl.keyStorePassword", new String(this.myPassword));
                if (verbose) {
                    System.out.println("JSSEAdapter setting KeyManager to: " + file.getName());
                }
            } else {
                context.init(null, trustManagerArray, new SecureRandom());
                if (verbose) {
                    System.out.println("JSSEAdapter KeyManager null");
                }
            }
        }
        catch (Exception exception) {
            if (verbose) {
                System.out.println("JSSEAdapter failure in getInstance.");
                exception.printStackTrace();
            }
            throw new IllegalArgumentException("JSSEAdapter failed to obtain SSLContext.");
        }
        if (verbose) {
            System.out.println("JSSEAdapter setTrustManager to " + trustManager);
        }
    }

    public final void loadLocalIdentity(InputStream inputStream, char[] cArray) throws Exception {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("JSSEAdapter cannot load identities once the adapter has been used.");
        }
        this.myKeystream = inputStream;
        this.myPassword = cArray;
        if (verbose) {
            System.out.println("JSSEAdapter Loaded local identity from keystore: " + inputStream);
        }
    }

    protected final void _setStrictChecking(boolean bl) {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("JSSEAdapter cannot change strict checking once the adapter has been used");
        }
        if (bl) {
            if (verbose) {
                System.out.println("JSSEAdapter enabling strict checking on adapter " + this);
            }
            this.setTrustManager(strictManager);
        } else {
            if (verbose) {
                System.out.println("JSSEAdapter disabling strict checking on adapter " + this);
            }
            this.setTrustManager(trustingManager);
        }
        this.strictCertChecking = bl;
    }

    private void resetFactory() {
        this._factory = null;
    }

    protected SSLSocketFactory getSocketFactory() {
        if (this.factory == null) {
            this.factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            if (verbose) {
                System.out.println("JSSEAdaptger got new socketfactory: " + this.factory);
            }
        }
        return this.factory;
    }

    public void setSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this._factory = sSLSocketFactory;
        if (!this.proxyEnabled) {
            this.factory = sSLSocketFactory;
        } else {
            ((SSLTunnelSocketFactory)sSLSocketFactory).setDelegateFactory(sSLSocketFactory);
        }
    }

    protected boolean adapterUsed() {
        return this.factory != null;
    }

    public void setProxy(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Must provide a proxy hostname");
        }
        proxyHost = string;
        proxyPort = Integer.toString(n);
    }

    public void setProxyAuth(String string, String string2) {
        if (!this.proxyEnabled) {
            throw new IllegalStateException("Cannot set proxy username/password until proxy has been enabled.");
        }
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Cannot set username or password to null");
        }
        ((SSLTunnelSocketFactory)this.factory).setProxyAuth(string, string2);
    }

    public String toString() {
        return "<JSSEAdapter name=\"" + super.toString() + "\" proxyEnabled=" + this.proxyEnabled + " proxyHost=" + proxyHost + " proxyPort=" + proxyPort + ">\n" + this.factory + "\n</JSSEAdapter>";
    }

    protected final SSLContext getContext() {
        if (context == null) {
            try {
                context = SSLContext.getInstance("SSL");
            }
            catch (Exception exception) {
                if (verbose) {
                    System.out.println("JSSEAdapter failure in getInstance.");
                    exception.printStackTrace();
                }
                throw new IllegalArgumentException("JSSEAdapter failed to obtain SSLContext.");
            }
        }
        return context;
    }

    public static void main(String[] stringArray) {
        try {
            JSSEAdapter jSSEAdapter = new JSSEAdapter();
            jSSEAdapter.setVerbose(true);
            System.out.println("-----------------------------\nraw adapter:\n" + jSSEAdapter);
            jSSEAdapter.disableProxy();
            System.out.println("-----------------------------\nProxy Disabled:\n" + jSSEAdapter);
            try {
                jSSEAdapter.setStrictChecking(true);
                System.out.println("** success -- setStrictChecking true");
            }
            catch (Exception exception) {
                System.out.println("Caught exception when setStrictChecking true: " + exception);
            }
            try {
                System.out.println("** success -- Got socket: " + jSSEAdapter.createSocket("127.0.0.1", 7002));
            }
            catch (IOException iOException) {
                System.out.println("Caught exception when creating socket: " + iOException);
            }
            try {
                jSSEAdapter.setProxyAuth("pete", "password");
                System.out.println("** failure -- set proxy auth when proxy should be disabled");
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("** success -- cauth IllegalStateException trying to set proxy when proxy disabled");
            }
            jSSEAdapter.enableProxy("127.0.0.1", "3128");
            System.out.println("-----------------------------\nProxy Enabled:\n" + jSSEAdapter);
            try {
                Socket socket = jSSEAdapter.createSocket("127.0.0.1", 7002);
                System.out.println("** success -- Got socket: " + socket);
            }
            catch (IOException iOException) {
                System.out.println("Caught exception when creating socket: " + iOException);
            }
            try {
                jSSEAdapter.setProxyAuth("pete", null);
                System.out.println("** failure -- set proxy auth when proxy should be disabled");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("** success -- cauth IllegalArgumentException trying to set password to null");
            }
            try {
                jSSEAdapter.setProxyAuth(null, "pete");
                System.out.println("** failure -- set proxy auth when proxy should be disabled");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("** success -- cauth IllegalArgumentException trying to set user to null");
            }
            jSSEAdapter.disableProxy();
            try {
                System.out.println("** success -- Got socket: " + jSSEAdapter.createSocket("127.0.0.1", 7002));
            }
            catch (IOException iOException) {
                System.out.println("Caught exception when creating socket: " + iOException);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Caught exception:" + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    static {
        block7: {
            proxyHost = System.getProperty(HTTPS_PROXY_HOST);
            proxyPort = System.getProperty(HTTPS_PROXY_PORT);
            trustingManager = new NullTrustManager(null);
            strictManager = null;
            localKeyManager = null;
            context = null;
            nonverifier = new NullVerifier(null);
            verbose = false;
            strictCheckingDefault = true;
            trustedCertFile = null;
            defaultProxyHost = null;
            defaultProxyPort = 8080;
            try {
                verbose = Boolean.getBoolean(VERBOSE_PROPERTY);
                if (verbose) {
                    System.out.println("JSSEAdapter verbose output enabled");
                }
                if ("false".equals(System.getProperty(STRICT_CHECKING_DEFAULT))) {
                    strictCheckingDefault = false;
                    if (verbose) {
                        System.out.println("JSSEAdapter strict cert checking disabled by default");
                    }
                }
                if ((trustedCertFile = System.getProperty(TRUSTED_CERTS)) != null && verbose) {
                    System.out.println("JSSEAdapter trusted certificates will be loaded from " + trustedCertFile);
                }
                defaultProxyHost = System.getProperty(HTTPS_PROXY_HOST);
                String string = System.getProperty(HTTPS_PROXY_PORT);
                if (string != null) {
                    defaultProxyPort = Integer.parseInt(string);
                }
                context = SSLContext.getInstance("SSL");
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
                trustManagerFactory.init((KeyStore)null);
                strictManager = trustManagerFactory.getTrustManagers()[0];
            }
            catch (Throwable throwable) {
                if (!verbose) break block7;
                System.out.println("JSSEAdapter error: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
    }
}

