/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.client;

import com.certicom.net.ssl.SSLContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.webservice.client.BaseWLSSLAdapter;
import weblogic.webservice.client.SSLAdapter;
import weblogic.webservice.client.SSLUtil;
import weblogic.webservice.client.TrustManager;

public abstract class BaseWLSSLAdapter
implements SSLAdapter {
    public static final String STRICT_CHECKING_DEFAULT = "weblogic.webservice.client.ssl.strictcertchecking";
    public static final String VERBOSE_PROPERTY = "weblogic.webservice.client.verbose";
    public static final String TRUSTED_CERTS = "weblogic.webservice.client.ssl.trustedcertfile";
    public static final String ENFORCE_CONSTRAINTS = "weblogic.security.SSL.enforceConstraints";
    private static final String HTTPS_PROXY_HOST = "weblogic.webservice.transport.https.proxy.host";
    private static final String HTTPS_PROXY_PORT = "weblogic.webservice.transport.https.proxy.port";
    protected static boolean verbose;
    private static boolean strictCheckingDefault;
    protected static String trustedCertFile;
    private SSLContext context;
    private final TrustManager trustingManager;
    private TrustManager strictManager;
    private SSLSocketFactory socketFactory;
    protected boolean strictCertChecking;
    private String[] enabledCiphers;
    private String proxyHost;
    private int proxyPort;
    private static String defaultProxyHost;
    private static int defaultProxyPort;
    private static final int CONSTRAINTS_OFF = 0;
    private static final int CONSTRAINTS_STRONG = 1;
    private static final int CONSTRAINTS_STRICT = 2;
    static int enforceConstraints;
    private static final CertificateFactory javaCertFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public BaseWLSSLAdapter() {
        block15: {
            this.context = null;
            this.trustingManager = new NullTrustManager(null);
            this.strictManager = null;
            this.socketFactory = null;
            this.strictCertChecking = true;
            this.enabledCiphers = null;
            this.proxyHost = null;
            if (defaultProxyHost != null) {
                this.proxyHost = defaultProxyHost;
                this.proxyPort = defaultProxyPort;
            }
            if (trustedCertFile != null) {
                FileInputStream fileInputStream = null;
                fileInputStream = new FileInputStream(trustedCertFile);
                this.loadTrustedCertificates(fileInputStream);
                Object var4_2 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    break block15;
                }
                catch (IOException iOException) {
                    if (verbose) {
                        System.out.println("Warning: trusted cert file close error: " + iOException.getMessage());
                    }
                    break block15;
                }
                {
                    catch (Exception exception) {
                        System.out.println("Warning: Unable to load trusted certificates from file " + trustedCertFile + ":" + exception.getMessage());
                        Object var4_3 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            break block15;
                        }
                        catch (IOException iOException) {
                            if (verbose) {
                                System.out.println("Warning: trusted cert file close error: " + iOException.getMessage());
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block16: {
                        Object var4_4 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (!verbose) break block16;
                            System.out.println("Warning: trusted cert file close error: " + iOException.getMessage());
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    public final Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = null;
        try {
            if (this.proxyHost != null) {
                sSLSocket = (SSLSocket)this.createProxySocket(string, n);
            } else {
                if (n < 0) {
                    n = 443;
                }
                sSLSocket = (SSLSocket)this.getSocketFactory().createSocket(string, n);
            }
            if (this.enabledCiphers != null) {
                sSLSocket.setEnabledCipherSuites(this.enabledCiphers);
            }
            if (verbose) {
                System.out.println("Connecting to:" + string + " port:" + n + " socket:" + sSLSocket);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Unable to create SSLSocket instance");
        }
        return sSLSocket;
    }

    public abstract URLConnection openConnection(URL var1) throws IOException;

    public static void setStrictCheckingDefault(boolean bl) {
        if (verbose) {
            System.out.println("Set default cert checking to " + (bl ? "strict" : "accepting"));
        }
        strictCheckingDefault = bl;
    }

    public void setVerbose(boolean bl) {
        verbose = bl;
    }

    protected final void _setStrictChecking(boolean bl) {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("Cannot change certificate checking once the adapter has been used");
        }
        if (bl) {
            if (verbose) {
                System.out.println("Enabling strict checking on adapter " + this);
            }
            this.setTrustManager(this.strictManager);
        } else {
            if (verbose) {
                System.out.println("Disabling strict checking on adapter " + this);
            }
            this.setTrustManager(this.trustingManager);
        }
        this.strictCertChecking = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setTrustedCertificatesFile(String string) {
        block25: {
            Object object;
            if (this.adapterUsed()) {
                throw new IllegalArgumentException("Cannot change trusted certificate file once the adapter has been used");
            }
            boolean bl = false;
            try {
                object = new FileInputStream(string);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = bufferedReader.readLine();
                if (string2.equalsIgnoreCase("-----BEGIN CERTIFICATE-----")) {
                    bl = true;
                }
                ((FileInputStream)object).close();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Could not load trusted certificate file: " + string + " due to error: " + exception);
            }
            if (!bl) {
                if (verbose) {
                    System.out.println("Could not locate PEM preamble, now trying file as JKS");
                }
                object = null;
                try {
                    object = this.doPemCvt(string);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Could not obtain certificate from file as JKS: " + string + " due to error: " + exception);
                }
                if (object != null) {
                    if (verbose) {
                        System.out.println("temp PEM file created: " + ((File)object).getAbsolutePath());
                    }
                    string = ((File)object).getAbsolutePath();
                    bl = true;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("Could not obtain certificate from file: " + string);
            }
            trustedCertFile = string;
            if (trustedCertFile != null) {
                object = null;
                object = new FileInputStream(trustedCertFile);
                this.loadTrustedCertificates((InputStream)object);
                Object var8_10 = null;
                try {
                    if (object != null) {
                        ((FileInputStream)object).close();
                    }
                    break block25;
                }
                catch (IOException iOException) {
                    if (verbose) {
                        System.out.println("Warning: set trusted cert file close error: " + iOException.getMessage());
                    }
                    break block25;
                }
                {
                    catch (Exception exception) {
                        System.out.println("Warning: Unable to load trusted certificates from file " + trustedCertFile + ":" + exception.getMessage());
                        Object var8_11 = null;
                        try {
                            if (object != null) {
                                ((FileInputStream)object).close();
                            }
                            break block25;
                        }
                        catch (IOException iOException) {
                            if (verbose) {
                                System.out.println("Warning: set trusted cert file close error: " + iOException.getMessage());
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block26: {
                        Object var8_12 = null;
                        try {
                            if (object != null) {
                                ((FileInputStream)object).close();
                            }
                        }
                        catch (IOException iOException) {
                            if (!verbose) break block26;
                            System.out.println("Warning: set trusted cert file close error: " + iOException.getMessage());
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private final void loadTrustedCertificates(InputStream inputStream) throws KeyManagementException {
        this.getContext().loadTrustedCertificates(inputStream);
        if (verbose) {
            System.out.println("Loaded local trusted certificates from " + inputStream);
        }
    }

    public final void loadLocalIdentity(InputStream inputStream, char[] cArray) throws KeyManagementException {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("Cannot load identities once the adapter has been used");
        }
        this.getContext().loadLocalIdentity(inputStream, cArray);
        if (verbose) {
            System.out.println("Loaded local identity from " + inputStream);
        }
    }

    public final X509Certificate[] getIdentity(String string, int n) {
        return this.getContext().getAuthChain(string, n);
    }

    public final void addIdentity(X509Certificate[] x509CertificateArray, byte[] byArray) {
        if (this.adapterUsed()) {
            throw new IllegalStateException("Cannot add identities once the adapter has been used");
        }
        this.getContext().addAuthChain(x509CertificateArray, byArray);
    }

    public final void addIdentity(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        if (this.adapterUsed()) {
            throw new IllegalStateException("Cannot add identities once the adapter has been used");
        }
        this.getContext().addAuthChain(x509CertificateArray, privateKey);
    }

    public final void addIdentity(java.security.cert.X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        try {
            X509Certificate[] x509CertificateArray2 = BaseWLSSLAdapter.X509java2javax(x509CertificateArray);
            this.addIdentity(x509CertificateArray2, privateKey);
        }
        catch (CertificateException certificateException) {
            throw new IllegalArgumentException("failed to process provided certificates: " + certificateException);
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("failed to process provided certificates:" + certificateEncodingException);
        }
    }

    public final void removeIdentity(X509Certificate x509Certificate) {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("Cannot add identities once the adapter has been used");
        }
        this.getContext().removeAuthChain(x509Certificate);
    }

    public final void removeIdentity(java.security.cert.X509Certificate x509Certificate) {
        try {
            this.removeIdentity(BaseWLSSLAdapter.X509java2javax(x509Certificate));
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("failed to process provided certificates: " + certificateEncodingException);
        }
        catch (CertificateException certificateException) {
            throw new IllegalArgumentException("failed to process provided certificates: " + certificateException);
        }
    }

    public final void setProtocolVersion(String string) {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("Cannot change protocol version once adapter has been used");
        }
        this.getContext().setHelloProtocol(string);
    }

    public final String getProtocolVersion() {
        return this.getContext().getHelloProtocol();
    }

    public final void setTrustManager(TrustManager trustManager) {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("Cannot change trust manager once the adapter has been used");
        }
        this.getContext().setTrustManager((com.certicom.net.ssl.TrustManager)trustManager);
        if (verbose) {
            System.out.println("Set TrustManager to " + trustManager);
        }
    }

    public final void setTrustManager(TrustManager trustManager, Object object) {
        if (this.adapterUsed()) {
            throw new IllegalArgumentException("Cannot change trust manager once the adapter has been used");
        }
        this.strictManager = trustManager;
        this.getContext().setTrustManager((com.certicom.net.ssl.TrustManager)trustManager, object);
        this.resetFactory();
        if (verbose) {
            System.out.println("Set TrustManager to " + trustManager + " with callback " + object);
        }
    }

    public void setProxy(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Must provide a proxy hostname");
        }
        this.proxyHost = string;
        this.proxyPort = n;
    }

    public void clearProxy() {
        this.proxyHost = null;
    }

    protected final SSLContext getContext() {
        if (this.context == null) {
            this.context = new SSLContext();
            this.setX509ConstraintBug(this.context);
        }
        return this.context;
    }

    private void setX509ConstraintBug(SSLContext sSLContext) {
        if (enforceConstraints == 2) {
            sSLContext.setX509BasicConstraintBug(false);
            sSLContext.setX509StrictConstraints(true);
        } else if (enforceConstraints == 0) {
            sSLContext.setX509BasicConstraintBug(true);
            sSLContext.setX509StrictConstraints(false);
        } else {
            sSLContext.setX509BasicConstraintBug(false);
            sSLContext.setX509StrictConstraints(false);
        }
    }

    protected final boolean getStrictCheckingDefault() {
        return strictCheckingDefault;
    }

    private void resetFactory() {
        this.socketFactory = null;
    }

    protected SSLSocketFactory getSocketFactory() {
        if (this.socketFactory == null) {
            this.socketFactory = this.getContext().getSocketFactory();
            if (verbose) {
                System.out.println("Got new socketfactory " + this.socketFactory);
            }
        }
        return this.socketFactory;
    }

    protected boolean adapterUsed() {
        return this.socketFactory != null;
    }

    private Socket createProxySocket(String string, int n) throws IOException {
        Socket socket = SSLUtil.doTunnelHandshake(this.proxyHost, this.proxyPort, string, n);
        return this.getSocketFactory().createSocket(socket, string, n, false);
    }

    public static final X509Certificate X509java2javax(java.security.cert.X509Certificate x509Certificate) throws java.security.cert.CertificateEncodingException, CertificateException {
        X509Certificate x509Certificate2 = X509Certificate.getInstance(x509Certificate.getEncoded());
        return x509Certificate2;
    }

    public static final java.security.cert.X509Certificate X509javax2java(X509Certificate x509Certificate) throws java.security.cert.CertificateException, CertificateEncodingException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getEncoded());
        java.security.cert.X509Certificate x509Certificate2 = (java.security.cert.X509Certificate)javaCertFactory.generateCertificate(byteArrayInputStream);
        return x509Certificate2;
    }

    public static final X509Certificate[] X509java2javax(java.security.cert.X509Certificate[] x509CertificateArray) throws CertificateException, java.security.cert.CertificateEncodingException {
        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            java.security.cert.X509Certificate x509Certificate = x509CertificateArray[i];
            x509CertificateArray2[i] = BaseWLSSLAdapter.X509java2javax(x509Certificate);
        }
        return x509CertificateArray2;
    }

    public static final java.security.cert.X509Certificate[] X509javax2java(X509Certificate[] x509CertificateArray) throws CertificateEncodingException, java.security.cert.CertificateException {
        java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            X509Certificate x509Certificate = x509CertificateArray[i];
            x509CertificateArray2[i] = BaseWLSSLAdapter.X509javax2java(x509Certificate);
        }
        return x509CertificateArray2;
    }

    private File doPemCvt(String string) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File file = null;
        try {
            file = File.createTempFile("wls", ".pem");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            File file2 = new File(string);
            keyStore.load(new FileInputStream(file2), null);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                Certificate certificate = keyStore.getCertificate(string2);
                String string3 = bASE64Encoder.encodeBuffer(certificate.getEncoded());
                printWriter.println("-----BEGIN CERTIFICATE-----");
                printWriter.println(string3);
                printWriter.println("-----END CERTIFICATE-----");
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            if (verbose) {
                System.out.println(exception.getMessage());
            }
            file = null;
        }
        return file;
    }

    static {
        Object object;
        block17: {
            block16: {
                verbose = false;
                strictCheckingDefault = true;
                trustedCertFile = null;
                defaultProxyHost = null;
                defaultProxyPort = 8080;
                enforceConstraints = 1;
                try {
                    String string;
                    verbose = Boolean.getBoolean(VERBOSE_PROPERTY);
                    if (verbose) {
                        System.out.println("SSLAdapter verbose output enabled");
                    }
                    if ("false".equals(System.getProperty(STRICT_CHECKING_DEFAULT))) {
                        strictCheckingDefault = false;
                        if (verbose) {
                            System.out.println("Strict cert checking disabled by default");
                        }
                    }
                    if ((trustedCertFile = System.getProperty(TRUSTED_CERTS)) != null && verbose) {
                        System.out.println("Trusted certificates will be loaded from " + trustedCertFile);
                    }
                    defaultProxyHost = System.getProperty(HTTPS_PROXY_HOST);
                    object = System.getProperty(HTTPS_PROXY_PORT);
                    if (object != null) {
                        defaultProxyPort = Integer.parseInt((String)object);
                    }
                    if ((string = System.getProperty(ENFORCE_CONSTRAINTS)) != null) {
                        if (string.equalsIgnoreCase("off") || string.equalsIgnoreCase("false")) {
                            enforceConstraints = 0;
                        } else if (string.equalsIgnoreCase("strong") || string.equalsIgnoreCase("true")) {
                            enforceConstraints = 1;
                        } else if (string.equalsIgnoreCase("strict")) {
                            enforceConstraints = 2;
                        }
                    }
                    if (enforceConstraints == 0 && verbose) {
                        System.out.println("BasicContraints enforcement is disabled");
                    }
                }
                catch (Throwable throwable) {
                    if (!verbose) break block16;
                    System.out.println("SSLAdapter error: " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            object = null;
            try {
                object = CertificateFactory.getInstance("X.509");
            }
            catch (java.security.cert.CertificateException certificateException) {
                if (!verbose) break block17;
                System.out.println("Warning -- Peer did not provide auth chain");
            }
        }
        javaCertFactory = object;
    }
}

