/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.soap;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import weblogic.utils.io.Chunk;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.binding.soap.HttpResponse;

public final class HttpResponseParser {
    private static final boolean debug = false;
    private static final char[] HTTP_STATUS = new char[]{'H', 'T', 'T', 'P', '/'};

    public static HttpResponse parse(URL uRL, InputStream inputStream) throws IOException {
        HttpResponse httpResponse = new HttpResponse(uRL);
        Chunk chunk = HttpResponseParser.newChunk();
        try {
            HttpResponseParser.readLine(chunk, inputStream);
        }
        catch (EOFException eOFException) {
            HttpResponseParser.throwEOF(chunk, uRL);
        }
        Chunk chunk2 = HttpResponseParser.parseFirstLine(chunk, httpResponse);
        chunk2 = HttpResponseParser.parseHTTPHeaders(chunk2, httpResponse, inputStream);
        if (chunk2.end == Chunk.CHUNK_SIZE) {
            chunk2.end = 0;
        }
        HttpResponseParser.checkKeepAlive(httpResponse);
        int n = chunk2.end;
        if (httpResponse.isKeepAliveEnabled()) {
            String string = httpResponse.getHeader("content-length");
            try {
                int n2 = Integer.parseInt(string);
                HttpResponseParser.fillKeepAliveChunk(chunk2, n2, inputStream);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Content-length was not a number:" + string);
            }
        } else {
            HttpResponseParser.fillChunkUntilEOF(chunk2, inputStream);
        }
        httpResponse.setBody(chunk2, n);
        return httpResponse;
    }

    private static void checkKeepAlive(HttpResponse httpResponse) throws IOException {
        String string = httpResponse.getHeader("CONNECTION");
        if (string == null) {
            httpResponse.setKeepAliveEnabled(httpResponse.getMinorVersion() == 1);
        } else {
            httpResponse.setKeepAliveEnabled("keep-alive".equalsIgnoreCase(string));
        }
        if (httpResponse.isKeepAliveEnabled() && "chunked".equalsIgnoreCase(httpResponse.getHeader("Transfer-Encoding"))) {
            throw new IOException("The server at: " + httpResponse.getURL() + " specified Transfer-Encoding: chunked.  This HTTP client" + " does not currently support chunked transfer encoding.");
        }
        if (httpResponse.getHeader("content-length") == null) {
            httpResponse.setKeepAliveEnabled(false);
        }
    }

    private static String msg2String(Chunk chunk) {
        return HttpResponseParser.msg2String(chunk, 0);
    }

    private static String msg2String(Chunk chunk, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new String(chunk.buf, n, chunk.end));
        Chunk chunk2 = chunk.next;
        while (chunk2 != null) {
            stringBuffer.append(new String(chunk2.buf, 0, chunk2.end));
            chunk2 = chunk2.next;
        }
        return stringBuffer.toString();
    }

    private static Chunk newChunk() {
        return HttpResponseParser.newChunk(null);
    }

    private static Chunk newChunk(Chunk chunk) {
        Chunk chunk2 = Chunk.getChunk();
        if (chunk != null) {
            chunk.next = chunk2;
        }
        return chunk2;
    }

    private static Chunk parseFirstLine(Chunk chunk, HttpResponse httpResponse) throws IOException {
        int n;
        for (n = 0; n < HTTP_STATUS.length; ++n) {
            if (chunk.buf[n] == HTTP_STATUS[n]) continue;
            WebServiceLogger.logInvalidHttpResponse2(httpResponse.getURL().toString(), HttpResponseParser.msg2String(chunk));
            throw new IOException("The server at :" + httpResponse.getURL() + " did not provide a valid HTTP response: " + HttpResponseParser.msg2String(chunk));
        }
        n = chunk.buf[5] - 48;
        int n2 = chunk.buf[7] - 48;
        httpResponse.setMajorVersion(n);
        httpResponse.setMinorVersion(n2);
        if (n != 1) {
            WebServiceLogger.logUnexpectedHTTPVersion(httpResponse.getURL().toString(), n, n2, HttpResponseParser.msg2String(chunk));
            throw new IOException("The server at :" + httpResponse.getURL() + " did not provide a valid HTTP response: " + HttpResponseParser.msg2String(chunk));
        }
        if (n2 == 1 || n2 == 0) {
            int n3 = (chunk.buf[9] - 48) * 100 + (chunk.buf[10] - 48) * 10 + chunk.buf[11] - 48;
            httpResponse.setStatusCode(n3);
            return chunk;
        }
        WebServiceLogger.logUnexpectedHTTPVersion(httpResponse.getURL().toString(), n, n2, HttpResponseParser.msg2String(chunk));
        throw new IOException("The server at :" + httpResponse.getURL() + " did not provide a valid HTTP response: " + HttpResponseParser.msg2String(chunk));
    }

    private static Chunk parseHTTPHeaders(Chunk chunk, HttpResponse httpResponse, InputStream inputStream) throws IOException {
        Chunk chunk2 = chunk;
        block0: while (true) {
            Object object;
            if (chunk2.end == Chunk.CHUNK_SIZE) {
                chunk2 = HttpResponseParser.newChunk(chunk2);
            }
            int n = chunk2.end;
            HttpResponseParser.readLine(chunk2, inputStream);
            if (chunk2.buf[n] == 13) {
                if (n + 1 == Chunk.CHUNK_SIZE) {
                    object = chunk2.next;
                    if (((Chunk)object).buf[0] == 10) {
                        return object;
                    }
                } else if (chunk2.buf[n + 1] == 10) {
                    return chunk2;
                }
            }
            object = new StringBuffer();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            int n2 = n;
            while (true) {
                if (n2 == chunk2.end) {
                    if (n2 < Chunk.CHUNK_SIZE || chunk2.next == null) {
                        httpResponse.addHeader(((StringBuffer)object).toString(), stringBuffer.toString());
                        continue block0;
                    }
                    n2 = 0;
                    Chunk chunk3 = chunk2;
                    chunk2 = chunk2.next;
                    Chunk.releaseChunk(chunk3);
                } else if (chunk2.buf[n2] == 58) {
                    bl = false;
                } else if (bl) {
                    ((StringBuffer)object).append((char)chunk2.buf[n2]);
                } else {
                    stringBuffer.append((char)chunk2.buf[n2]);
                }
                ++n2;
            }
            break;
        }
    }

    private static int msgSize(Chunk chunk) {
        int n = 0;
        Chunk chunk2 = chunk;
        while (chunk2 != null) {
            n += chunk2.end;
            chunk2 = chunk2.next;
        }
        return n;
    }

    private static void throwEOF(Chunk chunk, URL uRL) throws EOFException {
        WebServiceLogger.logUnexpectedEOF(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), HttpResponseParser.msgSize(chunk));
        throw new EOFException("Received EOF from: " + uRL + " after reading " + HttpResponseParser.msgSize(chunk) + " bytes.");
    }

    private static void readLine(Chunk chunk, InputStream inputStream) throws IOException {
        boolean bl = false;
        Chunk chunk2 = chunk;
        while (true) {
            if (chunk2.end == Chunk.CHUNK_SIZE) {
                chunk2 = HttpResponseParser.newChunk(chunk2);
                continue;
            }
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException();
            }
            chunk2.buf[chunk2.end++] = (byte)n;
            if (n == 13) {
                bl = true;
                continue;
            }
            if (bl && n == 10) {
                return;
            }
            bl = false;
        }
    }

    private static void fillKeepAliveChunk(Chunk chunk, int n, InputStream inputStream) throws IOException {
        int n2;
        Chunk chunk2 = chunk;
        for (int i = 0; i < n; i += n2) {
            int n3;
            if (chunk2.end == Chunk.CHUNK_SIZE) {
                chunk2 = HttpResponseParser.newChunk(chunk2);
            }
            if ((n2 = inputStream.read(chunk2.buf, chunk2.end, n3 = Math.min(n - i, Chunk.CHUNK_SIZE - chunk2.end))) == -1) {
                WebServiceLogger.logInvalidHttpResponse9();
                throw new IOException("Received EOF before reading entire message from server");
            }
            chunk2.end += n2;
        }
    }

    private static void fillChunkUntilEOF(Chunk chunk, InputStream inputStream) throws IOException {
        Chunk chunk2 = chunk;
        while (true) {
            int n;
            if (chunk2.end == Chunk.CHUNK_SIZE) {
                chunk2 = HttpResponseParser.newChunk(chunk2);
            }
            if ((n = inputStream.read(chunk2.buf, chunk2.end, Chunk.CHUNK_SIZE - chunk2.end)) == -1) {
                return;
            }
            chunk2.end += n;
        }
    }
}

