/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.soap;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.MimeHeaders;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;

public final class HttpResponse {
    private URL url;
    private Chunk body;
    private int bodyStart;
    private boolean keepAliveEnabled = false;
    private int minorVersion;
    private int majorVersion;
    private int statusCode;
    private Map headers = new HashMap();

    public HttpResponse(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public void setBody(Chunk chunk, int n) {
        this.body = chunk;
        this.bodyStart = n;
    }

    public InputStream getBodyAsStream() {
        return new ChunkedInputStream(this.body, this.bodyStart);
    }

    public String getBodyAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new String(this.body.buf, this.bodyStart, this.body.end - this.bodyStart));
        Chunk chunk = this.body.next;
        while (chunk != null) {
            stringBuffer.append(new String(chunk.buf, 0, chunk.end));
            chunk = chunk.next;
        }
        return stringBuffer.toString();
    }

    public void setKeepAliveEnabled(boolean bl) {
        this.keepAliveEnabled = bl;
    }

    public boolean isKeepAliveEnabled() {
        return this.keepAliveEnabled;
    }

    public void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string.toUpperCase(), string2.trim());
    }

    public String getHeader(String string) {
        return (String)this.headers.get(string.toUpperCase());
    }

    public Map getHeaders() {
        return this.headers;
    }

    public MimeHeaders getMimeHeaders() {
        MimeHeaders mimeHeaders = new MimeHeaders();
        Iterator iterator = this.headers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.headers.get(string);
            if (string2 == null || string2.length() == 0) continue;
            mimeHeaders.setHeader(string, string2);
        }
        return mimeHeaders;
    }

    public String toString() {
        return "HTTP Request to: " + this.url.toString() + " version: " + this.majorVersion + "." + this.minorVersion + " status code: " + this.statusCode + " keep-alive: " + this.keepAliveEnabled + " headers:\n" + this.headers + "\n\n body:\n" + this.getBodyAsString();
    }
}

