/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.soap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.webservice.WLSOAPMessage;
import weblogic.webservice.binding.AbstractBinding;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.binding.soap.HttpResponse;
import weblogic.webservice.binding.soap.HttpResponseParser;
import weblogic.webservice.binding.soap.HttpSocketPool;
import weblogic.webservice.util.AccessException;
import weblogic.webservice.util.WLMessageFactory;

public class HttpClientBinding
extends AbstractBinding {
    private URL url;
    private InputStream sis;
    private OutputStream sos;
    private Socket socket;
    private PrintStream out;
    private final MessageFactory messageFactory;
    private final HttpSocketPool socketPool = HttpSocketPool.getHttpSocketPool();
    private static final String HTTP_PROXY_HOST = "weblogic.webservice.transport.http.proxy.host";
    private static final String HTTP_PROXY_PORT = "weblogic.webservice.transport.http.proxy.port";
    private static final String WEBSERVICE_VERBOSE = "weblogic.webservice.binding.verbose";
    private static final String WEBSERVICE_VERBOSE_NORMAL = "weblogic.webservice.verbose";
    private static final String WEBSERVICE_CHARSET = "weblogic.webservice.i18n.charset";
    private static final String WEBSERVICE_LANGUAGE = "user.language";
    private static final String charset = System.getProperty("weblogic.webservice.i18n.charset");
    private static final String language = System.getProperty("user.language");
    private static final boolean verbose = Boolean.getBoolean("weblogic.webservice.binding.verbose") || Boolean.getBoolean("weblogic.webservice.verbose");
    private static final String proxyHost;
    private static final int proxyPort;
    private static int socketKeepAlives;
    private static boolean keepAliveCountingEnabled;
    static /* synthetic */ Class class$weblogic$webservice$binding$soap$HttpClientBinding;

    public static void setKeepAliveCountingEnabled(boolean bl) {
        keepAliveCountingEnabled = bl;
    }

    public static int getSocketKeepAlives() {
        return socketKeepAlives;
    }

    public HttpClientBinding(String string) throws SOAPException, IOException {
        this.url = new URL(string);
        this.messageFactory = WLMessageFactory.getInstance().getMessageFactory();
    }

    public HttpClientBinding() throws SOAPException {
        this.messageFactory = WLMessageFactory.getInstance().getMessageFactory();
    }

    public void init(BindingInfo bindingInfo) throws IOException {
        this.setBindingInfo(bindingInfo);
        this.url = new URL(bindingInfo.getAddress());
        this.out = System.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MessageContext messageContext) throws IOException, SOAPException {
        if (!(messageContext instanceof SOAPMessageContext)) {
            throw new JAXRPCException("unknow message context :" + messageContext);
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        WLSOAPMessage wLSOAPMessage = (WLSOAPMessage)((Object)sOAPMessage);
        MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
        if (this.getBindingInfo().getCharset() != null) {
            wLSOAPMessage.setCharset(this.getBindingInfo().getCharset());
        }
        sOAPMessage.writeTo(byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.socket = this.createSocket(this.url);
        boolean bl = true;
        String string = wLSOAPMessage.getContentType();
        if (wLSOAPMessage.getCharset() != null) {
            string = string + "; charset=" + wLSOAPMessage.getCharset();
        }
        try {
            this.sis = this.socket.getInputStream();
            this.sos = this.socket.getOutputStream();
            StringBuffer stringBuffer = this.createRequest(this.url);
            this.addHeader(stringBuffer, "Host", this.url.getHost() + ":" + this.getPort(this.url));
            this.addHeader(stringBuffer, "Connection", "Keep-Alive");
            this.addHeader(stringBuffer, "Content-Length", "" + byArray.length);
            this.addHeader(stringBuffer, "Content-Type", string);
            if (mimeHeaders != null) {
                Iterator iterator = mimeHeaders.getAllHeaders();
                while (iterator.hasNext()) {
                    MimeHeader mimeHeader = (MimeHeader)iterator.next();
                    if ("Content-Type".equals(mimeHeader.getName())) continue;
                    this.addHeader(stringBuffer, mimeHeader.getName(), mimeHeader.getValue());
                }
            }
            stringBuffer.append("\r\n");
            if (verbose) {
                this.dumpRequest(string, stringBuffer, byArray);
            }
            this.writeToStream(this.sos, stringBuffer, byArray);
            bl = false;
        }
        finally {
            if (bl) {
                this.cleanupSocket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageContext messageContext) throws IOException, SOAPException {
        block14: {
            if (!(messageContext instanceof SOAPMessageContext)) {
                throw new JAXRPCException("unknow message context :" + messageContext);
            }
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            try {
                String string;
                HttpResponse httpResponse = HttpResponseParser.parse(this.url, new BufferedInputStream(this.sis, 256));
                if (verbose) {
                    this.dumpResponse(httpResponse);
                }
                if (!this.validContentType(httpResponse.getContentType())) {
                    if (httpResponse.getStatusCode() == 400) {
                        throw new IOException("Received a response from url: " + this.url + " which did not have a valid SOAP content-type: " + httpResponse.getContentType() + ".  The full message was: " + httpResponse.getBodyAsString());
                    }
                    this.handleErrorResponse(httpResponse);
                }
                if ((string = httpResponse.getHeader("set-cookie")) != null && string.startsWith("JSESSIONID")) {
                    sOAPMessageContext.setProperty("SessionID", string);
                }
                try {
                    sOAPMessageContext.setMessage(this.messageFactory.createMessage(httpResponse.getMimeHeaders(), httpResponse.getBodyAsStream()));
                }
                catch (IOException iOException) {
                    throw new IOException("Error reading the response from: " + this.url + ".  Please ensure that this is a " + "valid SOAP response.  The message was: \n\n" + httpResponse.getBodyAsString());
                }
                if (!httpResponse.isKeepAliveEnabled()) break block14;
                this.releaseSocket();
                this.socket = null;
                if (!keepAliveCountingEnabled) break block14;
                Class clazz = class$weblogic$webservice$binding$soap$HttpClientBinding == null ? (class$weblogic$webservice$binding$soap$HttpClientBinding = HttpClientBinding.class$("weblogic.webservice.binding.soap.HttpClientBinding")) : class$weblogic$webservice$binding$soap$HttpClientBinding;
                synchronized (clazz) {
                    ++socketKeepAlives;
                }
            }
            finally {
                if (this.socket != null) {
                    this.cleanupSocket();
                }
            }
        }
    }

    protected void releaseSocket() {
        this.socketPool.releaseSocket(this.url, this.socket);
    }

    private boolean validContentType(String string) throws IOException {
        if (string == null) {
            return false;
        }
        String string2 = null;
        try {
            string2 = new ContentType(string).getBaseType();
        }
        catch (ParseException parseException) {
            return false;
        }
        string2 = string2.trim().toLowerCase();
        return "text/xml".startsWith(string2) || "application/soap+xml".startsWith(string2) || "multipart/related".startsWith(string2);
    }

    private String getContentType(MimeHeaders mimeHeaders) {
        String[] stringArray = mimeHeaders.getHeader("Content-Type");
        if (stringArray == null || stringArray.length == 0) {
            if ("SOAP1.1".equals(this.getBindingInfo().getType())) {
                return this.useCharset() ? "text/xml; charset=" + charset : "text/xml";
            }
            return "application/soap+xml; charset=utf-8";
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String getDefaultContentType() {
        String string = "SOAP1.1".equals(this.getBindingInfo().getType()) ? (this.useCharset() ? "text/xml; charset=" + charset : ("en".equalsIgnoreCase(language) ? "text/xml" : "text/xml; charset=utf-8")) : (this.useCharset() ? "application/soap; charset=" + charset : ("en".equalsIgnoreCase(language) ? "application/soap" : "application/soap; charset=utf-8"));
        return string;
    }

    private boolean useCharset() {
        return charset != null && charset.length() != 0;
    }

    private void handleErrorResponse(HttpResponse httpResponse) throws IOException {
        int n = httpResponse.getStatusCode();
        switch (n) {
            case 404: {
                throw new IOException("The server at " + this.url.toString() + " returned a 404 error code (Not Found).  Please ensure that your" + " URL is correct, and the web service has deployed " + "without error.");
            }
            case 403: {
                throw new AccessException("The server at " + this.url.toString() + " returned a 403 error code (Forbidden).  Please ensure that your " + "URL is correct and that the correct protocol is in use.");
            }
            case 401: {
                throw new AccessException("The server at " + this.url.toString() + " returned a 401 error code (Unauthorized).  Please check that" + " username and password are set correctly and that you have" + " permission to access the requested method.");
            }
            case 301: 
            case 302: {
                throw new IOException("Redirection not supported: The server at " + this.url.toString() + " returned a " + n + " response code indicating this resource has moved.");
            }
        }
        throw new IOException("Received a response from url: " + this.url + " which did not have a valid SOAP content-type: " + httpResponse.getContentType() + ".  The full message was: " + httpResponse.getBodyAsString());
    }

    private void writeToStream(OutputStream outputStream, StringBuffer stringBuffer, byte[] byArray) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        bufferedOutputStream.write(stringBuffer.toString().getBytes());
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.flush();
        outputStream.flush();
    }

    private void addHeader(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string).append(": ").append(string2).append("\r\n");
    }

    private StringBuffer createRequest(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("POST ");
        if (proxyHost != null) {
            stringBuffer.append(uRL.toString());
        } else {
            String string;
            stringBuffer.append(uRL.getPath());
            String string2 = uRL.getQuery();
            if (string2 != null) {
                stringBuffer.append('?');
                stringBuffer.append(string2);
            }
            if ((string = uRL.getRef()) != null) {
                stringBuffer.append('#');
                stringBuffer.append(string);
            }
        }
        stringBuffer.append(" HTTP/1.0\r\n");
        return stringBuffer;
    }

    protected Socket createSocket(URL uRL) throws IOException {
        Socket socket = this.socketPool.getSocket(uRL);
        if (socket != null) {
            return socket;
        }
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        int n = this.getPort(uRL);
        return this.createSocket(string2, n);
    }

    protected Socket createSocket(String string, int n) throws IOException {
        Socket socket = proxyHost != null ? new Socket(proxyHost, proxyPort) : new Socket(string, n);
        socket.setTcpNoDelay(true);
        return socket;
    }

    private void cleanupSocket() {
        try {
            this.sos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        this.sos = null;
        this.sis = null;
    }

    private int getPort(URL uRL) {
        return uRL.getPort() == -1 ? 80 : uRL.getPort();
    }

    private void dumpRequest(String string, StringBuffer stringBuffer, byte[] byArray) {
        this.out.println("<!-------------------- REQUEST FROM CLIENT ---------------->");
        this.out.println("URL        :  " + this.url);
        this.out.println("ContentType:  " + string);
        this.out.println("Headers    :");
        this.out.println(stringBuffer);
        this.out.println("Envelope   :");
        this.out.println(new String(byArray));
        this.out.println("<!-------------------- END REQUEST FROM CLIENT ------------>");
    }

    private void dumpResponse(HttpResponse httpResponse) {
        this.out.println("<!-------------------- RESPONSE TO CLIENT --------------->");
        this.out.println("URL        : " + this.url);
        this.out.println("StatusCode : " + httpResponse.getStatusCode());
        this.out.println("Headers    :");
        Map map = httpResponse.getHeaders();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.out.println("  " + entry.getKey() + " = " + entry.getValue());
        }
        this.out.println("Envelope   :");
        this.out.println(httpResponse.getBodyAsString());
        this.out.println("<!-------------------- END RESPONSE TO CLIENT ----------->");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = null;
        int n = 8080;
        try {
            String string2;
            string = System.getProperty(HTTP_PROXY_HOST);
            if (string != null && (string2 = System.getProperty(HTTP_PROXY_PORT)) != null) {
                n = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        proxyHost = string;
        proxyPort = n;
        socketKeepAlives = 0;
        keepAliveCountingEnabled = false;
    }
}

