/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.jms;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.utils.collections.Pool;
import weblogic.webservice.binding.jms.JMSBindingInfo;

public class JMSConnection {
    private QueueConnectionFactory factory;
    private QueueConnection connection;
    private QueueSession session;
    private QueueSender sender;
    private TextMessage message;
    private TemporaryQueue responseQueue;
    private QueueReceiver receiver;
    private Pool pool;
    private JMSBindingInfo bindingInfo;
    public static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";

    public JMSConnection(JMSBindingInfo jMSBindingInfo) throws NamingException, JMSException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", JNDI_FACTORY);
        hashtable.put("java.naming.provider.url", "t3://" + jMSBindingInfo.getHost() + ":" + jMSBindingInfo.getPort());
        InitialContext initialContext = new InitialContext(hashtable);
        this.factory = (QueueConnectionFactory)initialContext.lookup(jMSBindingInfo.getFactoryName());
        this.connection = this.factory.createQueueConnection();
        this.session = this.connection.createQueueSession(false, 1);
        Queue queue = (Queue)initialContext.lookup(jMSBindingInfo.getQueueName());
        this.sender = this.session.createSender(queue);
        this.message = this.session.createTextMessage();
        this.responseQueue = this.session.createTemporaryQueue();
        this.receiver = this.session.createReceiver((Queue)this.responseQueue);
        this.connection.start();
    }

    QueueReceiver getReceiver() {
        return this.receiver;
    }

    Queue getResponseQueue() {
        return this.responseQueue;
    }

    public QueueSender getSender() {
        return this.sender;
    }

    public TextMessage getMessage() {
        return this.message;
    }

    void setPool(Pool pool) {
        this.pool = pool;
    }

    void release() {
        this.pool.add(this);
    }

    public void close() throws JMSException {
        this.sender.close();
        this.session.close();
        this.connection.close();
        this.receiver.close();
        this.responseQueue.delete();
    }
}

