/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.jms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.naming.NamingException;
import weblogic.utils.collections.StackPool;
import weblogic.webservice.binding.jms.JMSBindingInfo;
import weblogic.webservice.binding.jms.JMSConnection;

public class ConnectionPool
extends TimerTask {
    private static ConnectionPool instance = new ConnectionPool();
    private HashMap connections = new HashMap();

    private ConnectionPool() {
    }

    public static ConnectionPool getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            Iterator iterator = this.connections.values().iterator();
            while (iterator.hasNext()) {
                JMSConnection jMSConnection;
                StackPool stackPool = (StackPool)iterator.next();
                while ((jMSConnection = (JMSConnection)stackPool.remove()) != null) {
                    try {
                        jMSConnection.close();
                    }
                    catch (JMSException jMSException) {}
                }
            }
            this.connections.clear();
        }
    }

    JMSConnection getConnection(JMSBindingInfo jMSBindingInfo) throws NamingException, JMSException {
        JMSConnection jMSConnection;
        StackPool stackPool = (StackPool)this.connections.get(jMSBindingInfo);
        if (stackPool == null) {
            stackPool = new StackPool(32);
            this.connections.put(jMSBindingInfo, stackPool);
        }
        if ((jMSConnection = (JMSConnection)stackPool.remove()) == null) {
            jMSConnection = new JMSConnection(jMSBindingInfo);
            jMSConnection.setPool(stackPool);
        }
        return jMSConnection;
    }

    public void run() {
    }
}

