/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.https;

import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import javax.xml.soap.SOAPException;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.binding.https.HttpsBindingInfo;
import weblogic.webservice.binding.soap.HttpClientBinding;

public class HttpsClientBinding
extends HttpClientBinding {
    private HttpsBindingInfo bindingInfo;
    private static final String HTTPS_SOCKET_SHARING_TIMEOUT = "https.sharedsocket.timeout";

    public void init(BindingInfo bindingInfo) throws IOException {
        super.init(bindingInfo);
        if (!(bindingInfo instanceof HttpsBindingInfo)) {
            throw new IllegalArgumentException("info should be HttpsBindingInfo");
        }
        this.bindingInfo = (HttpsBindingInfo)bindingInfo;
        String string = System.getProperty(HTTPS_SOCKET_SHARING_TIMEOUT);
        if (string != null) {
            this.bindingInfo.setSharedSocketTimeout(Integer.parseInt(string));
        }
    }

    protected Socket createSocket(String string, int n) throws IOException {
        Socket socket = this.bindingInfo.getSSLAdapter().createSocket(string, n);
        socket.setTcpNoDelay(true);
        this.bindingInfo.setSSLSecureSocket(socket, string, n);
        return socket;
    }

    protected Socket createSocket(URL uRL) throws IOException {
        if (this.bindingInfo.getSSLSocketPooling()) {
            return super.createSocket(uRL);
        }
        Socket socket = this.bindingInfo.getSSLSecureSocket(uRL.getHost(), this.getPort(uRL));
        if (socket != null && this.bindingInfo.getSocketSharing()) {
            return socket;
        }
        return this.createSocket(uRL.getHost(), this.getPort(uRL));
    }

    protected void releaseSocket() {
        if (this.bindingInfo.getSocketSharing()) {
            this.bindingInfo.setSSLSecureSocketTimeOut();
            return;
        }
        if (this.bindingInfo.getSSLSocketPooling()) {
            super.releaseSocket();
        }
        this.bindingInfo.closeSharedSocket();
    }

    private int getPort(URL uRL) {
        return uRL.getPort() == -1 ? 443 : uRL.getPort();
    }
}

