/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.InputStream;
import weblogic.utils.AssertionError;
import weblogic.utils.io.Chunk;

public class ChunkedInputStream
extends InputStream {
    protected Chunk head;
    private Chunk markHead;
    private int streamPos;
    private int markStreamPos;
    protected int chunkPos;
    private int markChunkPos;
    private InputStream is;

    protected ChunkedInputStream() {
    }

    public ChunkedInputStream(Chunk chunk, int n, InputStream inputStream) throws IOException {
        this.is = inputStream;
        this.head = chunk;
        this.skip(n);
    }

    public ChunkedInputStream(Chunk chunk, int n) {
        this.init(chunk, n);
    }

    public Chunk getChunks() {
        return this.head;
    }

    public void init(Chunk chunk, int n) {
        this.head = chunk;
        this.markHead = null;
        this.streamPos = 0;
        this.chunkPos = 0;
        this.markStreamPos = -1;
        this.markChunkPos = -1;
        this.is = null;
        try {
            this.skip(n);
        }
        catch (IOException iOException) {
            throw new AssertionError(iOException);
        }
    }

    protected void advanceList() {
        this.streamPos += this.head.end;
        this.chunkPos = 0;
        Chunk chunk = this.head.next;
        if (this.markHead == null) {
            Chunk.releaseChunk(this.head);
        }
        this.head = chunk;
    }

    public final int available() {
        int n = this.head.end - this.chunkPos;
        Chunk chunk = this.head;
        while (chunk.next != null) {
            chunk = chunk.next;
            n += chunk.end;
        }
        return n;
    }

    public void close() {
        if (this.markHead != null) {
            this.reset();
        }
        while (this.head != null) {
            this.advanceList();
        }
    }

    public final void mark(int n) {
        this.markStreamPos = this.streamPos;
        this.markChunkPos = this.chunkPos;
        this.markHead = this.head;
    }

    public final boolean markSupported() {
        return this.is == null;
    }

    public int read() throws IOException {
        if (this.chunkPos == this.head.end) {
            if (this.head.next != null) {
                this.advanceList();
            } else {
                if (this.is != null) {
                    return this.is.read();
                }
                return -1;
            }
        }
        return this.head.buf[this.chunkPos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        while (n2 > 0) {
            if (this.chunkPos == this.head.end) {
                if (this.head.next != null) {
                    this.advanceList();
                } else {
                    if (this.is != null) {
                        return n3 - n2 + this.is.read(byArray, n, n2);
                    }
                    if (n2 == n3) {
                        return -1;
                    }
                    return n3 - n2;
                }
            }
            int n4 = Math.min(this.head.end - this.chunkPos, n2);
            System.arraycopy(this.head.buf, this.chunkPos, byArray, n, n4);
            this.chunkPos += n4;
            n += n4;
            n2 -= n4;
        }
        return n3;
    }

    public final void reset() {
        this.streamPos = this.markStreamPos;
        this.chunkPos = this.markChunkPos;
        this.head = this.markHead;
        this.markChunkPos = -1;
        this.markHead = null;
        this.markStreamPos = -1;
    }

    public long skip(long l) throws IOException {
        long l2 = l;
        while (l > 0L) {
            if (this.chunkPos == this.head.end) {
                if (this.head.next != null) {
                    this.advanceList();
                } else {
                    if (this.is != null) {
                        return l2 - l + this.is.skip(l);
                    }
                    return l2 - l;
                }
            }
            long l3 = Math.min((long)(this.head.end - this.chunkPos), l);
            this.chunkPos = (int)((long)this.chunkPos + l3);
            l -= l3;
        }
        return l2;
    }

    public final int peek() {
        return this.peek(this.chunkPos);
    }

    public final int peek(int n) {
        if (this.chunkPos + n < this.head.end) {
            byte by = this.head.buf[this.chunkPos + n];
            return by & 0xFF;
        }
        int n2 = this.head.end - this.chunkPos;
        Chunk chunk = this.head.next;
        while (chunk != null) {
            if (n - n2 < chunk.end) {
                byte by = chunk.buf[n - n2];
                return by & 0xFF;
            }
            n2 += chunk.end;
            chunk = chunk.next;
        }
        return -1;
    }

    public final int pos() {
        return this.streamPos + this.chunkPos;
    }

    public String toString() {
        return super.toString() + " - currentPos: '" + this.pos() + ", chunkPos: '" + this.chunkPos + "', currentChunk: '" + this.head + "'";
    }
}

