/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import weblogic.utils.Hex;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;

public final class Chunk {
    public static final int DEFAULT_CHUNK_SIZE = 4080;
    public static final int CHUNK_SIZE = Chunk.getChunkSize();
    private static final int DEFAULT_CHUNK_POOL_SIZE = 512;
    private static final String POOL_SIZE_PROPERTY = "weblogic.utils.io.chunkpoolsize";
    private static final Pool chunkPool = new StackPool(Chunk.getPoolSize());
    public final byte[] buf;
    public int end;
    public Chunk next;

    public static int getChunkSize() {
        try {
            int n = Integer.getInteger("weblogic.Chunksize", 4080);
            return n;
        }
        catch (SecurityException securityException) {
            return 4080;
        }
    }

    static int getPoolSize() {
        try {
            return Integer.getInteger(POOL_SIZE_PROPERTY, 512);
        }
        catch (SecurityException securityException) {
            return 512;
        }
    }

    public static Chunk getChunk() {
        Chunk chunk = (Chunk)chunkPool.remove();
        if (chunk == null) {
            chunk = new Chunk();
        }
        return chunk;
    }

    public static void releaseChunk(Chunk chunk) {
        chunk.end = 0;
        chunk.next = null;
        chunkPool.add(chunk);
    }

    Chunk() {
        this.buf = new byte[CHUNK_SIZE];
        this.end = 0;
        this.next = null;
    }

    public Chunk(int n) {
        this.buf = new byte[n];
        this.end = 0;
        this.next = null;
    }

    public static int size(Chunk chunk) {
        int n = 0;
        while (chunk != null) {
            n += chunk.end;
            chunk = chunk.next;
        }
        return n;
    }

    public String toString() {
        return super.toString() + " - end: '" + this.end + "', buf: '" + Hex.dump((byte[])this.buf) + "', next: '" + this.next + "'";
    }
}

