/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import weblogic.utils.collections.NumericValueHashMapEntry;
import weblogic.utils.collections.NumericValueHashMapEnumerator;

public class NumericValueHashMap
implements Cloneable,
Serializable {
    private transient NumericValueHashMapEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public NumericValueHashMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new NumericValueHashMapEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public NumericValueHashMap(int n) {
        this(n, 0.75f);
    }

    public NumericValueHashMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new NumericValueHashMapEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new NumericValueHashMapEnumerator(this.table, false);
    }

    public boolean contains(long l) {
        NumericValueHashMapEntry[] numericValueHashMapEntryArray = this.table;
        int n = numericValueHashMapEntryArray.length;
        while (n-- > 0) {
            NumericValueHashMapEntry numericValueHashMapEntry = numericValueHashMapEntryArray[n];
            while (numericValueHashMapEntry != null) {
                if (numericValueHashMapEntry.value == l) {
                    return true;
                }
                numericValueHashMapEntry = numericValueHashMapEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        NumericValueHashMapEntry[] numericValueHashMapEntryArray = this.table;
        int n = (object.hashCode() & Integer.MAX_VALUE) % numericValueHashMapEntryArray.length;
        NumericValueHashMapEntry numericValueHashMapEntry = numericValueHashMapEntryArray[n];
        while (numericValueHashMapEntry != null) {
            if (numericValueHashMapEntry.key.equals(object)) {
                return true;
            }
            numericValueHashMapEntry = numericValueHashMapEntry.next;
        }
        return false;
    }

    public long get(Object object) {
        NumericValueHashMapEntry[] numericValueHashMapEntryArray = this.table;
        int n = (object.hashCode() & Integer.MAX_VALUE) % numericValueHashMapEntryArray.length;
        NumericValueHashMapEntry numericValueHashMapEntry = numericValueHashMapEntryArray[n];
        while (numericValueHashMapEntry != null) {
            if (numericValueHashMapEntry.key.equals(object)) {
                return numericValueHashMapEntry.value;
            }
            numericValueHashMapEntry = numericValueHashMapEntry.next;
        }
        return 0L;
    }

    protected void rehash() {
        int n = this.table.length;
        NumericValueHashMapEntry[] numericValueHashMapEntryArray = this.table;
        int n2 = n * 2 + 1;
        NumericValueHashMapEntry[] numericValueHashMapEntryArray2 = new NumericValueHashMapEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = numericValueHashMapEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            NumericValueHashMapEntry numericValueHashMapEntry = numericValueHashMapEntryArray[n3];
            while (numericValueHashMapEntry != null) {
                NumericValueHashMapEntry numericValueHashMapEntry2 = numericValueHashMapEntry;
                numericValueHashMapEntry = numericValueHashMapEntry.next;
                int n4 = (numericValueHashMapEntry2.key.hashCode() & Integer.MAX_VALUE) % n2;
                numericValueHashMapEntry2.next = numericValueHashMapEntryArray2[n4];
                numericValueHashMapEntryArray2[n4] = numericValueHashMapEntry2;
            }
        }
    }

    public long put(Object object, long l) {
        if (object == null) {
            throw new NullPointerException();
        }
        NumericValueHashMapEntry[] numericValueHashMapEntryArray = this.table;
        int n = (object.hashCode() & Integer.MAX_VALUE) % numericValueHashMapEntryArray.length;
        NumericValueHashMapEntry numericValueHashMapEntry = numericValueHashMapEntryArray[n];
        while (numericValueHashMapEntry != null) {
            if (numericValueHashMapEntry.key.equals(object)) {
                long l2 = numericValueHashMapEntry.value;
                numericValueHashMapEntry.value = l;
                return l2;
            }
            numericValueHashMapEntry = numericValueHashMapEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, l);
        }
        numericValueHashMapEntry = new NumericValueHashMapEntry();
        numericValueHashMapEntry.key = object;
        numericValueHashMapEntry.value = l;
        numericValueHashMapEntry.next = numericValueHashMapEntryArray[n];
        numericValueHashMapEntryArray[n] = numericValueHashMapEntry;
        ++this.count;
        return 0L;
    }

    public long remove(Object object) {
        NumericValueHashMapEntry[] numericValueHashMapEntryArray = this.table;
        int n = (object.hashCode() & Integer.MAX_VALUE) % numericValueHashMapEntryArray.length;
        NumericValueHashMapEntry numericValueHashMapEntry = numericValueHashMapEntryArray[n];
        NumericValueHashMapEntry numericValueHashMapEntry2 = null;
        while (numericValueHashMapEntry != null) {
            if (numericValueHashMapEntry.key.equals(object)) {
                if (numericValueHashMapEntry2 != null) {
                    numericValueHashMapEntry2.next = numericValueHashMapEntry.next;
                } else {
                    numericValueHashMapEntryArray[n] = numericValueHashMapEntry.next;
                }
                --this.count;
                return numericValueHashMapEntry.value;
            }
            numericValueHashMapEntry2 = numericValueHashMapEntry;
            numericValueHashMapEntry = numericValueHashMapEntry.next;
        }
        return 0L;
    }

    public void clear() {
        NumericValueHashMapEntry[] numericValueHashMapEntryArray = this.table;
        int n = numericValueHashMapEntryArray.length;
        while (--n >= 0) {
            numericValueHashMapEntryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            NumericValueHashMap numericValueHashMap = (NumericValueHashMap)super.clone();
            numericValueHashMap.table = new NumericValueHashMapEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                numericValueHashMap.table[n] = this.table[n] != null ? (NumericValueHashMapEntry)this.table[n].clone() : null;
            }
            return numericValueHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            NumericValueHashMapEntry numericValueHashMapEntry = this.table[i];
            while (numericValueHashMapEntry != null) {
                objectOutputStream.writeObject(numericValueHashMapEntry.key);
                objectOutputStream.writeLong(numericValueHashMapEntry.value);
                numericValueHashMapEntry = numericValueHashMapEntry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new NumericValueHashMapEntry[n3];
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            long l = objectInputStream.readLong();
            this.put(object, l);
            --n2;
        }
    }

    public static void main(String[] stringArray) {
        int n;
        NumericValueHashMap numericValueHashMap = new NumericValueHashMap();
        Random random = new Random(System.currentTimeMillis());
        long[] lArray = new long[10];
        for (n = 0; n < lArray.length; ++n) {
            lArray[n] = random.nextLong();
            String string = String.valueOf(lArray[n]);
            numericValueHashMap.put(string, lArray[n]);
            System.out.println("put: '" + string + "', '" + lArray[n] + "'");
        }
        System.out.println("TABLE: \n" + numericValueHashMap);
        for (n = 0; n < lArray.length; ++n) {
            long l = numericValueHashMap.get(String.valueOf(lArray[n]));
            if (l == 0L) {
                System.err.println("not found: " + lArray[n]);
                continue;
            }
            if (l != lArray[n]) {
                System.err.println(l + "!=" + String.valueOf(lArray[n]));
                continue;
            }
            System.out.println("OK: " + l);
        }
    }
}

