/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.MissingResourceException;
import weblogic.utils.NestedThrowable;

public class StackTraceUtils {
    private static String marker = "\tat ";
    private static String startBanner = "\nStart server side stack trace:\n";
    private static String endBanner = "End  server side stack trace\n";
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$String;

    public static String throwable2StackTrace(Throwable throwable) {
        if (throwable == null) {
            throwable = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        return byteArrayOutputStream.toString();
    }

    public static Throwable getThrowableWithStackTrace(Throwable throwable, boolean bl) {
        String string = throwable.getMessage();
        if (string == null || bl || string.indexOf(marker) == -1) {
            Class[] classArray;
            String string2 = StackTraceUtils.throwable2StackTrace(throwable);
            String string3 = string == null ? startBanner + string2 + endBanner : string + "\n" + startBanner + string2 + endBanner;
            try {
                Field field = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = StackTraceUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).getDeclaredField("detailMessage");
                field.setAccessible(true);
                field.set(throwable, string3);
                return throwable;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (throwable instanceof NestedThrowable) {
                classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StackTraceUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = StackTraceUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable};
                try {
                    Constructor<?> constructor = throwable.getClass().getConstructor(classArray);
                    Throwable throwable2 = ((NestedThrowable)((Object)throwable)).getNested();
                    Object[] objectArray = new Object[]{string3, throwable2};
                    return (Throwable)constructor.newInstance(objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            try {
                classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StackTraceUtils.class$("java.lang.String")) : class$java$lang$String};
                Constructor<?> constructor = throwable.getClass().getConstructor(classArray);
                Object[] objectArray = new Object[]{StackTraceUtils.getComment(throwable, string3)};
                return (Throwable)constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return throwable;
    }

    private static String getComment(Throwable throwable, String string) {
        Serializable serializable;
        if (throwable instanceof ExceptionInInitializerError && (throwable = ((ExceptionInInitializerError)(serializable = (ExceptionInInitializerError)throwable)).getException()) != null) {
            return StackTraceUtils.getThrowableAsString(throwable, string);
        }
        if (throwable instanceof InvocationTargetException && (throwable = ((InvocationTargetException)(serializable = (InvocationTargetException)throwable)).getTargetException()) != null) {
            return StackTraceUtils.getThrowableAsString(throwable, string);
        }
        if (throwable instanceof ParseException) {
            int n = ((ParseException)throwable).getErrorOffset();
            return string + "\nwith error offset = " + n;
        }
        if (throwable instanceof PropertyVetoException && (serializable = ((PropertyVetoException)throwable).getPropertyChangeEvent()) != null) {
            return string + "\nwith property change event = [" + serializable + "]";
        }
        if (throwable instanceof MissingResourceException) {
            serializable = (MissingResourceException)throwable;
            return string + "\nwith class name = [" + ((MissingResourceException)serializable).getClassName() + "]\nand with key = [" + ((MissingResourceException)serializable).getKey() + "]";
        }
        return string;
    }

    private static String getThrowableAsString(Throwable throwable, String string) {
        throwable = StackTraceUtils.getThrowableWithStackTrace(throwable, false);
        return string + "\nwith nested Throwable:\n" + StackTraceUtils.throwable2StackTrace(throwable) + "end nested Throwable\n";
    }

    public static Throwable getThrowableWithCause(Throwable throwable) {
        try {
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StackTraceUtils.class$("java.lang.String")) : class$java$lang$String};
            Constructor<?> constructor = throwable.getClass().getConstructor(classArray);
            Object[] objectArray = new Object[]{throwable.getMessage()};
            Throwable throwable2 = (Throwable)constructor.newInstance(objectArray);
            throwable2.setStackTrace(throwable.getStackTrace());
            StackTraceUtils.setThrowableCause(throwable2, throwable.getCause());
            StackTraceUtils.setThrowableCause(throwable, throwable2);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throwable.setStackTrace(StackTraceUtils.trimStackTrace(new Throwable().getStackTrace(), 1));
        return throwable;
    }

    private static StackTraceElement[] trimStackTrace(StackTraceElement[] stackTraceElementArray, int n) {
        if (stackTraceElementArray.length - n <= 0) {
            return stackTraceElementArray;
        }
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - n];
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            stackTraceElementArray2[i] = stackTraceElementArray[i + n];
        }
        return stackTraceElementArray2;
    }

    private static void setThrowableMessage(Throwable throwable, String string) throws IllegalAccessException {
        try {
            Field field = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = StackTraceUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).getDeclaredField("detailMessage");
            field.setAccessible(true);
            field.set(throwable, string);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new IllegalAccessException("Error setting messsage");
    }

    private static void setThrowableCause(Throwable throwable, Throwable throwable2) throws IllegalAccessException {
        try {
            throwable.initCause(throwable2);
        }
        catch (IllegalStateException illegalStateException) {
            try {
                Field field = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = StackTraceUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).getDeclaredField("cause");
                field.setAccessible(true);
                field.set(throwable, throwable2);
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            throw new IllegalAccessException("Error setting cause");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

