/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import weblogic.utils.AssertionError;
import weblogic.utils.DebugCategory;

public final class Debug {
    private static final boolean DEBUG = false;
    private static final PrintStream out = System.out;
    public static boolean verboseMethods = false;
    public static boolean showLineNumbers = false;
    private static final Hashtable categories;

    private Debug() {
    }

    public static void assertion(boolean bl) {
        if (!bl) {
            throw new AssertionError("Assertion violated");
        }
    }

    public static void assertion(boolean bl, String string) {
        if (!bl) {
            throw new AssertionError(string);
        }
    }

    public static void say(String string) {
        out.println(new StackTrace().location(0).tag(0) + string);
    }

    public static void timestamp(String string) {
        out.println("[" + System.currentTimeMillis() + "] " + string);
    }

    public static void here() {
        out.println("*** " + new StackTrace().location(0).dump() + " ***");
    }

    public static void stackdump() {
        Debug.stackdump("Stack dump:");
    }

    public static void stackdump(String string) {
        new StackTrace().dump(out, string);
    }

    public static void caller(int n) {
        String string = null;
        try {
            string = new StackTrace().location(n).caller();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        out.println("caller(" + n + ") => " + string);
    }

    public static void begin(String string) {
        out.print(string + " ... ");
        out.flush();
    }

    public static void ok() {
        out.println("ok.");
    }

    public static DebugCategory getCategory(String string) {
        DebugCategory debugCategory = (DebugCategory)categories.get(string);
        if (debugCategory != null) {
            return debugCategory;
        }
        debugCategory = new DebugCategory(string);
        categories.put(string, debugCategory);
        String string2 = null;
        try {
            if (System.getProperty(string) != null) {
                debugCategory.setEnabled(true);
            }
            string2 = System.getProperty("weblogic.Debug");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string3 = stringTokenizer.nextToken().trim();
                    int n = string3.indexOf("=");
                    if (n != -1) {
                        string3 = string3.substring(0, n).trim();
                    }
                    if (!string3.equals(string) || debugCategory.isEnabled()) continue;
                    debugCategory.setEnabled(true);
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            }
        }
        return debugCategory;
    }

    public static void attributeChangeNotification(String string, Object object, Object object2) {
        Debug.setCategoryValue(string, object, object2);
    }

    private static void setCategoryValue(String string, Object object, Object object2) {
        DebugCategory debugCategory = Debug.getCategory(string);
        if (object2 != null && object2 instanceof Boolean) {
            debugCategory.setEnabled((Boolean)object2);
        }
    }

    static {
        try {
            verboseMethods = Boolean.getBoolean("debug.methodNames");
            showLineNumbers = Boolean.getBoolean("debug.lineNumbers");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        categories = new Hashtable();
    }

    static final class StackTrace {
        private final Location[] stack;

        StackTrace() {
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            this.stack = new Location[stackTraceElementArray.length - 2];
            for (int i = 2; i < stackTraceElementArray.length; ++i) {
                this.stack[i - 2] = new Location(stackTraceElementArray[i]);
            }
        }

        public Location location(int n) throws ArrayIndexOutOfBoundsException {
            return this.stack[n];
        }

        public void dump(PrintStream printStream, String string) {
            printStream.println(string);
            for (int i = 0; i < this.stack.length; ++i) {
                printStream.flush();
                printStream.println("  " + this.location(i).dump());
            }
        }
    }

    static final class Location {
        private static final String UNKNOWN = "<unknown>";
        private final String pkg;
        private final String clazz;
        private final String method;
        private final String linenum;
        private final String fullClass;
        private final String sourcefile;

        Location(StackTraceElement stackTraceElement) {
            this.fullClass = stackTraceElement.getClassName();
            this.method = stackTraceElement.getMethodName();
            int n = this.fullClass.lastIndexOf(".");
            if (n == -1) {
                this.pkg = UNKNOWN;
                this.clazz = this.fullClass;
            } else {
                this.pkg = this.fullClass.substring(0, n);
                this.clazz = this.fullClass.substring(n + 1);
            }
            this.sourcefile = stackTraceElement.getFileName();
            int n2 = stackTraceElement.getLineNumber();
            this.linenum = n2 > 0 ? String.valueOf(n2) : UNKNOWN;
        }

        public String tag(int n) {
            return "[" + this.clazz + (verboseMethods ? "." + this.method + "()" : "") + (showLineNumbers ? " - " + this.linenum : "") + "] " + (n != 0 ? "(" + n + ")" : "") + ": ";
        }

        public String dump() {
            return this.fullname() + '(' + this.sourcefile + ':' + this.linenum + ')';
        }

        public String caller() {
            return this.fullname() + "(), line " + this.linenum;
        }

        private String fullname() {
            return this.fullClass + '.' + this.method;
        }
    }
}

