/*
 * Decompiled with CFR 0.152.
 */
package o75d.exe.utils;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import o75d.exe.O75Fichero;
import o75d.exe.O75Listado;
import o75d.exe.O75Peticion;
import o75d.exe.utils.O75Buzon;
import o75d.exe.utils.O75Constantes;
import o75d.exe.utils.O75Errores;
import o75d.exe.utils.O75Resultado;
import o75d.exe.utils.O75Servidor;
import o75d.exe.utils.O75UsuarioBuzon;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class O75APIParserXML {
    private Document doc = null;
    private Object o75objeto = null;
    private int nIdTipoOp = 0;
    private String sOperacion = null;
    private String sTipoOperacion = null;
    private String sEstado = null;
    private String sBuzon = null;
    private String sHost = null;
    private boolean bFiltro = false;
    private String sXML = null;

    public O75APIParserXML() {
        this.doc = null;
    }

    public O75APIParserXML(Document pardoc) {
        this.doc = pardoc;
    }

    public boolean EsFiltro() {
        return this.bFiltro;
    }

    public Object GetPetFicLis() {
        return this.o75objeto;
    }

    public Object GetObjeto() {
        return this.o75objeto;
    }

    public String GetTipoOperacion() {
        return this.sTipoOperacion;
    }

    public String GetOperacion() {
        return this.sOperacion;
    }

    public String GetEstado() {
        return this.sEstado;
    }

    public Document GetDocument() {
        return this.doc;
    }

    public O75APIParserXML(String strXml) {
        this.sXML = strXml;
        this.doc = this.DocumentoDeString(strXml);
    }

    public Document DocumentoDeString(String strXml) {
        byte[] buffer = strXml.getBytes();
        ByteArrayInputStream baisXml = new ByteArrayInputStream(buffer);
        try {
            DocumentBuilderFactory dBF = DocumentBuilderFactory.newInstance();
            DocumentBuilder dB = dBF.newDocumentBuilder();
            Document miDoc = dB.parse(baisXml);
            return miDoc;
        }
        catch (Exception e) {
            System.out.println("O75APIParserXML se ha producido una excepcion al transformar XML api a document");
            e.printStackTrace();
            return null;
        }
    }

    public String ValorXMLAPI(String tag) {
        if (null == this.doc) {
            return null;
        }
        NodeList elemento = null;
        tag = tag.trim();
        try {
            elemento = XPathAPI.selectNodeList((Node)this.doc, (String)("/O75/Valores/" + tag + "/text()"));
            if (null == elemento) {
                return null;
            }
            if (1 <= elemento.getLength()) {
                if (null == elemento.item(0)) {
                    return null;
                }
                return elemento.item(0).getNodeValue();
            }
        }
        catch (Exception e) {
            System.out.println("Excepcion buscando etiqueta " + tag);
            return null;
        }
        return null;
    }

    public String ValorCabeceraXMLAPI(String tag) throws Exception {
        if (null == this.doc) {
            return null;
        }
        NodeList elemento = null;
        elemento = XPathAPI.selectNodeList((Node)this.doc, (String)("/O75/Cabecera/" + tag + "/text()"));
        if (1 == elemento.getLength()) {
            return elemento.item(0).getNodeValue();
        }
        return null;
    }

    public O75Resultado ExtraerValores() {
        O75Resultado mError = new O75Resultado(O75Errores.O75API_ERRINDET, "O75APIParserXML.ExtraerValores");
        if (null == this.doc) {
            mError = new O75Resultado(O75Errores.ERR_API_PARSXML, "O75APIParserXML.ExtraerValores. Documento nulo ");
            return mError;
        }
        this.sHost = null;
        this.sOperacion = null;
        this.sTipoOperacion = null;
        this.sEstado = null;
        this.sBuzon = null;
        try {
            this.sOperacion = this.ValorCabeceraXMLAPI("Operacion");
        }
        catch (Exception e3) {
            mError = new O75Resultado(O75Errores.ERR_API_XMLOPERACION, "O75APIParserXML.ExtraerValores. Error parseando XML (operacion)." + e3.getMessage());
            return mError;
        }
        try {
            this.sTipoOperacion = this.ValorCabeceraXMLAPI("Tipo");
        }
        catch (Exception e3) {
            mError = new O75Resultado(O75Errores.ERR_API_XMLTIPO, "O75APIParserXML.ExtraerValores. Error parseando XML (Tipo)." + e3.getMessage());
            return mError;
        }
        try {
            this.sEstado = this.ValorCabeceraXMLAPI("Estado");
        }
        catch (Exception e3) {
            mError = new O75Resultado(O75Errores.ERR_API_XMLTIPO, "O75APIParserXML.ExtraerValores. Error parseando XML (Estado)." + e3.getMessage());
            return mError;
        }
        if (null == this.sOperacion || null == this.sTipoOperacion) {
            mError = new O75Resultado(O75Errores.ERR_API_XMLCABECERA, "O75APIParserXML.ExtraerValores. Error parseando XML (cabecera). Operacion=" + this.sOperacion + " Tipo=" + this.sTipoOperacion);
            return mError;
        }
        this.bFiltro = O75Constantes.API_OPERACIONES[11].equalsIgnoreCase(this.sOperacion);
        boolean bl = this.bFiltro = this.bFiltro || O75Constantes.API_OPERACIONES[12].equalsIgnoreCase(this.sOperacion);
        if (this.bFiltro) {
            return new O75Resultado(O75Errores.O75API_CORRECTO, "O75APIParserXML.ExtraerValores");
        }
        try {
            this.sHost = this.ValorCabeceraXMLAPI("Host");
            this.sBuzon = this.ValorCabeceraXMLAPI("Buzon");
        }
        catch (Exception e) {
            System.out.println("Error en ValorCabeceraXMLAPI " + e.getMessage());
            try {
                this.sHost = null;
                this.sBuzon = this.ValorCabeceraXMLAPI("Buzon");
            }
            catch (Exception e2) {
                System.out.println("Error en ValorCabeceraXMLAPI (e2) " + e2.getMessage());
                mError = new O75Resultado(O75Errores.ERR_API_XMLHOST, "O75APIParserXML.ExtraerValores. Error parseando XML (host,buzon)." + e2.getMessage());
                return mError;
            }
        }
        this.nIdTipoOp = O75Constantes.IdTipoOperacion(this.sTipoOperacion);
        if ((this.nIdTipoOp == 1 || this.nIdTipoOp == 2 || this.nIdTipoOp == 3) && null == this.sBuzon && null == this.sHost) {
            System.out.println("O75APIParserXML.ExtraerValores. Error parseando XML (cabecera). Operacion=" + this.sOperacion + " Tipo=" + this.sTipoOperacion + " Buzon=" + this.sBuzon + " Host=" + this.sHost);
            mError = new O75Resultado(O75Errores.ERR_API_XMLCABECERA, "O75APIParserXML.ExtraerValores. Error parseando XML (cabecera). Operacion=" + this.sOperacion + " Tipo=" + this.sTipoOperacion + " Buzon=" + this.sBuzon + " Host=" + this.sHost);
            return mError;
        }
        return this.RellenarObjeto(this.o75objeto);
    }

    public O75Resultado RellenarObjeto(int nTipo, Object objeto) {
        this.nIdTipoOp = nTipo;
        return this.RellenarObjeto(objeto);
    }

    public O75Resultado RellenarObjeto(Object objeto) {
        System.out.println("Entrando en APIParser.RellenarObjeto. nIdTipoOp=" + this.nIdTipoOp);
        O75Resultado mError = new O75Resultado(O75Errores.O75API_ERRINDET, "O75APIParserXML.RellenarObjeto");
        switch (this.nIdTipoOp) {
            case 1: {
                System.out.println("APIParser.RellenarObjeto: ID_API_TIPOOP_PETICIONES");
                O75Peticion pet = null;
                pet = null == objeto ? new O75Peticion() : (O75Peticion)objeto;
                System.out.println("APIParser.RellenarObjeto: declarada variable O75Peticion pet=(O75Peticion)objeto");
                int nret = O75Errores.O75API_ERRINDET;
                try {
                    pet.SetHost(this.sHost);
                    pet.SetBuzon(this.sBuzon);
                    String sVal = this.ValorXMLAPI("num_trab");
                    if (null != sVal) {
                        pet.num_trab = Integer.parseInt(sVal);
                    }
                    pet.fecha_pet = this.ValorXMLAPI("fecha_pet");
                    pet.id_shell = this.ValorXMLAPI("id_shell");
                    pet.aplicacion = this.ValorXMLAPI("aplicacion");
                    pet.tipo = this.ValorXMLAPI("tipo");
                    pet.subtipo = this.ValorXMLAPI("subtipo");
                    pet.tipo_pet = this.ValorXMLAPI("tipo_pet");
                    if (null == pet.tipo_pet) {
                        pet.tipo_pet = "U";
                    }
                    pet.propietario = this.ValorXMLAPI("propietario");
                    pet.runtime = this.ValorXMLAPI("runtime");
                    pet.descripcion = this.ValorXMLAPI("descripcion");
                    pet.param1 = this.ValorXMLAPI("param1");
                    pet.param2 = this.ValorXMLAPI("param2");
                    sVal = this.ValorXMLAPI("prioridad");
                    pet.prioridad = null != sVal ? Integer.parseInt(sVal) : 1;
                    pet.fecha_min = this.ValorXMLAPI("fecha_min");
                    pet.fecha_max = this.ValorXMLAPI("fecha_max");
                    sVal = this.ValorXMLAPI("intervalo");
                    pet.intervalo = null != sVal ? Integer.parseInt(sVal) : 0;
                    sVal = this.ValorXMLAPI("puerto");
                    pet.puerto = null != sVal ? Integer.parseInt(sVal) : O75Constantes.PUERTOIMPDIR;
                    pet.ip = this.ValorXMLAPI("ip");
                }
                catch (Exception e) {
                    mError = new O75Resultado(O75Errores.ERR_API_PARSXML, "O75APIParserXML. " + e.getMessage());
                    System.out.println("Excepcion parseando peticion " + e.getMessage());
                    e.printStackTrace();
                    return mError;
                }
                this.o75objeto = pet;
                System.out.println("APIParser.RellenarObjeto: ID_API_TIPOOP_PETICIONES. o75objeto es " + (this.o75objeto == null ? "nulo" : " NO nulo"));
                break;
            }
            case 2: {
                O75Listado lis = null;
                lis = null == objeto ? new O75Listado() : (O75Listado)objeto;
                try {
                    String sval2 = this.ValorXMLAPI("num_trab");
                    lis.num_trab = null == sval2 ? 0L : Long.parseLong(sval2);
                    lis.SetHost(this.sHost);
                    lis.SetBuzon(this.sBuzon);
                    lis.fecha_pet = this.ValorXMLAPI("fecha_pet");
                    lis.usuario = this.ValorXMLAPI("usuario");
                    lis.nombre_fich = this.ValorXMLAPI("nombre_fich");
                    lis.path_fich = this.ValorXMLAPI("path_fich");
                    lis.descripcion = this.ValorXMLAPI("descripcion");
                    lis.formato = this.ValorXMLAPI("formato");
                    sval2 = this.ValorXMLAPI("disposicion");
                    lis.disposicion = null == sval2 ? "0" : (1 == Integer.parseInt(sval2) ? "1" : "0");
                    sval2 = this.ValorXMLAPI("reintento");
                    lis.reintento = null == sval2 ? 0 : Integer.parseInt(sval2);
                }
                catch (Exception e) {
                    mError = new O75Resultado(O75Errores.ERR_API_PARSXML, "O75APIParserXML.ExtraerValores. " + e.getMessage());
                    e.printStackTrace();
                    return mError;
                }
                this.o75objeto = lis;
                break;
            }
            case 3: {
                O75Fichero fic = null;
                fic = null == objeto ? new O75Fichero() : (O75Fichero)objeto;
                try {
                    String sval = this.ValorXMLAPI("num_trab");
                    fic.num_trab = null == sval ? 0L : Long.parseLong(sval);
                    fic.SetHost(this.sHost);
                    fic.SetBuzon(this.sBuzon);
                    fic.fecha_pet = this.ValorXMLAPI("fecha_pet");
                    fic.nombre_fich = this.ValorXMLAPI("nombre_fich");
                    fic.path_fich = this.ValorXMLAPI("path_fich");
                    fic.usuario = this.ValorXMLAPI("usuario");
                    fic.descripcion = this.ValorXMLAPI("descripcion");
                    sval = this.ValorXMLAPI("reintento");
                    fic.reintento = null == sval ? 0 : Integer.parseInt(sval);
                }
                catch (Exception e) {
                    mError = new O75Resultado(O75Errores.ERR_API_PARSXML, "O75APIParserXML.ExtraerValores. " + e.getMessage());
                    e.printStackTrace();
                    return mError;
                }
                this.o75objeto = fic;
                break;
            }
            case 4: {
                O75Servidor svr = null;
                svr = null == objeto ? new O75Servidor() : (O75Servidor)objeto;
                try {
                    String sval = this.ValorXMLAPI("codservidor");
                    if (null != sval) {
                        svr.SetCodigo(Long.parseLong(sval));
                    }
                    svr.SetAlias(this.ValorXMLAPI("alias"));
                    svr.SetTnsnames(this.ValorXMLAPI("tnsnames"));
                    svr.SetDescripcion(this.ValorXMLAPI("descservidor"));
                    sval = this.ValorXMLAPI("activo");
                    if (null != sval) {
                        svr.SetEstado(Integer.parseInt(sval));
                    }
                }
                catch (Exception e) {
                    mError = new O75Resultado(O75Errores.ERR_API_PARSXML, e.getMessage());
                    e.printStackTrace();
                    return mError;
                }
                this.o75objeto = svr;
                break;
            }
            case 5: {
                O75Buzon buz = null;
                buz = null == objeto ? new O75Buzon() : (O75Buzon)objeto;
                try {
                    String sval = this.ValorXMLAPI("codbuzon");
                    if (null != sval) {
                        buz.SetCodbuzon(Long.parseLong(sval));
                    }
                    if (null != (sval = this.ValorXMLAPI("codservidor"))) {
                        buz.SetCodservidor(Long.parseLong(sval));
                    }
                    buz.SetBuzon(this.ValorXMLAPI("buzon"));
                    buz.SetDescripcion(this.ValorXMLAPI("descbuzon"));
                    buz.SetOdbcdsn(this.ValorXMLAPI("odbcdsn"));
                }
                catch (Exception e) {
                    mError = new O75Resultado(O75Errores.ERR_API_PARSXML, "O75APIParserXML.ExtraerValores. ID_API_TIPOOP_BUZONES. " + e.getMessage());
                    e.printStackTrace();
                    return mError;
                }
                this.o75objeto = buz;
                break;
            }
            case 6: {
                O75UsuarioBuzon usu = null;
                usu = null == objeto ? new O75UsuarioBuzon() : (O75UsuarioBuzon)objeto;
                try {
                    String sval = this.ValorXMLAPI("codbuzon");
                    if (null != sval) {
                        usu.SetCodbuzon(Long.parseLong(sval));
                    }
                    usu.SetUsuario(this.ValorXMLAPI("usuario"));
                    usu.SetDefecto(this.ValorXMLAPI("defecto"));
                }
                catch (Exception e) {
                    mError = new O75Resultado(O75Errores.ERR_API_PARSXML, "O75APIParser.ExtraerValores. ID_API_TIPOOP_USUARIOS. " + e.getMessage());
                    e.printStackTrace();
                    return mError;
                }
                this.o75objeto = usu;
                break;
            }
            default: {
                mError = new O75Resultado(O75Errores.ERR_API_OPINCORRECTA, "O75APIParserXML.ExtraerValores. Tipo de Operacion incorrecta: " + this.sTipoOperacion);
                return mError;
            }
        }
        return new O75Resultado(O75Errores.O75API_CORRECTO, "O75APIParserXML.ExtraerValores");
    }

    public O75Resultado ParsearXMLResultado(int nTipo, Object objeto) {
        int codigo = O75Errores.O75API_ERRINDET;
        String sMotivo = "";
        try {
            String sVal = this.ValorCabeceraXMLAPI("codigo");
            if (null != sVal) {
                codigo = Integer.parseInt(sVal);
            }
            sMotivo = this.ValorCabeceraXMLAPI("motivo");
        }
        catch (Exception e) {
            sMotivo = "O75Resultado.\nExcepci\u00f3n parseando xml de error: " + e.getMessage() + "\nXML:\n" + this.sXML;
        }
        O75Resultado res = new O75Resultado(codigo, sMotivo);
        if (O75Errores.CORRECTO == codigo) {
            this.RellenarObjeto(nTipo, objeto);
            res.SetObjeto(objeto);
        }
        return res;
    }
}

