/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.xmlnode;

import weblogic.xml.stream.XMLName;
import weblogic.xml.xmlnode.XMLNode;

public final class XMLNodePool {
    private XMLNode[] nodes;
    private int head = 0;
    private int maxSize = 64;

    public XMLNodePool(int n) {
        this.nodes = new XMLNode[n];
    }

    public XMLNodePool(int n, int n2) {
        this.nodes = new XMLNode[n];
        this.maxSize = n2;
    }

    public XMLNode getNodeFromPool() {
        XMLNode xMLNode = null;
        if (this.head > 0) {
            --this.head;
            xMLNode = this.nodes[this.head];
            this.nodes[this.head] = null;
        } else {
            xMLNode = new XMLNode();
        }
        return xMLNode;
    }

    public XMLNode getNodeFromPool(XMLName xMLName) {
        XMLNode xMLNode = this.getNodeFromPool();
        xMLNode.setName(xMLName);
        return xMLNode;
    }

    public boolean returnNodeToPool(XMLNode xMLNode) {
        if (this.nodes.length >= this.maxSize) {
            return false;
        }
        if (this.nodes.length > this.head) {
            this.nodes[this.head] = xMLNode;
            ++this.head;
        } else {
            this.expandPool();
            this.nodes[this.head] = xMLNode;
            ++this.head;
        }
        return true;
    }

    public void expandPool() {
        XMLNode[] xMLNodeArray = new XMLNode[this.nodes.length * 2];
        System.arraycopy(this.nodes, 0, xMLNodeArray, 0, this.nodes.length);
        this.nodes = xMLNodeArray;
    }
}

