/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.xmlnode;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.InputSource;
import weblogic.utils.collections.CircularQueue;
import weblogic.xml.babel.adapters.ElementFactory;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.SymbolTable;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.ChangePrefixMappingEvent;
import weblogic.xml.stream.events.EndPrefixMappingEvent;
import weblogic.xml.stream.events.StartPrefixMappingEvent;
import weblogic.xml.xmlnode.XMLNode;
import weblogic.xml.xmlnode.XMLNodeStreamIterator;

public class XMLNodeInputStream
extends XMLInputStreamBase {
    XMLNodeStreamIterator nodeIterator;
    SymbolTable symbolTable = new SymbolTable();

    public XMLNodeInputStream() {
        this.symbolTable.put("", null);
        this.symbolTable.put("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public XMLNodeInputStream(InputStream inputStream) throws XMLStreamException {
        this();
        this.open(inputStream);
    }

    public XMLNodeInputStream(XMLNode xMLNode) {
        this();
        this.open(xMLNode);
    }

    public static void main(String[] stringArray) throws Exception {
        XMLNodeInputStream xMLNodeInputStream = new XMLNodeInputStream(new FileInputStream(stringArray[0]));
        while (xMLNodeInputStream.hasNext()) {
            XMLEvent xMLEvent = xMLNodeInputStream.next();
            System.out.println(xMLEvent);
            if (xMLEvent.getType() != 2) continue;
        }
    }

    public void open(InputSource inputSource) throws XMLStreamException {
        throw new XMLStreamException("Use open(XMLNode node) to open this stream.");
    }

    public void open(InputSource inputSource, ElementFactory elementFactory) throws XMLStreamException {
        throw new XMLStreamException("Use open(XMLNode node) to open this stream.");
    }

    public void open(InputStream inputStream) throws XMLStreamException {
        XMLNode xMLNode = new XMLNode();
        try {
            xMLNode.read(inputStream);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        this.open(xMLNode);
    }

    public void open(XMLNode xMLNode) {
        this.nodeIterator = new XMLNodeStreamIterator(xMLNode);
        this.elementQ = new CircularQueue(8);
        this.open = true;
    }

    public boolean parseSome() throws XMLStreamException {
        if (debugSubStream) {
            System.out.println("Parsing Some in Node");
        }
        if (this.nodeIterator.hasNext()) {
            Object object;
            Object[] objectArray;
            XMLEvent xMLEvent = this.nodeIterator.next();
            if (xMLEvent.isStartElement()) {
                this.symbolTable.openScope();
                objectArray = (Object[])xMLEvent;
                AttributeIterator attributeIterator = objectArray.getNamespaces();
                while (attributeIterator.hasNext()) {
                    object = attributeIterator.next();
                    String string = object.getName().getLocalName();
                    if (string.equals("xmlns")) {
                        string = "";
                    }
                    this.add(new StartPrefixMappingEvent(string, object.getValue()));
                    this.symbolTable.put(string, object.getValue());
                }
            }
            this.add(xMLEvent);
            if (xMLEvent.isEndElement()) {
                objectArray = this.symbolTable.closeScope();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = (PrefixMapping)objectArray[i];
                    if (((PrefixMapping)object).getUri() == null) {
                        this.add(new EndPrefixMappingEvent(((PrefixMapping)object).getPrefix()));
                        continue;
                    }
                    this.add(new ChangePrefixMappingEvent(((PrefixMapping)object).getOldUri(), ((PrefixMapping)object).getUri(), ((PrefixMapping)object).getPrefix()));
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasNext() throws XMLStreamException {
        if (!this.open) {
            return false;
        }
        if (!this.elementQ.isEmpty()) {
            return true;
        }
        return this.nodeIterator.hasNext();
    }

    public XMLEvent peek() throws XMLStreamException {
        if (!this.elementQ.isEmpty()) {
            return (XMLEvent)this.elementQ.peek();
        }
        this.parseSome();
        return (XMLEvent)this.elementQ.peek();
    }

    public void close() throws XMLStreamException {
        super.close();
        this.nodeIterator = null;
    }
}

