/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stream.util;

import java.io.FileInputStream;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.ReferenceResolver;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLInputStreamFilter;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.NullEvent;
import weblogic.xml.stream.util.NamespaceTypeFilter;
import weblogic.xml.stream.util.TypeFilter;

public class XMLInputStreamFilterBase
implements XMLInputStreamFilter {
    protected XMLInputStream parent;
    protected boolean open = true;
    protected ElementFilter filter;
    private XMLEvent tok;
    private boolean hasTok = false;

    public XMLInputStreamFilterBase() {
    }

    public XMLInputStreamFilterBase(XMLInputStream xMLInputStream, ElementFilter elementFilter) throws XMLStreamException {
        this.setParent(xMLInputStream);
        this.filter = elementFilter;
    }

    public void setFilter(ElementFilter elementFilter) {
        this.filter = elementFilter;
    }

    protected XMLEvent modify(XMLEvent xMLEvent) throws XMLStreamException {
        return xMLEvent;
    }

    public void pushBack(XMLEvent xMLEvent) throws XMLStreamException {
        this.tok = xMLEvent;
        this.hasTok = true;
    }

    public XMLEvent next() throws XMLStreamException {
        if (this.hasTok) {
            this.hasTok = false;
            return this.tok;
        }
        if (this.hasNext()) {
            return this.modify(this.parent.next());
        }
        return new NullEvent();
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.hasTok) {
            return true;
        }
        if (!this.open) {
            return false;
        }
        while (this.parent.hasNext()) {
            if (this.filter.accept(this.parent.peek())) {
                return true;
            }
            this.parent.next();
        }
        return false;
    }

    public void skip() throws XMLStreamException {
        if (this.open) {
            this.next();
        }
    }

    public void skipElement() throws XMLStreamException {
        if (this.open) {
            this.parent.skipElement();
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        if (!this.open) {
            return new NullEvent();
        }
        if (this.hasTok) {
            return this.tok;
        }
        if (this.hasNext()) {
            return this.modify(this.parent.peek());
        }
        return new NullEvent();
    }

    public boolean skip(int n) throws XMLStreamException {
        if (!this.open) {
            return false;
        }
        while (this.parent.skip(n)) {
            if (this.filter.accept(this.parent.peek())) {
                return true;
            }
            this.parent.next();
        }
        return false;
    }

    public boolean skip(XMLName xMLName) throws XMLStreamException {
        if (!this.open) {
            return false;
        }
        while (this.parent.skip(xMLName)) {
            if (this.filter.accept(this.parent.peek())) {
                return true;
            }
            this.parent.next();
        }
        return false;
    }

    public boolean skip(XMLName xMLName, int n) throws XMLStreamException {
        if (!this.open) {
            return false;
        }
        while (this.parent.skip(xMLName, n)) {
            if (this.filter.accept(this.parent.peek())) {
                return true;
            }
            this.parent.next();
        }
        return false;
    }

    public XMLInputStream getSubStream() throws XMLStreamException {
        return new XMLInputStreamFilterBase(this.parent.getSubStream(), this.filter);
    }

    public void close() throws XMLStreamException {
        this.parent.close();
        this.parent = null;
        this.open = false;
    }

    public XMLInputStream getParent() {
        return this.parent;
    }

    public void setParent(XMLInputStream xMLInputStream) throws XMLStreamException {
        if (xMLInputStream == null) {
            throw new XMLStreamException("Unable to set XMLInputStreamFilterBase.parent to null");
        }
        this.parent = xMLInputStream;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.parent.setReferenceResolver(referenceResolver);
    }

    public ReferenceResolver getReferenceResolver() {
        return this.parent.getReferenceResolver();
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        System.out.println("REGULAR");
        xMLInputStreamBase.open(SAXElementFactory.createInputSource(stringArray[0]));
        while (xMLInputStreamBase.hasNext()) {
            object3 = xMLInputStreamBase.next();
            System.out.print("EVENT: " + object3.getTypeAsString() + " [");
            System.out.print(object3);
            System.out.println("]");
        }
        System.out.println("FILTERED");
        xMLInputStreamBase.open(SAXElementFactory.createInputSource(stringArray[0]));
        object3 = new XMLInputStreamFilterBase(xMLInputStreamBase, new TypeFilter(22));
        while (((XMLInputStreamFilterBase)object3).hasNext()) {
            object2 = ((XMLInputStreamFilterBase)object3).next();
            System.out.print("EVENT: " + object2.getTypeAsString() + " [");
            System.out.print(object2);
            System.out.println("]");
        }
        System.out.println("FILTERED NS");
        xMLInputStreamBase.open(SAXElementFactory.createInputSource(stringArray[0]));
        object2 = null;
        if (xMLInputStreamBase.skip(1024)) {
            object = (StartPrefixMapping)xMLInputStreamBase.next();
            object2 = object.getNamespaceUri();
            System.out.println("Filtering on" + (String)object2);
        }
        object3 = new XMLInputStreamFilterBase(xMLInputStreamBase, (ElementFilter)new NamespaceTypeFilter((String)object2, 22));
        while (((XMLInputStreamFilterBase)object3).hasNext()) {
            object = ((XMLInputStreamFilterBase)object3).next();
            System.out.print("EVENT: " + object.getTypeAsString() + " [");
            System.out.print(object);
            System.out.println("]");
        }
        System.out.println("Testing use case");
        object = XMLInputStreamFactory.newInstance();
        TypeFilter typeFilter = new TypeFilter(22);
        XMLInputStream xMLInputStream = ((XMLInputStreamFactory)object).newInputStream(new FileInputStream(stringArray[0]), (ElementFilter)typeFilter);
        while (xMLInputStream.hasNext()) {
            XMLEvent xMLEvent = xMLInputStream.next();
            System.out.print("EVENT: " + xMLEvent.getTypeAsString() + " [");
            System.out.print(xMLEvent);
            System.out.println("]");
        }
    }
}

