/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stream.util;

import java.io.StringReader;
import weblogic.utils.collections.CircularQueue;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.ReferenceResolver;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputOutputStream;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.NullEvent;
import weblogic.xml.stream.events.StartElementEvent;
import weblogic.xml.stream.util.TypeFilter;
import weblogic.xml.stream.util.XMLSubStreamBase;

public class XMLInputOutputStreamBase
implements XMLInputOutputStream {
    protected CircularQueue elementQ = new CircularQueue(8);
    protected StartElementEvent lastStartElement = null;
    protected ReferenceResolver resolver = null;

    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        if (xMLEvent.isStartElement()) {
            this.lastStartElement = !(xMLEvent instanceof StartElementEvent) ? new StartElementEvent((StartElement)xMLEvent) : (StartElementEvent)xMLEvent;
            this.elementQ.add(this.lastStartElement);
            return;
        }
        this.lastStartElement = null;
        this.elementQ.add(xMLEvent);
    }

    public void add(Attribute attribute) throws XMLStreamException {
        if (this.lastStartElement == null) {
            throw new XMLStreamException("Attempt to add an attribute to a null start element");
        }
        if (this.isNamespace(attribute)) {
            this.lastStartElement.addNamespace(attribute);
        } else {
            this.lastStartElement.addAttribute(attribute);
        }
    }

    private boolean isNamespace(Attribute attribute) {
        XMLName xMLName = attribute.getName();
        if (xMLName == null) {
            return false;
        }
        String string = xMLName.getPrefix();
        if (string != null && "xmlns".equals(string)) {
            return true;
        }
        String string2 = xMLName.getLocalName();
        return string == null && string2 != null && "xmlns".equals(string2);
    }

    public void add(XMLInputStream xMLInputStream) throws XMLStreamException {
        while (xMLInputStream.hasNext()) {
            this.add(xMLInputStream.next());
        }
    }

    public void add(String string) throws XMLStreamException {
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newInputStream(new StringReader(string), (ElementFilter)new TypeFilter(8318));
        this.add(xMLInputStream);
    }

    public void flush() throws XMLStreamException {
    }

    public XMLEvent next() throws XMLStreamException {
        return (XMLEvent)this.elementQ.remove();
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.elementQ == null) {
            return false;
        }
        return !this.elementQ.isEmpty();
    }

    public void skip() throws XMLStreamException {
        this.next();
    }

    public void skipElement() throws XMLStreamException {
        int n = 0;
        boolean bl = false;
        while (this.hasNext() && !bl) {
            XMLEvent xMLEvent = this.next();
            switch (xMLEvent.getType()) {
                case 2: {
                    ++n;
                    break;
                }
                case 4: {
                    if (--n > 0) break;
                    bl = true;
                    break;
                }
                case 128: 
                case 512: {
                    bl = true;
                }
            }
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        if (!this.elementQ.isEmpty()) {
            return (XMLEvent)this.elementQ.peek();
        }
        return new NullEvent();
    }

    public boolean skip(int n) throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent xMLEvent = this.peek();
            if (xMLEvent == null) {
                return false;
            }
            if (xMLEvent.getType() == 128) {
                return false;
            }
            if ((xMLEvent.getType() & n) != 0) {
                return true;
            }
            this.next();
        }
        return false;
    }

    protected boolean matchName(XMLName xMLName, XMLName xMLName2) {
        if (xMLName == null || xMLName2 == null) {
            return false;
        }
        if (xMLName.getNamespaceUri() != null && xMLName.getNamespaceUri().equals(xMLName2.getNamespaceUri())) {
            if (xMLName.getLocalName() != null) {
                return xMLName.getLocalName().equals(xMLName2.getLocalName());
            }
            return true;
        }
        if (xMLName.getLocalName() != null) {
            return xMLName.getLocalName().equals(xMLName2.getLocalName());
        }
        return false;
    }

    public boolean skip(XMLName xMLName) throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent xMLEvent = this.peek();
            switch (xMLEvent.getType()) {
                case 2: 
                case 4: {
                    if (!this.matchName(xMLName, xMLEvent.getName())) break;
                    return true;
                }
            }
            this.next();
        }
        return false;
    }

    public boolean skip(XMLName xMLName, int n) throws XMLStreamException {
        while (this.skip(xMLName)) {
            XMLEvent xMLEvent = this.peek();
            if ((xMLEvent.getType() & n) != 0) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public XMLInputStream getSubStream() throws XMLStreamException {
        return new XMLSubStreamBase((XMLInputStream)this);
    }

    public void close() throws XMLStreamException {
        this.elementQ = null;
    }

    public void close(boolean bl) throws XMLStreamException {
        this.close();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.resolver = referenceResolver;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.resolver;
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputOutputStreamBase xMLInputOutputStreamBase = new XMLInputOutputStreamBase();
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.open(SAXElementFactory.createInputSource(stringArray[0]));
        xMLInputOutputStreamBase.add(xMLInputStreamBase);
        while (xMLInputOutputStreamBase.hasNext()) {
            System.out.println(xMLInputOutputStreamBase.next());
        }
    }
}

