/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stream.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.utils.collections.CombinedIterator;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.Location;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.events.AttributeIteratorImpl;
import weblogic.xml.stream.events.ElementEvent;
import weblogic.xml.stream.events.EmptyIterator;

public class StartElementEvent
extends ElementEvent
implements StartElement {
    protected List attributes;
    protected List namespaces;
    protected Map namespaceURIs;
    private static final EmptyIterator emptyIterator = new EmptyIterator();

    public StartElementEvent() {
        this.init();
    }

    public StartElementEvent(XMLName xMLName) {
        this.init();
        this.name = xMLName;
    }

    public StartElementEvent(XMLName xMLName, Location location) {
        this.init();
        this.name = xMLName;
        this.location = location;
    }

    public StartElementEvent(StartElement startElement) {
        this.init();
        this.name = startElement.getName();
        this.location = startElement.getLocation();
        AttributeIterator attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            this.addAttribute(attributeIterator.next());
        }
        attributeIterator = startElement.getNamespaces();
        while (attributeIterator.hasNext()) {
            this.addNamespace(attributeIterator.next());
        }
    }

    protected void init() {
        this.type = 2;
    }

    public AttributeIterator getAttributes() {
        if (this.attributes == null) {
            return emptyIterator;
        }
        return new AttributeIteratorImpl(this.attributes.iterator());
    }

    public AttributeIterator getNamespaces() {
        if (this.namespaces == null) {
            return emptyIterator;
        }
        return new AttributeIteratorImpl(this.namespaces.iterator());
    }

    public AttributeIterator getAttributesAndNamespaces() {
        if (this.attributes == null) {
            if (this.namespaces == null) {
                return emptyIterator;
            }
            return new AttributeIteratorImpl(this.namespaces.iterator());
        }
        if (this.namespaces == null) {
            return new AttributeIteratorImpl(this.attributes.iterator());
        }
        CombinedIterator combinedIterator = new CombinedIterator(this.namespaces.iterator(), this.attributes.iterator());
        return new AttributeIteratorImpl(combinedIterator);
    }

    public Attribute getAttributeByName(XMLName xMLName) {
        AttributeIterator attributeIterator = this.getAttributes();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            if (!(xMLName.getNamespaceUri() == null ? xMLName.getLocalName().equals(attribute.getName().getLocalName()) : xMLName.getNamespaceUri().equals(attribute.getName().getNamespaceUri()) && xMLName.getLocalName().equals(attribute.getName().getLocalName()))) continue;
            return attribute;
        }
        return null;
    }

    public void setAttributes(List list) {
        this.attributes = list;
    }

    public void addAttribute(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(attribute);
    }

    public void addNamespace(Attribute attribute) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        this.namespaces.add(attribute);
    }

    public String getNamespaceUri(String string) {
        if (this.namespaceURIs == null) {
            return null;
        }
        return (String)this.namespaceURIs.get(string);
    }

    public void setTransientNamespaceMap(Map map) {
        if (this.namespaces != null && this.namespaces.iterator().hasNext()) {
            this.setNamespaceMap(map);
        } else {
            this.namespaceURIs = map;
        }
    }

    public void setNamespaceMap(Map map) {
        if (map == null) {
            return;
        }
        this.namespaceURIs = new HashMap();
        this.namespaceURIs.putAll(map);
    }

    public Map getNamespaceMap() {
        return this.namespaceURIs;
    }

    public String toString() {
        String string = "<" + this.name;
        AttributeIterator attributeIterator = this.getAttributesAndNamespaces();
        while (attributeIterator.hasNext()) {
            string = string + " " + attributeIterator.next().toString();
        }
        string = string + ">";
        return string;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof StartElement)) {
            return false;
        }
        StartElement startElement = (StartElement)object;
        return this.getAttributesAndNamespaces().equals(startElement.getAttributesAndNamespaces());
    }
}

